/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.TextObject;

public class TextConstructor
extends ObjectConstructor {
    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        TextObject textObject = new TextObject(zirkelCanvas.getConstruction(), d2, d3);
        zirkelCanvas.addObject(textObject);
        textObject.setDefaults();
        textObject.edit(zirkelCanvas);
        zirkelCanvas.repaint();
    }

    public boolean waitForPoint() {
        return false;
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.text"));
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Text")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("x") || !xmlTag.hasParam("y")) {
            throw new ConstructionException("Point coordinates missing!");
        }
        TextObject textObject = new TextObject(construction, 0.0, 0.0);
        try {
            double d2 = new Expression(xmlTag.getValue("x"), construction, textObject).getValue();
            double d3 = new Expression(xmlTag.getValue("y"), construction, textObject).getValue();
            textObject.move(d2, d3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName(xmlTag, textObject);
        this.set(xmlTree, textObject);
        construction.add(textObject);
        this.setConditionals(xmlTree, construction, textObject);
        textObject.setLines(textObject.getText());
        if (xmlTag.hasParam("fixed")) {
            textObject.setFixed(xmlTag.getValue("x"), xmlTag.getValue("y"));
        }
        return true;
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        this.showStatus(zirkelCanvas);
    }
}

