# Numpy integration improvements

## Add Python logic to enable module import at vtk module load

This feature is mostly driven by the @override capability in Python to automatically enhance native vtk class with some Python one.

By default we have added those following dependencies:
- vtkCommonDataModel: vtkmodules.util.data_model
- vtkCommonExecutionModel: vtkmodules.util.execution_model

But now a user is able to add to it by calling `vtkmodules.register_vtk_module_dependencies(vtk_module_name, *import_strings)` to automate imports at vtk module loading.

## Make numpy optional for vtkmodules.util.data_model

`vtkmodules.util.data_model` has been added to enhance vtkDataModel API for Python using the @override infrastructure to mainly handle numpy in/out manipulation. But since numpy is an optional dependency for VTK, we are providing a downgraded version when numpy is not available so we can keep automatically load it at module startup regardless of numpy presence.
