% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_grouped_data}
\alias{as_grouped_data}
\title{Add row separators to grouped data}
\usage{
as_grouped_data(x, groups, columns = NULL, expand_single = TRUE)
}
\arguments{
\item{x}{dataset}

\item{groups}{columns names to be used as row separators.}

\item{columns}{columns names to keep}

\item{expand_single}{if FALSE, groups with only one
row will not be expanded with a title row. If TRUE (the
default), single row groups and multi-row groups are all
restructured.}
}
\description{
Repeated consecutive values of group columns will
be used to define the title of the groups and will
be added as a row title.
}
\examples{
# as_grouped_data -----
library(data.table)
CO2 <- CO2
setDT(CO2)
CO2$conc <- as.integer(CO2$conc)

data_co2 <- dcast(CO2, Treatment + conc ~ Type,
  value.var = "uptake", fun.aggregate = mean
)
data_co2
data_co2 <- as_grouped_data(x = data_co2, groups = c("Treatment"))
data_co2
}
\seealso{
\code{\link[=as_flextable.grouped_data]{as_flextable.grouped_data()}}
}
