# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicesdatareplication.aio import RecoveryServicesDataReplicationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesDataReplicationMgmtFabricAgentOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesDataReplicationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fabric_agent_get(self, resource_group):
        response = await self.client.fabric_agent.get(
            resource_group_name=resource_group.name,
            fabric_name="str",
            fabric_agent_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fabric_agent_begin_create(self, resource_group):
        response = await (
            await self.client.fabric_agent.begin_create(
                resource_group_name=resource_group.name,
                fabric_name="str",
                fabric_agent_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "authenticationIdentity": {
                            "aadAuthority": "str",
                            "applicationId": "str",
                            "audience": "str",
                            "objectId": "str",
                            "tenantId": "str",
                        },
                        "customProperties": "fabric_agent_model_custom_properties",
                        "machineId": "str",
                        "machineName": "str",
                        "resourceAccessIdentity": {
                            "aadAuthority": "str",
                            "applicationId": "str",
                            "audience": "str",
                            "objectId": "str",
                            "tenantId": "str",
                        },
                        "correlationId": "str",
                        "healthErrors": [
                            {
                                "affectedResourceCorrelationIds": ["str"],
                                "affectedResourceType": "str",
                                "category": "str",
                                "causes": "str",
                                "childErrors": [
                                    {
                                        "category": "str",
                                        "causes": "str",
                                        "code": "str",
                                        "creationTime": "2020-02-20 00:00:00",
                                        "healthCategory": "str",
                                        "isCustomerResolvable": bool,
                                        "message": "str",
                                        "recommendation": "str",
                                        "severity": "str",
                                        "source": "str",
                                        "summary": "str",
                                    }
                                ],
                                "code": "str",
                                "creationTime": "2020-02-20 00:00:00",
                                "healthCategory": "str",
                                "isCustomerResolvable": bool,
                                "message": "str",
                                "recommendation": "str",
                                "severity": "str",
                                "source": "str",
                                "summary": "str",
                            }
                        ],
                        "isResponsive": bool,
                        "lastHeartbeat": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "versionNumber": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fabric_agent_begin_delete(self, resource_group):
        response = await (
            await self.client.fabric_agent.begin_delete(
                resource_group_name=resource_group.name,
                fabric_name="str",
                fabric_agent_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fabric_agent_list(self, resource_group):
        response = self.client.fabric_agent.list(
            resource_group_name=resource_group.name,
            fabric_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
