# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementTasksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_list(self, resource_group):
        response = self.client.tasks.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-03-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_get(self, resource_group):
        response = self.client.tasks.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_create(self, resource_group):
        response = self.client.tasks.create(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_name="str",
            task_create_parameters={
                "location": "str",
                "agentConfiguration": {"cpu": 0},
                "agentPoolName": "str",
                "creationDate": "2020-02-20 00:00:00",
                "credentials": {
                    "customRegistries": {
                        "str": {
                            "identity": "str",
                            "password": {"type": "str", "value": "str"},
                            "userName": {"type": "str", "value": "str"},
                        }
                    },
                    "sourceRegistry": {"identity": "str", "loginMode": "str"},
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isSystemTask": False,
                "logTemplate": "str",
                "name": "str",
                "platform": {"os": "str", "architecture": "str", "variant": "str"},
                "provisioningState": "str",
                "status": "str",
                "step": "task_step_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "timeout": 3600,
                "trigger": {
                    "baseImageTrigger": {
                        "baseImageTriggerType": "str",
                        "name": "str",
                        "status": "str",
                        "updateTriggerEndpoint": "str",
                        "updateTriggerPayloadType": "str",
                    },
                    "sourceTriggers": [
                        {
                            "name": "str",
                            "sourceRepository": {
                                "repositoryUrl": "str",
                                "sourceControlType": "str",
                                "branch": "str",
                                "sourceControlAuthProperties": {
                                    "token": "str",
                                    "tokenType": "str",
                                    "expiresIn": 0,
                                    "refreshToken": "str",
                                    "scope": "str",
                                },
                            },
                            "sourceTriggerEvents": ["str"],
                            "status": "str",
                        }
                    ],
                    "timerTriggers": [{"name": "str", "schedule": "str", "status": "str"}],
                },
                "type": "str",
            },
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_delete(self, resource_group):
        response = self.client.tasks.delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_update(self, resource_group):
        response = self.client.tasks.update(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_name="str",
            task_update_parameters={
                "agentConfiguration": {"cpu": 0},
                "agentPoolName": "str",
                "credentials": {
                    "customRegistries": {
                        "str": {
                            "identity": "str",
                            "password": {"type": "str", "value": "str"},
                            "userName": {"type": "str", "value": "str"},
                        }
                    },
                    "sourceRegistry": {"identity": "str", "loginMode": "str"},
                },
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "logTemplate": "str",
                "platform": {"architecture": "str", "os": "str", "variant": "str"},
                "status": "str",
                "step": "task_step_update_parameters",
                "tags": {"str": "str"},
                "timeout": 0,
                "trigger": {
                    "baseImageTrigger": {
                        "name": "str",
                        "baseImageTriggerType": "str",
                        "status": "str",
                        "updateTriggerEndpoint": "str",
                        "updateTriggerPayloadType": "str",
                    },
                    "sourceTriggers": [
                        {
                            "name": "str",
                            "sourceRepository": {
                                "branch": "str",
                                "repositoryUrl": "str",
                                "sourceControlAuthProperties": {
                                    "expiresIn": 0,
                                    "refreshToken": "str",
                                    "scope": "str",
                                    "token": "str",
                                    "tokenType": "str",
                                },
                                "sourceControlType": "str",
                            },
                            "sourceTriggerEvents": ["str"],
                            "status": "str",
                        }
                    ],
                    "timerTriggers": [{"name": "str", "schedule": "str", "status": "str"}],
                },
            },
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tasks_get_details(self, resource_group):
        response = self.client.tasks.get_details(
            resource_group_name=resource_group.name,
            registry_name="str",
            task_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...
