/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef MAINBOARD_GPIO_H
#define MAINBOARD_GPIO_H

#include <soc/gpio.h>

#ifndef __ACPI__

/* Pad configuration in ramstage. */
static const struct pad_config gpio_table[] = {
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A1, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPP_A2, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPP_A3, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPP_A4, NATIVE, DEEP, NF1),
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_A7, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPP_A10, DN_20K, DEEP, NF1),
	PAD_CFG_GPI_APIC_HIGH(GPP_A11, NONE, DEEP),
	PAD_CFG_GPO(GPP_A12, 1, PWROK),
	PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A15, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A19, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A20, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_A21, NONE, DEEP, NF1),
	PAD_CFG_GPO(GPP_A22, 1, DEEP),
	PAD_CFG_GPI_APIC_HIGH(GPP_A23, NONE, DEEP),
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B2, NONE, DEEP, NF1),
	PAD_CFG_GPI_APIC_HIGH(GPP_B3, NONE, PLTRST),
	PAD_CFG_GPO(GPP_B4, 1, DEEP),
	PAD_CFG_NF(GPP_B5, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B6, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B7, NONE, DEEP, NF1),
	PAD_NC(GPP_B8, NONE),
	PAD_CFG_NF(GPP_B9, NONE, DEEP, NF1),
	PAD_NC(GPP_B10, NONE),
	PAD_CFG_NF(GPP_B11, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	PAD_CFG_TERM_GPO(GPP_B14, 1, DN_20K, DEEP),
	PAD_CFG_GPO(GPP_B15, 0, DEEP),
	PAD_NC(GPP_B16, NONE),
	PAD_CFG_GPI_SCI(GPP_B17, DN_20K, DEEP, EDGE_SINGLE, INVERT),
	PAD_CFG_GPI_SCI(GPP_B18, UP_20K, PLTRST, LEVEL, INVERT),
	PAD_NC(GPP_B19, NONE),
	PAD_CFG_NF(GPP_B20, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPP_B21, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPP_B22, DN_20K, DEEP, NF1),
	PAD_CFG_TERM_GPO(GPP_B23, 1, DN_20K, DEEP),
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C1, DN_20K, DEEP, NF1),
	PAD_CFG_TERM_GPO(GPP_C2, 1, DN_20K, DEEP),
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),
	PAD_CFG_GPI_APIC_LOW(GPP_C5, DN_20K, DEEP),
	PAD_CFG_NF(GPP_C8, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C9, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C10, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C11, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C12, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C14, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C15, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C21, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D2, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D3, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D4, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_D9, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D10, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D11, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_D12, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_NF(GPP_D13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D14, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D15, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D16, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D19, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D20, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D21, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D22, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_D23, NONE, DEEP, NF1),
	PAD_CFG_GPI_SCI(GPP_E0, NONE, DEEP, EDGE_SINGLE, INVERT),
	PAD_CFG_NF(GPP_E1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E2, NONE, DEEP, NF1),
	PAD_CFG_GPIO_BIDIRECT(GPP_E3, 0, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_NF(GPP_E4, NONE, PWROK, NF1),
	PAD_CFG_GPI_SCI(GPP_E5, NONE, PLTRST, EDGE_SINGLE, INVERT),
	PAD_CFG_GPO(GPP_E6, 0, DEEP),
	PAD_CFG_GPI_DUAL_ROUTE(GPP_E7, NONE, PLTRST, LEVEL, NONE, IOAPIC, SCI),
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1),
	PAD_CFG_GPO(GPP_E9, 0, DEEP),
	PAD_CFG_TERM_GPO(GPP_E10, 1, DN_20K, DEEP),
	PAD_CFG_TERM_GPO(GPP_E11, 1, DN_20K, DEEP),
	PAD_NC(GPP_E12, NONE),
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),
	PAD_CFG_GPI_SMI(GPP_E15, NONE, DEEP, EDGE_SINGLE, INVERT),
	PAD_CFG_GPI_SCI(GPP_E16, NONE, PLTRST, LEVEL, INVERT),
	PAD_CFG_NF(GPP_E17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E18, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E19, DN_20K, DEEP, NF1),
	PAD_CFG_NF(GPP_E20, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_E21, DN_20K, DEEP, NF1),
	PAD_CFG_GPI_APIC_LOW(GPP_E22, NONE, DEEP),
	PAD_CFG_TERM_GPO(GPP_E23, 0, DN_20K, PLTRST),
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F3, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F4, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F5, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F6, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F7, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F8, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F9, NONE, DEEP, NF1),
	PAD_CFG_NF_1V8(GPP_F10, NONE, DEEP, NF2),
	PAD_CFG_NF_1V8(GPP_F11, NONE, DEEP, NF2),
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_F13, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F14, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_F15, NONE, DEEP, OFF, ACPI),
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F17, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F18, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F19, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F20, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F21, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_F22, NONE, DEEP, NF1),
	PAD_CFG_GPI_APIC_HIGH(GPP_F23, NONE, DEEP),
	PAD_CFG_NF(GPP_G0, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G1, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G2, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G3, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G4, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G5, NONE, DEEP, NF1),
	PAD_CFG_NF(GPP_G6, NONE, DEEP, NF1),
	PAD_CFG_GPI_TRIG_OWN(GPP_G7, NONE, DEEP, OFF, ACPI),
};

#endif /* __ACPI__ */

#endif /* MAINBOARD_GPIO_H */
