+++
title = "Triangular ripples in a lattice"
weight = 60
+++

### Triangular Ripples in a Rectangular Lattice

Scattering from elongated particles positioned in a two-dimensional rectangular lattice.

* Each particle has a triangular profile ("Ripple2" form factor) with a length of $100$ nm, a width of $20$ nm and a height of $4$ nm.
* They are placed along a rectangular lattice on top of a substrate.
* This lattice is characterized by a lattice length of $200$ nm in the direction of the long axis of the particles and of $50$ nm in the perpendicular direction.
* The lattice's base vectors coincide with the reference Cartesian frame.
* The wavelength is equal to 0.16 nm.
* The incident angles are $\alpha\_i = 0.3 ^{\circ}$ and $\varphi\_i = 0^{\circ}$.

View the example on [Cosine Ripples on a Rectangular Lattice](/ref/sample/interference/grating/cosine-ripples-at-rect-lattice) for comparison.

{{< galleryscg >}}
{{< figscg src="/img/auto/scatter2d/TriangularRipple.png" width="4500px" caption="Scattering intensity">}}
{{< /galleryscg >}}

{{< show-ex file="scatter2d/TriangularRipple.py" >}}
