#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Jacek Szafarkiewicz
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Aragami
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250707.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='aragami'
GAME_NAME='Aragami'

ARCHIVE_BASE_GOG_1_NAME='aragami_en_01_09_20943.sh'
ARCHIVE_BASE_GOG_1_MD5='46c8315350a4036dcc09b6c3946ddc02'
ARCHIVE_BASE_GOG_1_SIZE='6917228'
ARCHIVE_BASE_GOG_1_VERSION='01.09-gog20943'
ARCHIVE_BASE_GOG_1_URL='https://www.gog.com/game/aragami'

ARCHIVE_BASE_GOG_0_NAME='gog_aragami_2.9.0.12.sh'
ARCHIVE_BASE_GOG_0_MD5='42d0952de9b0373786f2902aa596b4ff'
ARCHIVE_BASE_GOG_0_SIZE='6800000'
ARCHIVE_BASE_GOG_0_VERSION='01.08-gog2.9.0.12'

# The following installers used to be available from humblebundle.com,
# but they now sell Steam keys only.

ARCHIVE_BASE_HUMBLE_1_NAME='Aragami_Linux_Universal_01_09.zip'
ARCHIVE_BASE_HUMBLE_1_MD5='b5e779366b1b221bb56bb93fc2e155d2'
ARCHIVE_BASE_HUMBLE_1_SIZE='6916236'
ARCHIVE_BASE_HUMBLE_1_VERSION='01.09-humble1'

ARCHIVE_BASE_HUMBLE_0_NAME='aragami_01_08_Linux.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='4be0b7f674eec62184df216fcaba77b5'
ARCHIVE_BASE_HUMBLE_0_SIZE='6800000'
ARCHIVE_BASE_HUMBLE_0_VERSION='01.08-humble170503'

UNITY3D_NAME='Aragami'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE_1='01_09'
CONTENT_PATH_DEFAULT_HUMBLE_0='.'
CONTENT_GAME_DATA_SHARED_FILES="
${UNITY3D_NAME}_Data/globalgamemanagers
${UNITY3D_NAME}_Data/globalgamemanagers.assets
${UNITY3D_NAME}_Data/level2
${UNITY3D_NAME}_Data/level5
${UNITY3D_NAME}_Data/level6
${UNITY3D_NAME}_Data/level8
${UNITY3D_NAME}_Data/level11
${UNITY3D_NAME}_Data/level13
${UNITY3D_NAME}_Data/level14
${UNITY3D_NAME}_Data/level16
${UNITY3D_NAME}_Data/level18
${UNITY3D_NAME}_Data/level19
${UNITY3D_NAME}_Data/level19.resS
${UNITY3D_NAME}_Data/level20
${UNITY3D_NAME}_Data/level21
${UNITY3D_NAME}_Data/Managed/Assembly-CSharp.dll
${UNITY3D_NAME}_Data/resources.assets
${UNITY3D_NAME}_Data/Resources/unity_builtin_extra
${UNITY3D_NAME}_Data/sharedassets2.assets
${UNITY3D_NAME}_Data/sharedassets5.assets
${UNITY3D_NAME}_Data/sharedassets6.assets
${UNITY3D_NAME}_Data/sharedassets7.assets
${UNITY3D_NAME}_Data/sharedassets8.assets
${UNITY3D_NAME}_Data/sharedassets9.assets
${UNITY3D_NAME}_Data/sharedassets10.assets
${UNITY3D_NAME}_Data/sharedassets11.assets
${UNITY3D_NAME}_Data/sharedassets13.assets
${UNITY3D_NAME}_Data/sharedassets14.assets
${UNITY3D_NAME}_Data/sharedassets15.assets
${UNITY3D_NAME}_Data/sharedassets17.assets
${UNITY3D_NAME}_Data/sharedassets18.assets
${UNITY3D_NAME}_Data/sharedassets18.assets.resS
${UNITY3D_NAME}_Data/sharedassets19.assets
${UNITY3D_NAME}_Data/sharedassets19.assets.resS"

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA_SHARED
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_SHARED'

PKG_DATA_SHARED_ID="${PKG_DATA_ID}-shared"
PKG_DATA_SHARED_PROVIDES="
$PKG_DATA_SHARED_ID"
PKG_DATA_SHARED_DESCRIPTION='data shared between base game and expansion'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
