#include "captions/vbilut.h"

#include <array>

static constexpr std::array<const uint16_t,256> hammtab
{
    0x0101, 0x100f, 0x0001, 0x0101, 0x100f, 0x0100, 0x0101, 0x100f,
    0x100f, 0x0102, 0x0101, 0x100f, 0x010a, 0x100f, 0x100f, 0x0107,
    0x100f, 0x0100, 0x0101, 0x100f, 0x0100, 0x0000, 0x100f, 0x0100,
    0x0106, 0x100f, 0x100f, 0x010b, 0x100f, 0x0100, 0x0103, 0x100f,
    0x100f, 0x010c, 0x0101, 0x100f, 0x0104, 0x100f, 0x100f, 0x0107,
    0x0106, 0x100f, 0x100f, 0x0107, 0x100f, 0x0107, 0x0107, 0x0007,
    0x0106, 0x100f, 0x100f, 0x0105, 0x100f, 0x0100, 0x010d, 0x100f,
    0x0006, 0x0106, 0x0106, 0x100f, 0x0106, 0x100f, 0x100f, 0x0107,
    0x100f, 0x0102, 0x0101, 0x100f, 0x0104, 0x100f, 0x100f, 0x0109,
    0x0102, 0x0002, 0x100f, 0x0102, 0x100f, 0x0102, 0x0103, 0x100f,
    0x0108, 0x100f, 0x100f, 0x0105, 0x100f, 0x0100, 0x0103, 0x100f,
    0x100f, 0x0102, 0x0103, 0x100f, 0x0103, 0x100f, 0x0003, 0x0103,
    0x0104, 0x100f, 0x100f, 0x0105, 0x0004, 0x0104, 0x0104, 0x100f,
    0x100f, 0x0102, 0x010f, 0x100f, 0x0104, 0x100f, 0x100f, 0x0107,
    0x100f, 0x0105, 0x0105, 0x0005, 0x0104, 0x100f, 0x100f, 0x0105,
    0x0106, 0x100f, 0x100f, 0x0105, 0x100f, 0x010e, 0x0103, 0x100f,
    0x100f, 0x010c, 0x0101, 0x100f, 0x010a, 0x100f, 0x100f, 0x0109,
    0x010a, 0x100f, 0x100f, 0x010b, 0x000a, 0x010a, 0x010a, 0x100f,
    0x0108, 0x100f, 0x100f, 0x010b, 0x100f, 0x0100, 0x010d, 0x100f,
    0x100f, 0x010b, 0x010b, 0x000b, 0x010a, 0x100f, 0x100f, 0x010b,
    0x010c, 0x000c, 0x100f, 0x010c, 0x100f, 0x010c, 0x010d, 0x100f,
    0x100f, 0x010c, 0x010f, 0x100f, 0x010a, 0x100f, 0x100f, 0x0107,
    0x100f, 0x010c, 0x010d, 0x100f, 0x010d, 0x100f, 0x000d, 0x010d,
    0x0106, 0x100f, 0x100f, 0x010b, 0x100f, 0x010e, 0x010d, 0x100f,
    0x0108, 0x100f, 0x100f, 0x0109, 0x100f, 0x0109, 0x0109, 0x0009,
    0x100f, 0x0102, 0x010f, 0x100f, 0x010a, 0x100f, 0x100f, 0x0109,
    0x0008, 0x0108, 0x0108, 0x100f, 0x0108, 0x100f, 0x100f, 0x0109,
    0x0108, 0x100f, 0x100f, 0x010b, 0x100f, 0x010e, 0x0103, 0x100f,
    0x100f, 0x010c, 0x010f, 0x100f, 0x0104, 0x100f, 0x100f, 0x0109,
    0x010f, 0x100f, 0x000f, 0x010f, 0x100f, 0x010e, 0x010f, 0x100f,
    0x0108, 0x100f, 0x100f, 0x0105, 0x100f, 0x010e, 0x010d, 0x100f,
    0x100f, 0x010e, 0x010f, 0x100f, 0x010e, 0x000e, 0x100f, 0x010e,
};

static constexpr std::array<const uint8_t,256> hamm84tab
{
    255,255,255,255,255,255,255,255,255,  0, //   0 -   9
    255,  8,255,255,255,255,255,255,255,255, //  10 -  19
    255,255,255,255,255,255,255,255,  6,255, //  20 -  29
     14,255,255,255,255,255, 12,255,  4,255, //  30 -  39
    255,255,255,255,255,255,255,255,255, 10, //  40 -  49
    255,  2,255,255,255,255,255,255,255,255, //  50 -  59
    255,255,255,255,  1,255,  9,255,255,255, //  60 -  69
    255,255,255,255,255,255,255,255,255,255, //  70 -  79
    255,255,255,255,255,  7,255, 15,255,255, //  80 -  89
    255,255,255,255,255,255,255,255,255,255, //  90 -  99
    255,255,255,255,255,255,255,255,255, 13, // 100 - 109
    255,  5,255,255,255,255,255,255,255,255, // 110 - 119
     11,255,  3,255,255,255,255,255,255,255, // 120 - 129
    255,255,255, 12,255,  4,255,255,255,255, // 130 - 139
    255,255,255,255, 10,255,  2,255,255,255, // 140 - 149
    255,255,255,255,255,255,255,255,255,255, // 150 - 159
    255,255,255,255,255,255,255,255,  0,255, // 160 - 169
      8,255,255,255,255,255,255,255,255,255, // 170 - 179
    255,255,255,255,255,255,255,255,255,  6, // 180 - 189
    255, 14,255,255,255,255,255,255,255,255, // 190 - 199
    255,255,255,255, 13,255,  5,255,255,255, // 200 - 209
    255,255,255,255,255,255,255, 11,255,  3, // 210 - 219
    255,255,255,255,255,  1,255,  9,255,255, // 220 - 229
    255,255,255,255,255,255,255,255,255,255, // 230 - 239
    255,255,255,255,  7,255, 15,255,255,255, // 240 - 249
    255,255,255,255,255,255 };                // 250 - 255

int hamm8(const uint8_t *p, int *err)
{
    int a = hammtab[p[0]];
    *err += a;
    return a & 15;
}

int hamm84(const uint8_t *p, int *err)
{
    int a = hamm84tab[p[0]];

    if (a == 255)
        *err = 1;

    return a;
}

int hamm16(const uint8_t *p, int *err)
{
    int a = hammtab[p[0]];
    int b = hammtab[p[1]];
    *err += a;
    *err += b;
    return (a & 15) | ((b & 15) * 16);
}
