/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;

public class PathTool
extends BezierTool {
    private static final boolean DEBUG = false;
    private SVGPathFigure pathPrototype;

    public PathTool(SVGPathFigure sVGPathFigure, SVGBezierFigure sVGBezierFigure) {
        this(sVGPathFigure, sVGBezierFigure, null);
    }

    public PathTool(SVGPathFigure sVGPathFigure, SVGBezierFigure sVGBezierFigure, Map<AttributeKey, Object> map) {
        super(sVGBezierFigure, map);
        this.pathPrototype = sVGPathFigure;
    }

    protected SVGPathFigure createPath() {
        SVGPathFigure sVGPathFigure = this.pathPrototype.clone();
        this.getEditor().applyDefaultAttributesTo(sVGPathFigure);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                sVGPathFigure.set((AttributeKey)entry.getKey(), entry.getValue());
            }
        }
        return sVGPathFigure;
    }

    @Override
    protected void finishCreation(BezierFigure bezierFigure, DrawingView drawingView) {
        drawingView.getDrawing().remove(bezierFigure);
        SVGPathFigure sVGPathFigure = this.createPath();
        sVGPathFigure.removeAllChildren();
        sVGPathFigure.add(bezierFigure);
        drawingView.getDrawing().add(sVGPathFigure);
        this.fireUndoEvent(sVGPathFigure, drawingView);
        drawingView.addToSelection(sVGPathFigure);
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }
}

