###################################################################################################
# _language.py
#
# $Id: _language.py,v 1.8 2004/01/27 21:39:49 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.8 $
#
# Implementation of class Language (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

class Language:
    
    dctLangStr = {
	   'TAB_ACCESS':{'ger':'Zugriff', 'eng':'Access','fra':'Accs','esp':'Acceso','ita':'Accesso','chi':' ','fas':''},
	   'TAB_CONFIGURATION':{'ger':'Konfiguration', 'eng':'Configuration','fra':'Configuration','esp':'Configuracin','ita':'Configurazione','chi':'','fas':'?'},
	   'TAB_DESIGN':{'ger':'Design', 'eng':'Design','fra':'Conception','chi':'','fas':''},
	   'TAB_EDIT':{'ger':'Bearbeiten', 'eng':'Edit','fra':'Edit','esp':'Editar','ita':'Stampare','chi':'༭','fas':''},
	   'TAB_FILTER':{'ger':'Filter', 'eng':'Filter','fas':''},
	   'TAB_HELP':{'ger':'Hilfe', 'eng':'Help','chi':'','fas':'?'},
	   'TAB_HISTORY':{'ger':'Historie', 'eng':'History','fra':'Histoire','esp':'Historia','ita':'Storia','chi':'ʷ'},
	   'TAB_IMPORTEXPORT':{'ger':'Im/Export', 'eng':'Im/Export','fra':'Im/Exportation','esp':'Im/Exportacin','ita':'Im/Exportazione','chi':'/','fas':'/'},
	   'TAB_LANGUAGES':{'ger':'Sprachen', 'eng':'Languages','fra':'Langues','esp':'Lenguas','ita':'Lingue','chi':'','fas':''},
	   'TAB_LAYOUT':{'ger':'Layout', 'eng':'Layout','chi':'','fas':''},
	   'TAB_LIVE':{'ger':'Live', 'eng':'Live','chi':'ʵ ','fas':''},
	   'TAB_LOCKED':{'ger':'Geperrt', 'eng':'Locked','chi':'','fas':''},
	   'TAB_METACMD':{'ger':'Aktionen', 'eng':'Actions', 'fra':'Actions', 'esp':'Acciones', 'ita':'Azioni','chi':' ','fas':''},
	   'TAB_METADATA':{'ger':'Metadaten', 'eng':'Metadata','chi':'Ԫ','fas':' '},
	   'TAB_METAOBJ':{'ger':'Spez. Objekte', 'eng':'Spec. Objects', 'fra':'Objets spc.', 'esp':'Objetos espec.', 'ita':'Oggetti spec.','chi':'','fas':' '},
	   'TAB_METAPATTERN':{'ger':'Module', 'eng':'Modules', 'fra':'Modules', 'esp':'Mdulos', 'ita':'Moduli','chi':'Ī ','fas':'ǎ '},
	   'TAB_OWNERSHIP':{'ger':'Eigentmer', 'eng':'Ownership', 'fra':'Proprit', 'esp':'Propiedad', 'ita':'Propriet','chi':'Ȩ','fas':''},
	   'TAB_PREVIEW':{'ger':'Vorschau', 'eng':'Preview', 'fra':'Prvision', 'esp':'Previo', 'ita':'Previsione','chi':'Ԥ','fas':'? '},
	   'TAB_PROPERTIES':{'ger':'Eigenschaften', 'eng':'Properties', 'fra':'Proprits', 'esp':'Propiedades', 'ita':'Propriet','chi':'','fas':''},
	   'TAB_REFERENCES':{'ger':'Linkquellen', 'eng':'Linksources','fra':'Sources de lien','esp':'Fuentes del acoplamiento','ita':'Fonti di collegamento','chi':'Դ','fas':' ?'},
	   'TAB_SEARCH':{'ger':'Suche', 'eng':'Search','fra':'Recherche','esp':'Bsqueda','ita':'Ricerca','chi':'','fas':''},
	   'TAB_SECURITY':{'ger':'Sicherheit', 'eng':'Security','fra':'scurit','esp':'Seguridad','ita':'Sicurezza','chi':'ȫ','fas':''},
	   'TAB_SITEMAP':{'ger':'Sitemap', 'eng':'Sitemap','chi':'վͼ','fas':' '}, 
	   'TAB_SYSTEM':{'ger':'System', 'eng':'System','fas':' '},
	   'TAB_TASKS':{'ger':'Aufgaben', 'eng':'Tasks','fra':'Tches','esp':'Tareas','ita':'Mansioni','chi':'','fas':''},
	   'TAB_TEXTFORMAT':{'ger':'Formate', 'eng':'Formats','chi':'ʽ','fas':''},
	   'TAB_WAIT':{'ger':'Bitte warten', 'eng':'Please wait'},  # NEW!
	   'TAB_WORKFLOW':{'ger':'Workflow', 'eng':'Workflow'},
	   
	   'MSG_CHANGED':{'ger':'nderungen gesichert.','eng':'Saved changes.','fra':'Changements sauvs.','esp':'Cambios ahorrados.','ita':'Cambiamenti conservati.','chi':'ѱ'},
	   'MSG_PASTED':{'ger':'Aus Zwischenablage eingefgt.','eng':'Pasted from clipboard.','chi':'Ӽ'},
	   'MSG_CONFIRM_DESCENDANT_LANGS':{'ger':'Diese Aktion kann sich auf abhngige Sprachen (%s) auswirken. Wollen Sie trotzdem fortfahren?','eng':'This action may affect descendant languages (%s). Do you want to proceed anyway?','chi':'Ӱ (%s) ǷҪ?'},
	   'MSG_CONFIRM_DISCARD_CHANGES':{'ger':'Sollen Eingaben verworfen werden?','eng':'Do you really want to discard changes?','fra':'Voulez-vous vraiment jeter des changements?','esp':'Usted realmente desea desechar cambios?','ita':'Realmente desiderate scartare i cambiamenti?','chi':'ǷҪ?'},
	   'MSG_CONFIRM_CUTOBJS':{'ger':'Soll(en) %i ausgewhlte(s) Objekt(e) wirklich ausgeschnitten werden?','eng':'Do you really want to cut %i selected object(s)?','chi':'ȷʵҪ %i ѡ?'},
	   'MSG_CONFIRM_TRASHOBJS':{'ger':'Soll(en) %i ausgewhlte(s) Objekt(e) wirklich in den Papierkorb verschoben werden?','eng':'Do you really want to move %i selected object(s) to trashcan?','chi':'ȷʵҪ %i ѡվ?'},
	   'MSG_CONFIRM_DELOBJS':{'ger':'Soll(en) %i ausgewhlte(s) Objekt(e) wirklich gelscht werden?','eng':'Do you really want to delete %i selected object(s)?','chi':'ȷʵҪɾ %i ѡ?'},
	   'MSG_CONFIRM_DELOBJ':{'ger':'Soll Objekt wirklich gelscht werden?','eng':'Do you really want to delete object?','fra':'Voulez-vous vraiment supprimer l\'objet?','esp':'Usted realmente desea suprimir el objeto?','ita':'Realmente desiderate cancellare l\'oggetto?','chi':'ȷʵҪɾ?'},
	   'MSG_DELETED':{'ger':'%i Objekt(e) gelscht.','eng':'%i Object(s) deleted.','chi':'%i ɾ'},
	   'MSG_TRASHED':{'ger':'%i Objekt(e) in den Papierkorb verschoben.','eng':'%i Object(s) moved to trashcan.','chi':'%i ѷվ'},
           'MSG_EMPTYCONTAINER':{'ger':'Es gibt keine Objekte in','eng':'There are currently no items in','chi':'ûĿ...'},
	   'MSG_EXCEPTION':{'ger':'Es ist ein Ausnahmefehler aufgetreten','eng':'An exception occured','chi':'ִ'},
           'MSG_NOREFERENCES':{'ger':'Es gibt keine internen Referenzen auf %s','eng':'There are currently no internal references to %s','fra':'Il n\'y a aucune rfrence interne  %s','esp':'No hay referencias internas a %s','ita':'Non ci sono riferimenti interni a %s','chi':'û%s ăȲ'},
           'MSG_REFERENCEDBY':{'ger':'%s wird referenziert von','eng':'%s is referenced by','chi':' %s ...'},
	   'MSG_EXPORTED':{'ger':'%s exportiert.','eng':'%s successfully exported.','chi':'%s ѵ'},
	   'MSG_IMPORTED':{'ger':'Datei %s importiert.','eng':'File %s successfully imported.','chi':'%s ļѵ'},
	   'MSG_INSERTED':{'ger':'%s eingefgt.','eng':'%s inserted.','chi':'%s Ѳ'},
	   'MSG_NOITEMSSPECIFIED':{'ger':'Es wurden keine Eintrge ausgewhlt!','eng':'No items were specified!','chi':' δָĿ'},
           'MSG_NOTASKS':{'ger':'Es gibt keine Aufgaben in','eng':'There are currently no tasks in','chi':' ... û'},
	   'MSG_MOVEDOBJDOWN':{'ger':'%s nach unten verschoben.','eng':'Moved %s down.','chi':'%s '},
	   'MSG_MOVEDOBJUP':{'ger':'%s nach oben verschoben.','eng':'Moved %s up.','chi':'%s '},
	   'MSG_REQUIRED':{'ger':"Feld '%s' mu einen Wert haben!",'eng':"Missing value for field '%s'!",'chi':'Ҫ %s ֶεֵ'},
	   'MSG_ACCESS_FORBIDDEN':{'ger':'Zugriff auf %s nicht erlaubt!','eng':'Access to %s forbidden!'},
	   'MSG_UPLOADED':{'ger':'Datei hochgeladen.','eng':'File uploaded.','chi':'ļ'},
	   'MSG_AFTER_INSERT':{'ger':'ndern erst nach Einfgen von %s!','eng':'Can be changed after insert of %s!','chi':'Ȳ %s, ٴθ'},
	   'MSG_REPLACE':{'ger':'Soll >%s< durch >%s< ersetzt werden?','eng':'Replace >%s< by >%s<?','chi':' ǷҪ %t  %s '},
	   'MSG_REPLACEALL':{'ger':'Sollen alle %i Vorkommnisse von >%s< ausgezeichnet werden?','eng':'Replace all %i occurances of >%s<?','chi':'Ҫ %i  %s ȡ'},
	   'MSG_MAX_ROWS_EXCEEDED':
	     {'ger':'Hinweis:<br/>Aufgrund Ihrer Angaben wurden %i Datenstze (max. %i) gefunden. Bitte berprfen Sie, ob sich Ihre Suchanfrage durch weitere Eingaben noch weiter eingrenzen lt.'
             ,'eng':'Warning:<br/>%i records (max. %i) have been found.'},
	   'MSG_FTP':{
	   'ger':' \
Geben Sie hier die Zugangsdaten fr den FTP-Export der kompletten WWW-Site \
zu Ihrem Provider an. Geben Sie im Feld IP-Adresse / Domne den DNS-Eintrag Ihrer \
Domne an (beispielsweise <b>www.mydomain.de</b>). Mit Export starten Sie den FTP-Exportvorgang.\
           ','eng':' \
Please enter the access parameters for the FTP-export of the whole WWW-Site \
to your provider. Please enter the DNS-name of your domain into the field IP / Domain \
(e.g. <b>www.mydomain.org</b>). Push export to start the FTP-export process. \
           ','chi':' FTP-ʲվװṩ̵ķ "IP-ַ/" ֶ DNS  磺<em>www.mydomain.com</em> ڵοʼ'},
	   'MSG_INACTIVE':{
	   'ger':' \
<p class="form-small">S E R V E R - F E H L E R</p> \
<p class="ftStrong">Dokument nicht gefunden</p> \
<hr> \
<p>Die von Ihnen gewhlte Adresse/URL ist auf unserem Server nicht bzw. nicht mehr vorhanden.</p> \
<p>Mglicherweise haben Sie einen veralteten Link bzw. ein altes Bookmark verwendet. \
Versuchen Sie den von Ihnen gewnschten Inhalt ber unsere Homepage oder ber unser Archiv zu finden.</p> \
<p>Wenn Sie einem Link in unserem Angebot gefolgt sind, versuchen Sie es bitte in einigen Minuten noch einmal.</p> \
<p>Sollten Sie noch weitere Fragen zu unserem Angebot haben, so schauen Sie bitte in die Hilfe oder schreiben Sie uns eine E-Mail.</p> \
','eng':' \
<p class="form-small">S E R V E R - E R R O R</p> \
<p class="ftStrong">Document not found</p> \
<hr> \
<p>The document you requested does not exist on this server.</p> \
<p>Please double check the URL or use the search function on this page to find what you are looking for.</p> \
<p>If you know you have the correct URL but are encountering an error, please let our Webmaster know. Thank you. </p> \
','chi':' \
<p class="form-small"></p> \
<p class="ftStrong"> Ҳļ </p> \
<hr> \
<p>ļڡ</p> \
<p>뷵ҳڵٴβҡ </p> \
<p>ӣ뼸Ժԡ</p> \
<p>Ļ뵥""ʼǡ </p> \
	   '},           
	   'MSG_UNDOVERSION':
	     {'ger':'Unten sehen Sie die Historie aller Arbeitsversionen dieses Objekts. Sie knnen das Objekt auf eine frhere Version zurcksetzen.'
             ,'eng':'Below you see the history of all work-versions of this objects. You can reset this object to an earlier version.'
             ,'chi':'ʾöİ汾ʷ Իָڵİ汾'},
	   'MSG_ROLLBACKVERSIONCHANGES':
	     {'ger':'Mit Zurcknehmen lschen Sie unwiderruflich die Arbeitsversion und ersetzen diese durch die aktuelle Liveversion!'
             ,'eng':'Rollback irrevocably replaces the working version with the current live version!'
             ,'chi':'"ת"ȡԹ汾浱ǰʵ汾'},
	   'MSG_DTMLGENERATOR':
	     {'ger':'Generierung von DTML-Code per Mausklick auf das Icon rechts neben der jeweiligen Attribut-Definition!'
             ,'eng':'Generate DTML-code by clicking the icon right next to the attribute definiton!'
             ,'chi':'Ϊ DTML-룬뵥ԶԵͼꡣ'},
	   'MSG_MULTILANG':
	     {'ger':'In der symmetrischen Multilingualitt wird fr jede Sprache eine identische Variante der Objekte des Content-Baums angelegt.'
	     ,'eng':'In symmetrical multiligualism an identic variant of the content tree objects is realized for every language.'
	     ,'chi':'ڶԳƵĶZԻΪÿԴͬΪ.'},
	   'MSG_MULTILANGDICT':
	     {'ger':'Im Wrterbuch werden Schlsselwrter fr multilinguale Templates hinterlegt.'
	     ,'eng':'Register keywords for multilingual templates in the dictionary.'
	     ,'chi':'ڴʵжԵĹؼΪǼǡ'},
	   'MSG_METADICT':
	     {'ger':'Metadaten sind przise Informationen ber (meta) den Inhalt des Dokuments; sie charakterisieren den Inhalt mithilfe eines festgelegten Satzes an Beschreibungs-Elementen (z.B. Titel, Autor, Datum, Verleger, Schlagworte etc.).'
             ,'eng':'Metadata are precise information about (meta) the document content. They characterize the content with the help of a fixed number of description elements (e.g. title, author, date, editor, subjects etc.).'
             ,'chi':'ԪݰļȷеϢԪù̶Ԫдļݣ磺⣬ߣڣߣؼʵȣ'},     
	   'MSG_METACMD':
	     {'ger':'Hier knnen Sie Ihre eigenen Aktionen und Funktionen fr ZMS-Objekte definieren.'
             ,'eng':'Define your own custom actions and functions on ZMS objects.'
             ,'chi':'ڴܹԼĲ͹ܡ'},
	   'MSG_WORKFLOW':
	     {'ger':'Hier knnen Sie Ihren eigenen Workflow fr ZMS-Objekte definieren.'
             ,'eng':'Define your own custom workflow on ZMS objects.'},
	   'MSG_FILTER':
	     {'ger':'Hier knnen Sie Ihren eigenen Im/Export-Filter fr ZMS-Objekte und serverseitige Batch-Prozesse definieren.'
             ,'eng':'Define your own custom im/export-filters for ZMS objects and server-side batch-processes.'},
	   'MSG_METAPATTERN':
	     {'ger':'Module sind Ihre eigenen frei konfigurierbaren und vorstrukturierten ZMS-Entwurfsmuster (z.B. Newsletter, Diskussionsforum).'
	     ,'eng':'Modules allow you to define your own custom structured ZMS design-patterns (e.g. newsletter, bulletin-boards).'
	     ,'chi':'ģԶZMSģ壨磺ʱͨѶ̳ȣ'},
	   'MSG_METAOBJ':{
	   'ger':' \
Spezielle Objekte sind Ihre eigenen frei konfigurierbaren und vorstrukturierten ZMS-Objekte. \
Objekte werden direkt im Textkrper dargestellt, Dokumente stellen eigene Seiten dar und Teaser-Elemente werden im Teaser dargestellt. \
           ','eng':' \
Special objects allow you to define your own custom structured ZMS objects. \
Objects are displayed in the textbody, documents represent pages and teaserelements are diplay in the teaser. \
           ','chi':'󴴽ԶZMS󡣶ʾļҳ棬ĿԪĿʾ'},
           
	   'OPT_ATTR_DC_TYPE':{
	   'ger':'Home\nChannel\nArtikel\nNews\nResource\nTermin',\
	   'eng':'Home\nChannel\nArticle\nNews\nResource\nDate'},
	   'OPT_ATTR_CHANNEL':{
	   'ger':'News\nProdukte\nService\nPartner\nFirma',\
	   'eng':'News\nProducts\nService\nPartners\nCompany'},
	   
           'LITERATURE_REFERENCE_ONLY':{'ger':'nur fr Literaturreferenz','eng':'literature reference only','chi':'ѧο'},
           
	   'ATTR_ACTION':{'ger':'Aktion','eng':'Action','fra':'l\'action','esp':'la accin','chi':''},
	   'ATTR_ACTIVE':{'ger':'aktiv','eng':'active','fra':'Actif','esp':'Activo','chi':''},
	   'ATTR_ASC':{'ger':'aufsteigend','eng':'ascending','chi':' '},
           'ATTR_ATTR':{'ger':'Attribut','eng':'Attribute','fra':'Attribut','esp':'Atributo','chi':''},
           'ATTR_ATTRS':{'ger':'Attribute','eng':'Attributes','fra':'Attributs','esp':'Atributos','chi':''},
	   'ATTR_ATTRS_SPEC':{'ger':'Spezielle Attribute','eng':'Special Attributes','chi':''},
	   'ATTR_AUTHOR':{'ger':'Autor','eng':'Author','fra':'Auteur','esp':'Autor','chi':''},
	   'ATTR_AUTHORS':{'ger':'Autoren','eng':'Authors','fra':'Auteurs','esp':'Autores','chi':''},
	   'ATTR_AVAILABLE':{'ger':'vorhanden','eng':'available','chi':''},
	   'ATTR_BGCOLOR':{'ger':'Hintergrundfarbe','eng':'Background Color','chi':'ɫ'},
	   'ATTR_BGCOLORS':{'ger':'Hintergrundfarben','eng':'Background Colors','chi':'ɫ'},
	   'ATTR_BGCOLOR_BORDER':{'ger':'Rahmen','eng':'Border','fra':'Encadrer','chi':'߿'},
	   'ATTR_BGCOLOR_TEXT':{'ger':'Text','eng':'Text','fra':'Texte','esp':'Texto','chi':''},
	   'ATTR_BGCOLOR_TITLE':{'ger':'Titel','eng':'Title','fra':'Titre','esp':'Ttulo','chi':''},
	   'ATTR_BORDERSTYLE':{'ger':'Rahmen','eng':'Borderstyle','fra':'Encadrer','chi':'߿'},
	   'ATTR_CACHEABLE':{'ger':'Cacheable','eng':'Cacheable','chi':'ɸٻ'},
	   'ATTR_CALENDAR':{'ger':'Kalender','eng':'Calendar','fra':'Calendrier','esp':'Calendario','chi':''},
	   'ATTR_CAPTION':{'ger':'Beschriftung','eng':'Caption','esp':'Ttulo','chi':''},
	   'ATTR_CELL':{'ger':'Zelle','eng':'Cell','fra':'Cellule','esp':'Clula','chi':'Ԫ'},
	   'ATTR_CHANGES':{'ger':'nderungen','eng':'Modifications','fra':'Changements','esp':'Modificaciones','chi':'','fas':''},
	   'ATTR_CHANNEL':{'ger':'Channel','eng':'Channel','esp':'Canal','chi':'ͨ','fas':''},
	   'ATTR_CHECKED_OUT':{'ger':'In Bearbeitung','eng':'Checked out','chi':' ǩ','fas':''},
	   'ATTR_COL':{'ger':'Spalte', 'eng':'Column', 'chi':''},
	   'ATTR_COLS':{'ger':'Spalten', 'eng':'Columns', 'fra':'Colonnes', 'esp':'Columnas', 'chi':'' },
	   'ATTR_COMMANDLINE':{'ger':'Kommandozeile', 'eng':'Command-line' },
	   'ATTR_COMPACTVIEW':{'ger':'Kompakt-Ansicht','eng':'Compact-view'},
	   'ATTR_CONFIRM':{'ger':'Wiederholung','eng':'Confirm','chi':'ȷ'},
	   'ATTR_CUSTOM':{'ger':'Benutzerdefiniert','eng':'Custom','chi':'Զ'},
	   'ATTR_DATE':{'ger':'Datum','eng':'Date','fra':'Date','esp':'Fecha','chi':''},
	   'ATTR_DATEFORMAT':{'ger':'Datumsformat','eng':'Date format','chi':'ڸʽ'},
	   'ATTR_DAYS':{'ger':'Tage','eng':'Days'},
	   'ATTR_DC_COVERAGE':{'ger':'Reichweite','eng':'Coverage','fra':'Envergure','esp':'Cobertura','chi':'Χ'},
	   'ATTR_DC_DESCRIPTION':{'ger':'Zusammenfassung','eng':'Description','fra':'Description','esp':'Descripcin','chi':''},
	   'ATTR_DEFAULT':{'ger':'Default','eng':'Default','fra':'Dfaut','esp':'Falta','chi':'Ĭ'},
	   'ATTR_DESC':{'ger':'absteigend','eng':'descending','chi':''},
	   'ATTR_DESCRIPTION':{'ger':'Beschreibung','eng':'Description','fra':'Description','esp':'Descripcin','chi':''},
	   'ATTR_DETAILS':{'ger':'Details','eng':'Details'},
	   'ATTR_DICTIONARY':{'ger':'Wrterbuch','eng':'Dictionary','chi':'ʵ'},
	   'ATTR_DISPLAY':{'ger':'Anzeige','eng':'Display','chi':'ʾ'},
	   'ATTR_EMAIL':{'ger':'E-Mail','eng':'E-Mail','chi':'ʼ'},
	   'ATTR_END_DAT':{'ger':'bis','eng':'until','fra':'jusqu\'','esp':'hasta','chi':''},
	   'ATTR_FK':{'ger':'Fremdschlssel','eng':'Foreign key'},
	   'ATTR_LEVELNFC':{'ger':'Gliederung','eng':'Subsections','chi':''},
	   'ATTR_EXPORT':{'ger':'Export','eng':'Export','chi':''},
	   'ATTR_FGCOLOR':{'ger':'Vordergrundfarbe','eng':'Foreground Color','chi':'ǰɫ'},
	   'ATTR_FILE':{'ger':'Datei','eng':'File','fra':'Fichier','esp':'Archivo','chi':'ļ'},
	   'ATTR_FILTER':{'ger':'Filter','eng':'Filter','chi':'ɸѡ'},
	   'ATTR_FORMAT':{'ger':'Format','eng':'Format','fra':'Format','esp':'Formato','chi':'ʽ'},
	   'ATTR_GARBAGE_COLLECTION':{'ger':'Mllabfuhr','eng':'Garbage collection'},
	   'ATTR_HEIGHT':{'ger':'Hhe','eng':'Height','fra':'Hauteur','esp':'Altura','chi':'߶'},
	   'ATTR_ID':{'ger':'Id','eng':'Id','fra':'Id','esp':'Id','chi':'ID'},
	   'ATTR_IMAGE':{'ger':'Bild','eng':'Image','fra':'Image','esp':'Imagen','chi':'ͼ'},
	   'ATTR_IMGALIGN':{'ger':'Bildausrichtung','eng':'Image alignment','chi':'ͼ'},
	   'ATTR_HIRES':{'ger':'HighRes','eng':'HighRes','chi':'߽'},
	   'ATTR_SUPERRES':{'ger':'SuperRes','eng':'SuperRes','chi':'߽'},
	   'ATTR_IMPORT':{'ger':'Import','eng':'Import','chi':''},
	   'ATTR_KEY':{'ger':'Schlssel','eng':'Key','fra':'Clef','esp':'Llave','ita':'Chiave','chi':''},
	   'ATTR_KEYS':{'ger':'Schlssel','eng':'Keys','fra':'Clefs','esp':'Llaves','ita':'Chiavi','chi':''},
	   'ATTR_KEYWORDS':{'ger':'Schlsselwrter','eng':'Keywords','fra':'Mots-cls','esp':'Palabras claves','ita':'Parole chiavi','chi':'ؼ'},
	   'ATTR_LANG':{'ger':'Sprache','eng':'Language','fra':'Langue','esp':'Lengua','ita':'Lingua','chi':''},
	   'ATTR_LANGS':{'ger':'Sprache(n)','eng':'Language(s)','fra':'Langues','esp':'Lenguas','ita':'Lingue','chi':''},
	   'ATTR_LAST_EXECUTED':{'ger':'Zuletzt ausgefhrt','eng':'Last execution'},
	   'ATTR_LAST_MODIFIED':{'ger':'Zuletzt gendert','eng':'Last modification','chi':'ϴ޸ʱ'},
	   'ATTR_LAST_MODIFIER':{'ger':'Gendert von','eng':'Modified by','fra':'Modifi prs','esp':'Modificado cerca','ita':'Modificato vicino','chi':' %s ޸'},
	   'ATTR_LINK_EXTERNAL':{'ger':'Externer Link','eng':'External Link'},
	   'ATTR_LINK_INTERNAL':{'ger':'Interner Link','eng':'Internal Link'},
	   'ATTR_MANDATORY':{'ger':'Pflicht','eng':'Mandatory','fra':'Obligatoire','esp':'Obligatorio','ita':'Obbligatorio','chi':'Ҫ'},
	   'ATTR_META_TYPE':{'ger':'Dokumenttyp','eng':'Document type','chi':'ļ'},
	   'ATTR_METHOD':{'ger':'Methode','eng':'Method'},
	   'ATTR_MIME_TYPE':{'ger':'MIME-Typ','eng':'MIME-Type','chi':'MIME '},
	   'ATTR_MULTILANG':{'ger':'multilingual','eng':'multilingual','chi':''},
	   'ATTR_MULTIPLE':{'ger':'mehrfach','eng':'multiple','fra':'multiple','esp':'mltiple','ita':'multiplo','chi':''},
	   'ATTR_MODIFIED':{'ger':'Gendert','eng':'Modified','fra':'Modifi','esp':'Modificado','ita':'Modificato','chi':'޸'},
	   'ATTR_NAME':{'ger':'Name','eng':'Name','fra':'Nom','esp':'Nombre','ita':'Nome','chi':''},
	   'ATTR_NEXT':{'ger':'Weitere','eng':'Next','chi':'һ'},
	   'ATTR_NODE':{'ger':'Knoten','eng':'Node'},
	   'ATTR_NONE':{'ger':'Kein(e)','eng':'None','fra':'Aucun','esp':'Ninguno','ita':'Nessuno','chi':''},
	   'ATTR_OBJECT':{'ger':'Objekt','eng':'Object','fra':'Objet','esp':'Objeto','chi':''},
	   'ATTR_OBJECTS':{'ger':'Objekte','eng':'Objects','fra':'Objets','esp':'Objetos','chi':''},
	   'ATTR_OF':{'ger':'von','eng':'of','fra':'de','chi':''},
	   'ATTR_OPTION':{'ger':'Option','eng':'Option','fra':'Option','esp':'Opcin','chi':'ѡ'},
	   'ATTR_PARAGRAPH':{'ger':'Absatz','eng':'Paragraph','chi':''},
	   'ATTR_PARENT':{'ger':'Vorgnger','eng':'Parent','chi':''},
	   'ATTR_PASSWORD':{'ger':'Passwort','eng':'Password','fra':'Mot de passe','esp':'Contrasea','chi':''},
	   'ATTR_PATH':{'ger':'Pfad','eng':'Path','fra':'Chemin','esp':'Camino','chi':'·'},
	   'ATTR_PENETRANCE':{'ger':'Penetranz','eng':'Penetrance','chi':'͸'},
	   'ATTR_PREVIOUS':{'ger':'Vorherige', 'eng':'Previous', 'chi':'ǰ' },
	   'ATTR_PRIMARY':{'ger':'Primr', 'eng':'Primary', 'fra':'Primaire', 'esp':'Primario', 'chi':'Ҫ' },
	   'ATTR_PRIMITIVE':{'ger':'Primitiv', 'eng':'Primitive', 'chi':'ԭʼ' },
	   'ATTR_PRINTVERSION':{'ger':'Druckversion', 'eng':'Printversion', 'chi':'ӡ' },
	   'ATTR_PROCESSES':{'ger':'Serverseitige Batch-Prozesse', 'eng':'Server-side batch-processes' },
	   'ATTR_PRODUCTS':{'ger':'Produkt(e)', 'eng':'Product(s)', 'chi':'Ʒ' },
	   'ATTR_PROFILE':{'ger':'Profil', 'eng':'Profile' },
	   'ATTR_PROTOCOL':{'ger':'Protokoll','eng':'Protocol'},
	   'ATTR_PUBLISHER':{'ger':'Verleger', 'eng':'Publisher', 'fra':'diteur', 'esp':'Editor','chi':'' },
	   'ATTR_RECORD':{'ger':'Datensatz','eng':'record','chi':'¼'},
	   'ATTR_RECORDS':{'ger':'Datenstze','eng':'records','chi':'¼'},
	   'ATTR_REFRESH':{'ger':'Aktualisierung','eng':'Refresh','chi':'ˢ'},
	   'ATTR_REPETITIVE':{'ger':'Mehrfach','eng':'Repetitive','chi':'ظ'},
	   'ATTR_REQUIRES':{'ger':'bentigt','eng':'requires','chi':''},
	   'ATTR_RICHEDIT':{'ger':'Richedit','eng':'Richedit','chi':'Ϣı༭'},
	   'ATTR_ROBOTS':{'ger':'Suchmaschinen','eng':'Robots','chi':''},
	   'ATTR_ROLE':{'ger':'Rolle','eng':'Role','fra':'Rle','chi':'ְλ'},
	   'ATTR_ROLES':{'ger':'Rollen','eng':'Roles','fra':'Rles','esp':'Papeles','chi':'ְλ'},
	   'ATTR_ROWS':{'ger':'Zeilen','eng':'Rows','fra':'Ranges','esp':'Filas','ita':'File','chi':''},
	   'ATTR_SEARCHTERM':{'ger':'Suchbegriff','eng':'Search term','chi':''},
	   'ATTR_SELECTED':{'ger':'ausgewhlt','eng':'selected','fra':'choisi','esp':'seleccionado','ita':'selezionato','chi':'ѡ'},
	   'ATTR_SEPARATED':{'ger':'getrennt','eng':'separated','chi':''},
	   'ATTR_SEQUENCE':{'ger':'Sequenz','eng':'Sequence','chi':''},
	   'ATTR_SIZE':{'ger':'Gre','eng':'Size','fra':'Taille','esp':'Tamao','ita':'formato','chi':'С'},
	   'ATTR_SOURCE':{'ger':'Quelle','eng':'Source','fra':'Source','esp':'Fuente','ita':'fonte','chi':'ԭ'},
	   'ATTR_START_DAT':{'ger':'von','eng':'from','fra':'de','esp':'de','ita':'da','chi':''},
	   'ATTR_STATES':{'ger':'Stati','eng':'States'},
	   'ATTR_STATIC':{'ger':'statisch','eng':'static'},
	   'ATTR_STATISTICS':{'ger':'Statistik','eng':'Statistics','fra':'Statistiques','esp':'Estadstica','ita':'Statistiche','chi':'ͳ'},
	   'ATTR_STYLESHEET':{'ger':'Stylesheet','eng':'Stylesheet','chi':'ʽ'},
	   'ATTR_SUCCESSOR':{'ger':'Nachfolger','eng':'Successor'},
	   'ATTR_SUBJECT':{'ger':'Thema','eng':'Subject','chi':''},
	   'ATTR_TABLE':{'ger':'Tabelle','eng':'Table','fra':'Table','esp':'Mesa','ita':'Tabella','chi':''},
	   'ATTR_TAG':{'ger':'Tag','eng':'Tag','chi':'ǩ'},
	   'ATTR_TARGET':{'ger':'Ziel','eng':'Target','fra':'Cible','esp':'Blanco','ita':'Obiettivo','chi':'Ŀ'},
	   'ATTR_TITLE':{'ger':'Titel','eng':'Title','fra':'Titre','esp':'Ttulo','ita':'Titolo','chi':''},
	   'ATTR_TITLEIMAGE':{'ger':'Titelbild','eng':'Titleimage','chi':'ͼƬ'},
	   'ATTR_TITLESHORT':{'ger':'Kurztitel','eng':'Short title','fra':'Titre court','esp':'Ttulo corto','ita':'Titolo abbreviato','chi':'̱'},
	   'ATTR_TEXT':{'ger':'Text','eng':'Text','fra':'Texte','esp':'Texto','ita':'Testo','chi':'ı'},
	   'ATTR_TEXTALIGN':{'ger':'Textausrichtung','eng':'Text alignment','chi':'뷽ʽ'},
	   'ATTR_TRANSITIONS':{'ger':'bergnge','eng':'Transitions'},
	   'ATTR_TYPE':{'ger':'Typ','eng':'Type','fra':'Type','esp':'Tipo','chi':''},
	   'ATTR_TOC':{'ger':'Inhaltsverzeichnis','eng':'Table of contents','chi':'Ŀ¼'},
	   'ATTR_URL':{'ger':'URL','eng':'URL'},
	   'ATTR_USER':{'ger':'Benutzer','eng':'User','fra':'Utilisateur','esp':'Usuario','ita':'Utente','chi':'û'},
	   'ATTR_USERS':{'ger':'Benutzer','eng':'Users','fra':'Utilisateurs','esp':'Usuarios','ita':'Utentes'},
	   'ATTR_VERSION':{'ger':'Version','eng':'Version','chi':'汾'},
	   'ATTR_WIDTH':{'ger':'Breite','eng':'Width','fra':'Largeur','esp':'Anchura','ita':'larghezza','chi':''},
	   'ATTR_WYSIWYG':{'ger':'WYSIWYG','eng':'WYSIWYG'},
	   
	   # options::attr_borderstyle
	   'OPT_AB_SOLID':{'ger':'Komplett','eng':'Solid','fra':'Solide','esp':'Slido','chi':' ʵ'},
	   'OPT_AB_SINGLE':{'ger':'Einzeln','eng':'Single','fra':'Simple','esp':'Solo','chi':''},
	   'OPT_AB_NONE':{'ger':'Kein','eng':'None','fra':'Personne','esp':'Ninguno','chi':''},
	   # options::attr_penetrance
	   'OPT_AP_THIS':{'ger':'dieses Objekt','eng':'this object','chi':'ö'},
	   'OPT_AP_SUB_NAV':{'ger':'alle Rubrik-Seiten der Subhierarchie','eng':'all folder-pages of sub-hierarchy','chi':'βεҳ'},
	   'OPT_AP_SUB_ALL':{'ger':'komplette Subhierarchie','eng':'complete sub-hierarchy','chi':'дβ'},
	   # options::align
	   'OPT_A_LEFT':{'ger':'Linksbndig','eng':'Left','esp':'A la izquierda','ita':'Alla sinistra','chi':''},
	   'OPT_A_RIGHT':{'ger':'Rechtsbndig','eng':'Right','esp':'A la derecha','ita':'Al centro','chi':'Ҷ'},
	   'OPT_A_CENTER':{'ger':'Zentriert','eng':'Center','esp':'Centrar','ita':'Alla destra','chi':''},
	   'OPT_A_TOP':{'ger':'Oben','eng':'Top','chi':'˶'},
	   'OPT_A_MIDDLE':{'ger':'Mitte','eng':'Middle','chi':'в'},
	   'OPT_A_BOTTOM':{'ger':'Unten','eng':'Bottom','chi':'׶˶'},
	   # options::format
	   'OPT_F_HEADLINE1':{'ger':'berschrift 1','eng':'Headline 1','fra':'Titre 1','esp':'Titular 1','chi':'1'},
	   'OPT_F_HEADLINE2':{'ger':'berschrift 2','eng':'Headline 2','fra':'Titre 2','esp':'Titular 2','chi':'2'},
	   'OPT_F_HEADLINE3':{'ger':'berschrift 3','eng':'Headline 3','fra':'Titre 3','esp':'Titular 3','chi':'3'},
	   'OPT_F_HEADLINE4':{'ger':'berschrift 4','eng':'Headline 4','fra':'Titre 4','esp':'Titular 4','chi':'4'},
	   'OPT_F_HEADLINE5':{'ger':'berschrift 5','eng':'Headline 5','fra':'Titre 5','esp':'Titular 5','chi':'5'},
	   'OPT_F_HEADLINE6':{'ger':'berschrift 6','eng':'Headline 6','fra':'Titre 6','esp':'Titular 6','chi':'6'},
	   'OPT_F_BODY':{'ger':'Bodytext','eng':'Body','chi':''},
	   'OPT_F_ORDEREDLIST':{'ger':'Nummerierung','eng':'Numbered List','chi':''},
	   'OPT_F_UNORDEREDLIST':{'ger':'Aufzhlung','eng':'Bulleted List','chi':'Ŀ'},
	   'OPT_F_INDENTEDBLOCK':{'ger':'Einzug (z.B. Zitate)','eng':'Indented block (e.g. quotations)','chi':'磺ģ'},
	   'OPT_F_EMPHASIS':{'ger':'Merksatz','eng':'Emphasis','chi':'ǿ'},
	   'OPT_F_CAPTION':{'ger':'Beschriftung','eng':'Caption','chi':''},
	   'OPT_F_PLAINHTML':{'ger':'HTML','eng':'HTML'},
	   # options::style
	   'OPT_S_BOLD':{'ger':'Fett','eng':'Bold','esp':'Negrita','ita':'Grassetto','chi':''},
	   'OPT_S_ITALIC':{'ger':'Kursiv','eng':'Italic','esp':'Cursiva','ita':'Corsivo','chi':'б'},
	   'OPT_S_UNDERLINE':{'ger':'Unterstrichen','eng':'Underline','esp':'Subrayar','ita':'Sottolineatto','chi':'»'},
	   'OPT_S_SUP':{'ger':'Hochgestellt','eng':'Superscript','chi':'ϱ'},
	   'OPT_S_SUB':{'ger':'Tiefgestellt','eng':'Subscript','chi':'±'},
	   'OPT_S_CODE':{'ger':'Code','eng':'Code','chi':''},
	   'OPT_S_INSCHAR':{'ger':'Symbol','eng':'Special Character','chi':'ַ'},
	   'OPT_S_HORIZRULE':{'ger':'Waagerechte Linie','eng':'Horizontal Rule','chi':'ˮƽ'},
	   'OPT_S_ANCHOR':{'ger':'Hyperlink','eng':'Hyperlink','fra':'Hyperlink','esp':'Hiperlink','ita':'Hyperlink','chi':''},
	   # options: type
	   'OPT_AT_RECURSIVE':{'ger':'Ziel rekursiv einbetten','eng':'embed recursively'},
	   'OPT_AT_EMBED':{'ger':'Ziel einbetten','eng':'embed target','chi':'ǶĿ'},
	   'OPT_AT_REPLACE':{'ger':'im gleichen Fenster ffnen','eng':'follow in same window','chi':'ڸôд'},
	   'OPT_AT_NEW':{'ger':'in neuem Fenster ffnen','eng':'open in new window','chi':'´д'},
	   # options::sitemap_layout
	   'SITEMAPLAYOUT0':{'ger':'Explorer-Style','eng':'Explorer-Style','fra':'Explorer-Style','esp':'Explorer-Style','ita':'Explorer-Style','chi':'Explorer ʽ'},
	   'SITEMAPLAYOUT1':{'ger':'Horizontal','eng':'Horizontal','chi':''},
	   'SITEMAPLAYOUT2':{'ger':'Vertikal','eng':'Vertical','chi':''},
	   # options: number type
	   'OPT_L_0':{'ger':'Arabisch (1, 2, 3)','eng':'Arabic (1, 2, 3)','chi':'֣1, 2, 3'},
	   'OPT_L_1':{'ger':'Grobuchstaben (A, B, C)','eng':'Uppercase letter (A, B, C)','chi':'дĸA, B, C'},
	   'OPT_L_2':{'ger':'Kleinbuchstaben (a, b, c)','eng':'Lowercase letter (a, b, c)','chi':'Сдĸa, b, c'},
	   # options: tasks
	   'TASK_ZMSNOTE':{'ger':'Notiz-Objekte','eng':'note-objects','chi':'߼'},
	   'TASK_UNTRANSLATED':{'ger':'zu bersetzende Objekte','eng':'objects to be translated','chi':'뷭Ķ'},
	   'TASK_CHANGED_BY_DATE':{'ger':'Zuletzt genderte Objekte','eng':'latest-modified objects'},
	   # types: standard
	   'TYPE_ZMSOBJECT':{'ger':'Objekt','eng':'Object','fra':'Objet','chi':''},
	   'TYPE_ZMS':{'ger':'WWW-Site','eng':'WWW-site','fra':'WWW-Site','esp':'WWW-Site','chi':'վ'},
	   'TYPE_ZMSSYSFOLDER':{'ger':'Systemordner','eng':'Systemfolder','chi':'ϵͳļ'},
	   'TYPE_ZMSRUBRIK':{'ger':'Rubrik','eng':'Folder','fra':'Dossier','esp':'Carpeta','chi':'ļ'},
	   'TYPE_ZMSDOCUMENT':{'ger':'Dokument','eng':'Document','fra':'Document','esp':'Documento','chi':'ļ'},
	   'TYPE_ZMSTEXTAREA':{'ger':'Textabschnitt','eng':'Text','fra':'Texte','esp':'Texto','chi':'ļ'},
	   'TYPE_ZMSTEASERCONTAINER':{'ger':'Teaser','eng':'Teaser','fra':'Teaser','esp':'Teaser','chi':'Ŀ'},
	   'TYPE_ZMSTEASERELEMENT':{'ger':'Teaser-Element','eng':'Teaserelement','fra':'Teaserelment','esp':'Teaserelemento','chi':'ĿԪ'},
	   'TYPE_ZMSSQLDB':{'ger':'SQL-Datenquelle','eng':'SQL-Datasource','chi':'SQL Դ'},
	   'TYPE_ZMSGRAPHIC':{'ger':'Abbildung','eng':'Image','fra':'Image','esp':'Imagen','chi':'ͼ'},
	   'TYPE_ZMSTABLE':{'ger':'Tabelle','eng':'Table','fra':'Table','esp':'Mesa','ita':'Tabella','chi':''},
	   'TYPE_ZMSFILE':{'ger':'Datei','eng':'File','fra':'Fichier','esp':'Archivo','ita':'Lima','chi':'ļ'},
	   'TYPE_ZMSNOTE':{'ger':'Notiz','eng':'Note','fra':'Note','esp':'Nota','ita':'Nota','chi':''},
	   'TYPE_ZMSCUSTOM':{'ger':'Metaobjekt','eng':'Metaobject','chi':'Ԫ'},
	   'TYPE_ZMSLINKCONTAINER':{'ger':'Linksammlung','eng':'Linkcollection','chi':'ղ'},
	   'TYPE_ZMSLINKELEMENT':{'ger':'Link','eng':'Link','chi':''},
	   'TYPE_ZMSTRASHCAN':{'ger':'Papierkorb','eng':'Trashcan','chi':'վ'},
	   'TYPE_METAPATTERN':{'ger':'Modul','eng':'Module','chi':'Ī'},
	   # types: special object
	   'SOTYPE_ZMSOBJECT':{'ger':'Seiten-Element','eng':'Page-Element','chi':'ҳ'},
	   'SOTYPE_ZMSDOCUMENT':{'ger':'Seite','eng':'Page','chi':'ҳ'},
	   'SOTYPE_ZMSTEASERELEMENT':{'ger':'Teaser-Element','eng':'Teaser-Element','chi':'ĿԪ'},
	   'SOTYPE_ZMSRECORDSET':{'ger':'Datentabelle','eng':'Datatable','chi':'ݿ'},
	   'SOTYPE_ZMSRESOURCE':{'ger':'Meta-Objekt','eng':'Meta-Object','chi':'Դ'},
	   # Buttons
	   'BTN_ACQUIRE':{'ger':'Akquirieren','eng':'Acquire','fra':'Acqurir','esp':'Adquirir','chi':'ȡ'},
	   'BTN_ADD':{'ger':'Hinzufgen','eng':'Add','chi':''},
	   'BTN_AQTOP':{'ger':'von oben','eng':'from top','chi':'Զ '},
	   'BTN_AQBOTTOM':{'ger':'nach unten','eng':'to bottom','chi':''},
	   'BTN_BACK':{'ger':'Zurck','eng':'Back','fra':'En arrire','esp':'Atrs','chi':'һ'}, # NEW!
	   'BTN_CANCEL':{'ger':'Abbrechen','eng':'Cancel','fra':'Annuler','esp':'Cancelar','ita':'Annullare','chi':'ȡ'},
	   'BTN_CHANGE':{'ger':'ndern','eng':'Change','esp':'Cambiar','ita':'Cambiare','chi':''},
	   'BTN_CLEAR':{'ger':'Leeren','eng':'Clear','fra':'Libre','esp':'Claro','ita':'Radura','chi':''},
	   'BTN_CLOSE':{'ger':'Schliessen','eng':'Close','fra':'Fin','esp':'Cierre','ita':'Fine','chi':'ر '},
	   'BTN_COMMIT':{'ger':'Freigeben','eng':'Commit','fra':'Commettez','esp':'Confe','ita':'Commetta','chi':'ύ'},
	   'BTN_COMPARE':{'ger':'Vergleichen','eng':'Compare'},
	   'BTN_COLLAPSE':{'ger':'Zuklappen','eng':'Collapse'},
	   'BTN_DELETE':{'ger':'Lschen','eng':'Delete','fra':'Supprimer','esp':'Borrar','ita':'Cancellare','chi':'ɾ'},
	   'BTN_DISPLAY':{'ger':'Anzeigen','eng':'Display'},
	   'BTN_DOWNLOAD':{'ger':'Download','eng':'Download','chi':''},
	   'BTN_EDIT':{'ger':'Bearbeiten','eng':'Edit','fra':'Travailler','esp':'Editar','ita':'Stampare','chi':'༭'},
	   'BTN_EXPAND':{'ger':'Aufklappen','eng':'Expand'},
	   'BTN_EXPORT':{'ger':'Exportieren','eng':'Export','fra':'Exporter','chi':''},
	   'BTN_IMPORT':{'ger':'Importieren','eng':'Import','fra':'Importer','chi':''},
	   'BTN_INIT':{'ger':'Initialisieren','eng':'Init','fra':'Initialiser','chi':'ʼ'},
	   'BTN_INSERT':{'ger':'Einfgen','eng':'Insert','fra':'Insrer','esp':'Relleno','ita':'Inserto','chi':''},
	   'BTN_INVITE':{'ger':'Einladen','eng':'Invite'},
	   'BTN_LOGOUT':{'ger':'Logout','eng':'Logout','fra':'Sortie du systme','esp':'Trmino de sesin','ita':'Termine attivit','chi':'ע'},
	   'BTN_NEXT':{'ger':'Weiter','eng':'Next'}, # NEW!
	   'BTN_OPEN':{'ger':'ffnen','eng':'Open','fra':'Ouvrir','esp':'Abierto','chi':''},
	   'BTN_OVERTAKE':{'ger':'bernehmen','eng':'Overtake','chi':'Ӧ'},
	   'BTN_OVERWRITE':{'ger':'berschreiben','eng':'Overwrite','chi':'д'},
	   'BTN_PING':{'ger':'Ping','eng':'Ping','fra':'Ping','esp':'Ping','chi':'PING'},
	   'BTN_REDO':{'ger':'Wiederherstellen','eng':'Redo','chi':'ָ'},
	   'BTN_REFRESH':{'ger':'Aktualisieren','eng':'Refresh','fra':'Rafrachir','esp':'Refrescar','chi':'ˢ'},
	   'BTN_REJECT':{'ger':'Ablehnen','eng':'Reject','chi':'ܾ'},
	   'BTN_RENAME':{'ger':'Umbenennen','eng':'Rename','chi':''},
	   'BTN_REQUESTCOMMIT':{'ger':'Freigabe beantragen','eng':'Request commit','chi':'ύ'},
	   'BTN_RESET':{'ger':'Zurcksetzen','eng':'Reset','fra':'Remettre','esp':'Recomponer','chi':''},
	   'BTN_ROLLBACK':{'ger':'Zurcknehmen','eng':'Rollback','chi':'ת'},
	   'BTN_SEARCH':{'ger':'Suche','eng':'Find','fra':'Recherche','esp':'Bsqueda','ita':'Ricerca','chi':''},
	   'BTN_SEND':{'ger':'Abschicken','eng':'Send'},
	   'BTN_SLCTALL':{'ger':'Alle auswhlen','eng':'Select all','fra':'Choisissez tous','esp':'Seleccione todos','ita':'Selezioni tutti','chi':'ȫѡ'},
	   'BTN_SLCTNONE':{'ger':'Nichts auswhlen','eng':'Select none','fra':'N\'en choisissez aucun','esp':'No seleccione ninguno','ita':'Non ne selezioni','chi':'ȫѡ'},
	   'BTN_SYNCHRONIZE':{'ger':'Synchronisieren','eng':'Synchronize','chi':'ͬ'},
	   'BTN_UNDO':{'ger':'Rckgngig','eng':'Undo','fra':'Dfaire','esp':'Deshacer','chi':''},
	   'BTN_UPLOAD':{'ger':'Hochladen','eng':'Upload','fra':'Tlcharger','chi':''},
	   'BTN_ZOOM':{'ger':'Zoom','eng':'Zoom','fra':'Bourdonnement','esp':'Zumbido','chi':'ʾ'},

	   'SEARCH_HEADER':{'ger':'Suche','eng':'Search','fra':'Recherche','esp':'Bsqueda','ita':'Ricerca','chi':''},
	   'SEARCH_HEADERAGAIN':{'ger':'Erneute Suche','eng':'Search again','chi':'һ'},
	   'SEARCH_HINT':{'ger':'Bitte tragen Sie einen<br />Begriff ein und klicken<br />Sie auf &quot;Suchen&quot;. Die<br />Optionen knnen<br />normalerweise<br />unverndert bleiben.<br />','eng':'Please enter a String<br />and click &quot;search&quot;.<br />In most cases the Options<br />can remain unchanged.<br />','chi':'֣Ȼ󵥻"" ڶѡøġ'},
	   'SEARCH_HEADERRESULT':{'ger':'Suchresultat','eng':'Results','chi':''},
	   'SEARCH_YOURQUERY':{'ger':"Ihre Suche nach dem Begriff: '%s'",'eng':"Your search for: '%s'",'chi':'%s '},
	   'SEARCH_NORESULTS':{'ger':'erzielte keinen Treffer, bitte versuchen Sie es erneut. berprfen Sie die Schreibweise Ihres Suchbegriffs.','eng':'returned no results. Please revise your search.','chi':'ҲĿִ޴'},
	   'SEARCH_RETURNEDRESULTS':{'ger':'erzielte folgende Ergebnisse','eng':'returned the following results','chi':'ҵеĽ'},
	   'SEARCH_RETURNEDSTATS':{'ger':'Dokument %i - %i von %i Treffern','eng':'Documents %i - %i of %i matches','chi':'г %i  %i  %i '},
	   'ATTR_ORDERBY':{'ger':'Sortierung nach','eng':'Order by','fra':'Ordre par','esp':'Orden por','ita':'Ordine vicino','chi':'ʽ'},
	   'SEARCH_ORDERBY1':{'ger':'Treffer','eng':'Score','fra':'Score','esp':'Cuenta','ita':'Segno','chi':'÷ '},
	   'SEARCH_ORDERBY2':{'ger':'Datum','eng':'Date','fra':'Date','esp':'Fecha','ita':'Data','chi':''},
	   'PAGETOP':{'ger':'Seitenanfang','eng':'Top','fra':'Dessus','esp':'Tapa','ita':'Parte superiore','chi':'ҳ '},
	   'RECOMMEND_THIS_PAGE':{'ger':'Diese Seite empfehlen','eng':'Recommend this page'},
	   'AND':{'ger':'Und','eng':'And','fra':'Et','esp':'y','chi':''},
	   'OF':{'ger':'von','eng':'of','fra':'de','chi':''},
	   'OR':{'ger':'Oder','eng':'Or','fra':'Ou','esp':'o','chi':''},
	   'ABOUT':{'ger':'Impressum','eng':'About','chi':'','fas':''},
	   'BACK':{'ger':'Zurck','eng':'Back','fra':'En arrire','esp':'Atrs','chi':'һ'},
	   'BY':{'ger':'von','eng':'by','fra':'par','chi':''},
	   'ON':{'ger':'am','eng':'on','fra':'','esp':'en','chi':''},
	   'AT':{'ger':'um','eng':'at','chi':'ʱ'},
	   'HREF_MORE':{'ger':'[<a%s>Mehr</a>]','eng':'[<a%s>More</a>]','fra':'[<a%s>Plus','esp':'[<a%s>Ms</a>]','chi':'[<a%s></a>]'},
	   'MORE':{'ger':'Mehr','eng':'More','fra':'Plus','esp':'Ms','chi':''},
	   'YOU_ARE':{'ger':'Sie sind','eng':'You are','fra':'Vous tes','esp':'Ud es','ita':'Siete','chi':''},
	   'WITH_BEST_REGARDS':{'ger':'Mit freundlichen Gren,','eng':'With best regards,','chi':'ĵʺ'},
	   'IP_OR_DOMAIN':{'ger':'IP-Adresse / Domne','eng':'IP / Domain','chi':'IPַ'},
	   'OBJECTS_OLDER_THAN':{'ger':'fr Objekte lter als','eng':'for objects older than'},

	   'ROLE_ZMSADMINISTRATOR':{'ger':'Administrator','eng':'Administrator','fra':'Administrateur','esp':'Administrador','chi':'Ա'},
	   'ROLE_ZMSEDITOR':{'ger':'Redakteur','eng':'Editor','fra':'Rdacteur','esp':'Redactor','chi':'༭'},
	   'ROLE_ZMSAUTHOR':{'ger':'Autor','eng':'Author','fra':'Auteur','esp':'Autor','chi':''},
	   'ROLE_ZMSSUBSCRIBER':{'ger':'Abonnent','eng':'Subscriber','chi':'û'},
	   'ROLE_ZMSUSERADMINISTRATOR':{'ger':'Benutzerverwaltung','eng':'User-Administration'},  # NEW!
	   
	   'STATE_NEW':{'ger':'Neu','eng':'New','fra':'Nouveau','esp':'Nuevo','ita':'Nuovo','chi':''},
	   'STATE_MODIFIED':{'ger':'Gendert','eng':'Modified','fra':'Modifi','esp':'Modificado','chi':'Ѹ'},
	   'STATE_DELETED':{'ger':'Gelscht','eng':'Deleted','fra':'Supprim','esp':'Suprimido','chi':'ɾ'},
	   'STATE_LOCKED':{'ger':'Gesperrt','eng':'Locked','chi':''},
	   'STATE_TRANSLATE':{'ger':'Zu bersetzen!','eng':'To be translated!','chi':'뷭'},
	   
	   'CAPTION_CHOOSEOBJ':{'ger':'Whlen Sie ein Objekt aus','eng':'Please choose an object','chi':'ѡȡ'},
	   'CAPTION_DELETE':{'ger':'%s lschen','eng':'Delete %s'},
	   'CAPTION_EDIT':{'ger':'%s bearbeiten','eng':'Edit %s','fra':'Travailler %s','esp':'Editar %s','ita':'Stampare %s','chi':'༭ %s'},
	   'CAPTION_EXPORT':{'ger':'%s exportieren','eng':'Export %s','chi':' %s','chi':' /  %s'},
	   'CAPTION_IMPORTEXPORT':{'ger':'Import/Export %s','eng':'Import/Export %s'},
	   'CAPTION_IMPORT':{'ger':'%s importieren','eng':'Import %s','chi':' %s'},
	   'CAPTION_INSERT':{'ger':'%s einfgen','eng':'Insert %s','fra':'Insrer %s','esp':'Insertar %s','ita':'Inserire %s','chi':' %s'},
	   'CAPTION_LOCKED':{'ger':'%s gesperrt','eng':'%s locked','chi':' %s '},
	   'CAPTION_UPLOAD':{'ger':'%s hochladen','eng':'Upload %s','chi':' %s'},
	   'CAPTION_LOGO':{'ger':'Logo (Management-Interface)','eng':'Logo (Management-Interface)','chi':'̱꣨棩'},
	   'CAPTION_SKIN':{'ger':'Skin (Management-Interface)','eng':'Skin (Management-Interface)'},
	   'CAPTION_ADDUSER':{'ger':'Neuen Benutzer zu %s hinzufgen','eng':'Create new user for %s','chi':'û %s'},
	   'CAPTION_ADDROLE':{'ger':'Neue Rolle zu %s hinzufgen','eng':'Create new role for %s','chi':' %s ְλ'},
	   'CAPTION_METADATA':{'ger':'%s Metadaten','eng':'Metadata %s','chi':'%s Ԫ'},
	   'CAPTION_METAOBJ':{'ger':'Spezielle Dokumente','eng':'Special Documents','chi':'ĵ'},
	   'CAPTION_PROPERTIES':{'ger':'%s-Eigenschaften','eng':'Properties %s','fra':'Proprits %s','esp':'Propiedades %s','ita':'Propriet %s','chi':'%s '},
	   
	   'ACTION_SELECT':{'ger':'%s auswhlen','eng':'Select %s','fra':'Choisissez %s','esp':'Seleccione el  %s','ita':'Selezioni il %s','chi':'ѡȡ %s'},
	   'ACTION_INSERT':{'ger':'Neu zu %s','eng':'Add to %s','fra':'Ajoutez au %s','esp':'Agregue al %s','ita':'Aggiunga al %s','chi':'༭ %s'},
	   'ACTION_DELETE':{'ger':'Lschen','eng':'Delete','fra':'Supprimer','esp':'Borrar','ita':'Cancellare','chi':'ɾ'},
	   'ACTION_FADE':{'ger':'einblenden/ausblenden','eng':'fade in/out','chi':' / '},
	   'ACTION_GENERATE_PREVIEW':{'ger':'Vorschau generieren','eng':'generate preview','chi':'Ԥ'},
	   'ACTION_EDIT_CELL':{'ger':'Zelle bearbeiten','eng':'Edit cell','chi':'༭Ԫ'},
	   'ACTION_MERGE_CELLS':{'ger':'Zellen verbinden','eng':'Merge cells','chi':'ϲԪ'},
	   'ACTION_SPLIT_CELLS':{'ger':'Zelle teilen','eng':'Split cells','chi':'۷ֵԪ'},
	   'ACTION_DELETE_CELL':{'ger':'Zelle lschen','eng':'Delete cell','chi':'ɾԪ'},
	   'ACTION_DELETE_CELLS':{'ger':'Zellen lschen','eng':'Delete cells','chi':'ɾԪ'},
	   'ACTION_INSERT_CELL':{'ger':'Zelle einfgen','eng':'Insert cell','chi':'뵥Ԫ'},
	   'ACTION_DELETE_ROW':{'ger':'Zeile lschen','eng':'Delete row','esp':'Borrar fila','ita':'Cancellare fila','chi':'ɾ'},
	   'ACTION_DELETE_ROWS':{'ger':'Zeilen lschen','eng':'Delete rows','esp':'Borrar fila','ita':'Cancellare fila','chi':'ɾ'},
	   'ACTION_INSERT_ROW':{'ger':'Zeile einfgen','eng':'Insert row','chi':''},
	   'ACTION_DELETE_COL':{'ger':'Spalte lschen','eng':'Delete column','esp':'Borrar columna','ita':'Cancellare colonna','chi':'ɾ'},
	   'ACTION_DELETE_COLS':{'ger':'Spalten lschen','eng':'Delete columns','esp':'Borrar columna','ita':'Cancellare colonna','chi':'ɾ'},
	   'ACTION_INSERT_COL':{'ger':'Spalte einfgen','eng':'Insert column','chi':''},
	   'ACTION_OUTDENT':{'ger':'Einzug verkleinern','eng':'Decrease indent','chi':''},
	   'ACTION_INDENT':{'ger':'Einzug vergrssern','eng':'Increase indent','chi':''},
	   'ACTION_MOVEUP':{'ger':'Nach oben verschieben','eng':'Move up','chi':''},
	   'ACTION_MOVEDOWN':{'ger':'Nach unten verschieben','eng':'Move down','chi':''},
	   'ACTION_MOVELEFT':{'ger':'Nach links verschieben','eng':'Move left','chi':''},
	   'ACTION_MOVERIGHT':{'ger':'Nach rechts verschieben','eng':'Move right','chi':''},

	   'BTN_CUT':{'ger':'Ausschneiden','eng':'Cut','fra':'Dcouper','esp':'Cortar','ita':'Tagliare','chi':''},
	   'BTN_COPY':{'ger':'Kopieren','eng':'Copy','fra':'Copier','esp':'Copiar','ita':'Copiare','chi':''},
	   'BTN_PASTE':{'ger':'Einfgen','eng':'Paste','fra':'Insrer','esp':'Pegar','ita':'Incollare','chi':'ճ'},
	   
	   'LANG':{'ger':'Deutsch','eng':'English','fra':'Francais','esp':'Espanol','ita':'Italiano','chi':'Chinese','fas':'Farsi'},
	   
	   'ALIGN':{'ger':'Ausrichtung','eng':'alignment','chi':'뷽ʽ'},
	   'ALIGN1':{'ger':'Linksbndig','eng':'Left','esp':'A la izquierda','ita':'Alla sinistra','chi':''},
	   'ALIGN2':{'ger':'Rechtsbndig','eng':'Right','esp':'A la derecha','ita':'Al centro','chi':'Ҷ'},
	   'ALIGN3':{'ger':'Zentriert','eng':'Center','esp':'Centrar','ita':'Alla destra','chi':''},
	   
	   'MONTH1':{'ger':'Januar','eng':'January','chi':'һ'},
	   'MONTH2':{'ger':'Februar','eng':'February','chi':''},
	   'MONTH3':{'ger':'Mrz','eng':'March','chi':''},
	   'MONTH4':{'ger':'April','eng':'April','chi':''},
	   'MONTH5':{'ger':'Mai','eng':'May','chi':''},
	   'MONTH6':{'ger':'Juni','eng':'June','chi':''},
	   'MONTH7':{'ger':'Juli','eng':'July','chi':''},
	   'MONTH8':{'ger':'August','eng':'August','chi':''},
	   'MONTH9':{'ger':'September','eng':'September','chi':''},
	   'MONTH10':{'ger':'Oktober','eng':'October','chi':'ʮ'},
	   'MONTH11':{'ger':'November','eng':'November','chi':'ʮһ'},
	   'MONTH12':{'ger':'Dezember','eng':'December','chi':'ʮ'},

	   'WEEKDAY0':{'ger':'Montag','eng':'Monday','fra':'Lundi','esp':'Lunes','chi':'һ'},
	   'WEEKDAY1':{'ger':'Dienstag','eng':'Tuesday','fra':'Mardi','esp':'Martes','chi':'ڶ'},
	   'WEEKDAY2':{'ger':'Mittwoch','eng':'Wednesday','fra':'Mercredi','esp':'Mircoles','chi':''},
	   'WEEKDAY3':{'ger':'Donnerstag','eng':'Thursday','fra':'Jeudi','esp':'Jueves','chi':''},
	   'WEEKDAY4':{'ger':'Freitag','eng':'Friday','fra':'Vendredi','esp':'Viernes','chi':''},
	   'WEEKDAY5':{'ger':'Samstag','eng':'Saturday','fra':'Samedi','esp':'Sbado','chi':''},
	   'WEEKDAY6':{'ger':'Sonntag','eng':'Sunday','fra':'Dimanche','esp':'Domingo','chi':''},
	   
	   'ACTION_OVERWRITE_METAPATTERN':{'ger':'Existierendes Modul berschreiben...','eng':'Overwrite existing module...','chi':'еģ鸲'},
	   'ACTION_INSERT_METAPATTERN':{'ger':'Zu Modulen hinzufgen...','eng':'Add to modules...','chi':'ӵģ'},

           'ACTION_MANAGE_UNDOVERSION':{'ger':'Auf frhere Version zurckgesetzt.','eng':'Applied earlier version.','chi':'ָڰ汾'},
           'ACTION_MANAGE_CHANGEPROPERTIES':{'ger':'Objekt gendert.','eng':'Object modified.','chi':'Ѹ'},
           'ACTION_MANAGE_MOVEOBJUP':{'ger':'Nach oben verschoben.','eng':'Moved up.','chi':''},
           'ACTION_MANAGE_MOVEOBJDOWN':{'ger':'Nach unten verschoben.','eng':'Moved down.','chi':''},
           
	   'TIME_FMT':{'ger':'%H:%M:%S','eng':'%H:%M:%S','fra':'%H:%M:%S','esp':'%H:%M:%S','chi':'%H:%M:%S'},
	   'DATE_FMT':{'ger':'%d.%m.%Y','eng':'%Y/%m/%d','fra':'%d.%m.%Y','esp':'%d.%m.%Y','chi':'%Y %m %d'},
	   'DATETIME_FMT':{'ger':'%d.%m.%Y %H:%M:%S','eng':'%Y/%m/%d %H:%M:%S','fra':'%d.%m.%Y %H:%M:%S','esp':'%d.%m.%Y %H:%M:%S','chi':'%Y %m %d %H:%M:%S'},
	   'SHORTDATE_FMT':{'ger':'%d.%m.%y','eng':'%y/%m/%d','fra':'%d.%m.%y','esp':'%d.%m.%y','chi':'%y %m %d'},
	   'SHORTDATETIME_FMT':{'ger':'%d.%m.%y %H:%M:%S','eng':'%y/%m/%d %H:%M:%S','fra':'%d.%m.%y %H:%M:%S','esp':'%d.%m.%y %H:%M:%S','chi':'%y %m %d %H:%M:%S'},
	  }


    # -------------------------------------------------------------------------------------------------
    #	Language.getManageLanguages:
    # -------------------------------------------------------------------------------------------------
    def getManageLanguages(self):
      return ['ger','eng','fra','esp','ita','chi','fas']


    # -------------------------------------------------------------------------------------------------
    #	Language.getLangStr:
    # -------------------------------------------------------------------------------------------------
    def getLangStr(self, key, lang=None):
      # language
      if lang == None:
        try:
          lang = self.getPrimaryLanguage()
        except:
          lang = 'eng'
      
      # Return custom value.
      try:
        dict = self.get_lang_dict()
        if dict.has_key(key):
          if dict[key].has_key(lang):
            return dict[key][lang]
      except:
        pass
      
      # Return system value.
      if self.dctLangStr.has_key(key):
        if not self.dctLangStr[key].has_key(lang):
          lang = 'eng'
        return self.dctLangStr[key][lang]
      
      return key

###################################################################################################
