%define name zh-sgmltools
%define sourceurl ftp://ftp.linux.org.tw/pub/CLDP/src/
%define srcsuffix .tar.gz
%define prefix /usr

#
# You need sgml-tools to build this package
#

Summary: A wrapper for SGMLtools to process Chinese
Summary(zh_TW.Big5): SGMLtools Bz~]{
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Publishing
Source: %{sourceurl}%{name}-%{version}-%{release}%{srcsuffix}
URL: http://www.linux.org.tw/CLDP/zh-sgmltools.html
Buildroot: /var/tmp/%{name}-root
Requires: sgml-tools
Packager: %{packager}
Distribution: %{distribution}
Prefix: %{prefix}
Obsoletes: bg5sgmltools

%description
This is a wrapper for SGMLtools, let you convert Chinese SGML file to HTML,
plain text, LaTeX, and so on. The package is used to process CLDP documents.

%description -l zh_TW.Big5
@ SGMLtools ~]{AΥHBz媺 SGML ɮסAഫ HTML, ¤rA
LaTeX 榡C{ΨӳBz CLDP ĶC


%prep
rm -rf $RPM_BUILD_ROOT
%setup -n %{name}-%{version}-%{release}

%build
make CFLAGS="$RPM_OPT_FLAGS" mb2a script readme.txt

%install
BIN=$RPM_BUILD_ROOT%{prefix}/bin
mkdir -p $BIN
make install BIN=$BIN

# build file list
cd $RPM_BUILD_ROOT
find . -type f | sed -e 's|^\.|\%attr(-,root,root) |' \
                -e '/\/config\//s|^|%config|' \
                -e '/\/applnk\//s|^|%config|' > \
                $RPM_BUILD_DIR/file.list.%{name}

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}
%doc COPYING TODO CREDITS ChangeLog readme.sgml readme.txt

%changelog

* Mon Jan 03 2000 Chih-Wei Huang <cwhuang@linux.org.tw>
- Add CJK patch

* Sat Aug 21 1999 Chih-Wei Huang <cwhuang@linux.org.tw>
- Support external entities (thanks to woju)
- Update version 1.0

* Thu Aug 19 1999 Chih-Wei Huang <cwhuang@linux.org.tw>
- Rename to zh-sgmltools, add GB support
- Update version 0.9

* Fri Feb 19 1999 Chih-Wei Huang <cwhuang@linux.org.tw>
- Spec file update
- Make the package to be relocatable

* Thu Dec 31 1998 Chih-Wei Huang <cwhuang@cle.linux.org.tw>
- Documents update

* Mon Nov 7 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Modify bg5sgml2txt to cooperate with lynx 2.8.1

* Thu Aug 20 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Change build & install step to use Makefile

* Tue Aug 18 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Update version 0.8
- Only make b2a and plain text document

* Wed Aug 12 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Change binaries install path to /usr/bin
- Install files to Buildroot while making package
- Add sgml-tool to required dependence 

* Sat Aug 8 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Remove \protect macro added to tex sources
- Unset LANG, LC_CTYPE, LC_ALL
- Remark <nidx> </nidx> before parsing SGML file

* Mon Aug 06 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Update version 0.7
- Add bg5sgml2txt

* Mon Aug 03 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Update version 0.6

* Sat Aug 01 1998 Chih-Wei Huang <cwhuang@phys.ntu.edu.tw>
- Update version 0.5

