#if !defined(__INC_TREE_H)
#define __INC_TREE_H

#include "config.h"

#include <glib.h>

#if (__GNUC__ >= 2)

#define TREE_CHECK(t, code) __extension__                               \
({  const Tree __t = t;                                                 \
    if (TREE_CODE(__t) != (code))                                       \
      tree_check_failed(__t, code, __FILE__, __LINE__, __FUNCTION__);  \
    __t; })
#else

#define TREE_CHECK(t, code) (t)

#endif

#include "tree-check.h"

#define DEFTREECODE(SYM, STRING) SYM, 

typedef enum
{
#include "tree.def"
  LAST_AND_UNUSED_TREE_CODE
} TreeCode;

#undef DEFTREECODE

#define NUM_TREE_CODES ((int)LAST_AND_UNUSED_TREE_CODE)

union TreeNode;

#define NULL_TREE ((Tree)NULL)

#define TREE_CODE(node) ((node)->common.code)
#define TREE_SET_CODE(node, newcode) ((node)->common.code = newcode)

#define TREE_CHAIN(node) ((node)->common.chain)

#define TREE_LINENO(node) ((node)->common.lineno)
#define TREE_FILENAME(node) ((node)->common.filename)

#define TREE_UNSIGNED(node) ((node)->common.unsigned_flag)
#define TREE_CONST(node) ((node)->common.const_flag)

#define TREE_CLASS_WRAPPED(node) TREE_UNSIGNED(node)
#define TREE_TYPEDESCR_CONST(node) TREE_CONST(node)
#define TREE_ATTR_PURE(node) ((node)->common.unsigned_flag)

#define TREE_CLASS_VIRTUAL(node) ((node)->common.virtual_flag)
#define TREE_ATTR_VIRTUAL(node) TREE_CLASS_VIRTUAL(node)
#define TREE_ATTR_CONST(node) TREE_CONST(node)

typedef union TreeNode TreeNode;

typedef struct
{
    TreeNode *chain;
    TreeCode code;
    int lineno;
    const char *filename;
    unsigned unsigned_flag : 1;
    unsigned virtual_flag : 1;
    unsigned const_flag : 1;
} TreeCommon;


#define TREE_STRING_CST_PTR(node) (STRING_CST_CHECK(node)->string_cst.ptr)
#define TREE_STRING_CST_LEN(node) (STRING_CST_CHECK(node)->string_cst.len)

typedef struct
{
    TreeCommon common;
    int len;
    char *ptr;
} TreeStringCst;

#define TREE_INT_CST(node) (INTEGER_CST_CHECK(node)->int_cst.int_cst)

typedef struct
{
    TreeCommon common;
    unsigned long int_cst;
} TreeIntCst;

#define TREE_IDENTIFIER_LEN(node) (IDENTIFIER_NODE_CHECK(node)->identifier.length)
#define TREE_IDENTIFIER_STR(node) (IDENTIFIER_NODE_CHECK(node)->identifier.str)

typedef struct
{
    TreeCommon common;
    int length;
    const char *str;
} TreeIdentifier;

#define TREE_VALUE(node) (TREE_LIST_CHECK(node)->list.value)

typedef struct
{
    TreeCommon common;
    TreeNode *value;
} TreeList;


#define TREE_VALUE_IDENTIFIER(node) (VALUE_STMT_CHECK(node)->value.identifier)
#define TREE_VALUE_VAL(node) (VALUE_STMT_CHECK(node)->value.val)

typedef struct
{
    TreeCommon common;
    TreeNode *identifier;
    TreeNode *val;
} TreeValue;


#define TREE_NAMESPACE_IDENTIFIER(node) (NAMESPACE_STMT_CHECK(node)->ns.identifier)
#define TREE_NAMESPACE_MEMBERS(node) (NAMESPACE_STMT_CHECK(node)->ns.members)

typedef struct
{
    TreeCommon common;
    TreeNode *identifier;
    TreeNode *members;
} TreeNamespace;

#define TREE_CLASS_IDENTIFIER(node) (CLASS_STMT_CHECK(node)->klass.identifier)
#define TREE_CLASS_DEFINED_BY(node) (CLASS_STMT_CHECK(node)->klass.defined_by)
#define TREE_CLASS_SUPERS(node) (CLASS_STMT_CHECK(node)->klass.supers)
#define TREE_CLASS_MEMBERS(node) (CLASS_STMT_CHECK(node)->klass.members)
#define TREE_CLASS_VPROXY_ID(node) (CLASS_STMT_CHECK(node)->klass.vproxy_id)

typedef struct
{
    TreeCommon common;
    TreeNode *identifier;
    TreeNode *defined_by;
    TreeNode *supers;
    TreeNode *members;
    int vproxy_id;
} TreeClass;

#define TREE_CLASSDECL_IDENTIFIER(node) (CLASS_DECL_CHECK(node)->classdecl.identifier)
#define TREE_CLASSDECL_DEFINED_BY(node) (CLASS_DECL_CHECK(node)->classdecl.defined_by)

typedef struct
{
    TreeCommon common;
    TreeNode *identifier;
    TreeNode *defined_by;
} TreeClassDecl;

typedef enum
{
  ATTR_CONSTRUCTOR,
  ATTR_GETTER,
  ATTR_SETTER,
  ATTR_SIGNAL,
  ATTR_METHOD,
  ATTR_CLASS_METHOD
} AttributeType;

#define TREE_ATTR_TYPE(node) (ATTR_STMT_CHECK(node)->attr.type)
#define TREE_ATTR_IDENTIFIER(node) (ATTR_STMT_CHECK(node)->attr.identifier)
#define TREE_ATTR_DEFINED_BY(node) (ATTR_STMT_CHECK(node)->attr.defby)
#define TREE_ATTR_SIGNATURE(node) (ATTR_STMT_CHECK(node)->attr.sig)
#define TREE_ATTR_RET_SPEC(node) (ATTR_STMT_CHECK(node)->attr.retspec)
#define TREE_ATTR_INLINE_ID(node) (ATTR_STMT_CHECK(node)->attr.inlineid)

typedef struct
{
    TreeCommon common;
    AttributeType type;
    TreeNode *identifier;
    TreeNode *defby;
    TreeNode *sig;
    TreeNode *retspec;
    int inlineid;
} TreeAttribute;

#define TREE_META_PLUGIN_IDENTIFIER(node) (META_PLUGIN_CHECK(node)->mplugin.identifier)
#define TREE_META_PLUGIN_DESCR(node) (META_PLUGIN_CHECK(node)->mplugin.descr)
#define TREE_META_PLUGIN_USED_MODULES(node) (META_PLUGIN_CHECK(node)->mplugin.used_modules)

typedef struct
{
    TreeCommon common;
    TreeNode *identifier;
    TreeNode *descr;
    TreeNode *used_modules;
} TreeMetaPlugin;

#define TREE_VERBATIM_TEXT(node) (VERBATIM_CHECK(node)->verbatim.text)

typedef struct
{
    TreeCommon common;
    const char *text;
} TreeVerbatim;

#define TREE_TYPENAME_IDENTIFIER(node) (TYPE_NAME_CHECK(node)->tn.identifier)
#define TREE_TYPENAME_TEMPLATE_SPEC(node) (TYPE_NAME_CHECK(node)->tn.tspec)

typedef struct
{
    TreeCommon common;
    AttributeType type;
    TreeNode *identifier;
    TreeNode *tspec;
} TreeTypename;

typedef enum
{
  TYPESPEC_UNSIGNED,
  TYPESPEC_SIGNED,
  TYPESPEC_LONG,
  TYPESPEC_SHORT,
  TYPESPEC_INT,
  TYPESPEC_CHAR,
  TYPESPEC_FLOAT,
  TYPESPEC_DOUBLE,
  TYPESPEC_BOOL,
  TYPESPEC_LAST_AND_UNUSED
} TypeSpec;

#define TYPESPEC_COUNT TYPESPEC_LAST_AND_UNUSED

#define TREE_TYPESPEC(node) (TYPE_SPEC_CHECK(node)->typespec.spec)

typedef struct
{
    TreeCommon common;
    TypeSpec spec;
} TreeTypeSpec;

typedef enum
{
  TYPEDESCR_NORMAL,
  TYPEDESCR_REF,
  TYPEDESCR_PTR
} TypeDescr;

#define TREE_TYPEDESCR(node) (TYPE_DESCR_CHECK(node)->typedescr.descr)
#define TREE_TYPEDESCR_SPECS(node) (TYPE_DESCR_CHECK(node)->typedescr.specs)

typedef struct
{
    TreeCommon common;
    TypeDescr descr;
    TreeNode *specs;
} TreeTypeDescr;

#define TREE_PARAMDESCR_TYPE(node) (PARAM_DESCR_CHECK(node)->argdescr.type)
#define TREE_PARAMDESCR_NAME(node) (PARAM_DESCR_CHECK(node)->argdescr.name)

#define TREE_IS_EMPTY_PARAMLIST(node) (node == NULL_TREE || TREE_PARAMDESCR_TYPE(TREE_VALUE(node)) == NULL_TREE)

typedef struct
{
    TreeCommon common;
    TreeNode *type;
    TreeNode *name;
} TreeParamDescr;

union TreeNode
{
    TreeCommon common;
    TreeStringCst string_cst;
    TreeIntCst int_cst;
    TreeList list;
    TreeValue value;
    TreeClass klass;
    TreeClassDecl classdecl;
    TreeAttribute attr;
    TreeIdentifier identifier;
    TreeTypeSpec typespec;
    TreeTypeDescr typedescr;
    TreeParamDescr argdescr;
    TreeTypename tn;
    TreeNamespace ns;
    TreeMetaPlugin mplugin;
    TreeVerbatim verbatim;
};

typedef TreeNode *Tree;

Tree tree_cons(Tree car, Tree cdr);
Tree tree_append(Tree list, Tree val);
int  tree_list_length(Tree list);

Tree tree_build_value(Tree ident, Tree val);
Tree tree_build_class(Tree ident, int wrapped, 
                      Tree defby, Tree supers, Tree members);
Tree tree_build_class_decl(Tree ident, Tree defby);
Tree tree_build_attribute(AttributeType type, Tree ident,
                          Tree defby, Tree sig, Tree retspec,
                          gboolean v, gboolean pure);
Tree tree_build_typename(Tree identifier, Tree template_spec);
Tree tree_build_paramdescr(Tree type, Tree ident);
Tree tree_build_string(const char *s);
Tree tree_build_integer(const char *s);
Tree tree_build_identifier(const char *s);
Tree tree_build_typespec(const char *s);
Tree tree_build_typedescr(int is_const, Tree specs, TypeDescr type);
Tree tree_build_namespace(Tree ident, Tree members);
Tree tree_build_meta_plugin(Tree ident, Tree descr, Tree used_modules);
Tree tree_build_verbatim(const char *s);

#if (__GNUC__ >= 2)

void tree_check_failed(const Tree node, TreeCode code, 
                       const char *filename, int line, const char *funcname);

#endif

#endif
