#include <unistd.h>

#include <string>
#include <iostream>

#include <sigc++/thread.h>
#include <sigc++/slot.h>
#include <sigc++/object_slot.h>
#include <sigc++/thread_tunnel.h>

#ifdef SIGC_CXX_NAMESPACES
using namespace std;
using namespace SigC;
using namespace SigC::Threads;
#endif

Semaphore done(0);

class Receiver : public Thread, public StandardDispatcher
{
  public:
    virtual void *main(void *arg);
    void receive(string msg) {
      cout << "received: " << msg << endl;
      usleep(500 * 1000);
    }
    bool receive_bool(string msg) {
      cout << "received (synchronous): " << msg << endl;
      return(true);
    }
};

class Sender : public Thread
{
  public:
    virtual void *main(void *arg);
};

Receiver receiver;
Sender sender;

ThreadTunnel tunnel(&receiver);

int main()
{
  receiver.start();
  sender.start();

  done.down();
  return 0;
}

void *Receiver::main(void *)
{
  run();
  done.up();
}

void *Sender::main(void *)
{
  const int N = 10;
  string msg;
  for (int i = 0; i < N; i++)
  {
    msg = (char)('A' + i);
    cout << "sending message: " << msg << " ";
    if (i % (N / 2) == 0)
    {
      cout << "synchronous!" << endl;
      cout << "response: " <<
        pack<bool, string>(slot(&receiver, &Receiver::receive_bool),
                           msg)->tunnel(&tunnel, true)
           << endl;
    }
    else
    {
      cout << "asynchronous" << endl;
      pack<void, string>(slot(&receiver, &Receiver::receive), msg)->tunnel(&tunnel);
    }
  }
  cout << "sending exit message" << endl;
  pack(slot(&receiver, &Dispatcher::exit))->tunnel(&tunnel);

  return(0);
}
