#include <gtk/gtkmain.h>

#include <sigc++/gtk_dispatch.h>

namespace SigC
{

void GtkDispatcher::input_callback(gpointer _event, gint fd,
                                   GdkInputCondition o)
{
  FileEvent *event = (FileEvent *)_event;

  event->cb->callback (event->disp, event->ev);
}

gint GtkDispatcher::timer_callback(gpointer _event)
{
  TimerEvent *event = (TimerEvent *)_event;
  GtkDispatcher *disp = event->disp;

  list<TimerEvent *>::iterator i;
  for (i = disp->tevents.begin(); i != disp->tevents.end(); ++i) {
    if ((*i) == event) {
      disp->tevents.erase(i);
      break;
    }
  }
  event->cb->callback (disp, Timer);
  delete event;

  return false;
}

GtkDispatcher::GtkDispatcher ()
{
}

GtkDispatcher::~GtkDispatcher ()
{
  list<FileEvent *>::iterator i;
  for (i = fevents.begin(); i != fevents.end(); ++i)
  {
    (*i)->cb->callback (this, Remove);
    delete *i;
  }

  list<TimerEvent *>::iterator j;
  for (j = tevents.begin(); j != tevents.end(); ++j)
  {
    (*j)->cb->callback (this, Remove);
    delete *j;
  }
}

void GtkDispatcher::add_input_handler(Handler *cb, int fd)
{
  FileEvent *ev = new FileEvent (this, 0, cb, Read);

  ev->tag = gdk_input_add (fd, GDK_INPUT_READ, 
                           input_callback, (gpointer)ev);
  fevents.push_back (ev);
}

void
GtkDispatcher::add_output_handler(Handler *cb, int fd)
{
  FileEvent *ev = new FileEvent (this, 0, cb, Write);

  ev->tag = gdk_input_add (fd, GDK_INPUT_WRITE, 
                           input_callback, (gpointer)ev);

  fevents.push_back (ev);
}

void GtkDispatcher::add_exception_handler(Handler *cb, int fd)
{
  FileEvent *ev = new FileEvent(this, 0, cb, Except);

  ev->tag = gdk_input_add (fd, GDK_INPUT_EXCEPTION, 
                           input_callback, (gpointer)ev);
  fevents.push_back (ev);
}

void GtkDispatcher::add_timeout_handler(Handler *cb,
                                        unsigned long tmout)
{
  TimerEvent *ev = new TimerEvent(this, 0, cb);

  ev->tag = gtk_timeout_add(tmout, timer_callback, (gpointer)ev);
  tevents.push_back (ev);
}

void GtkDispatcher::remove(Handler *cb, Event e)
{
  if (e == All || e == Timer)
  {
    list<TimerEvent *>::iterator i, next;
    for (i = tevents.begin(); i != tevents.end(); i = next)
    {
      next = i;
      ++next;
      if ((*i)->cb == cb) {
        gtk_timeout_remove((*i)->tag);
        delete *i;
        tevents.erase (i);
      }
    }
  }
  if (e == All || e == Read || e == Write || e == Except)
  {
    list<FileEvent *>::iterator i, next;
    for (i = fevents.begin(); i != fevents.end(); i = next)
    {
      next = i;
      ++next;
      if ((*i)->cb == cb && (e == All || e == (*i)->ev))
      {
        gdk_input_remove((*i)->tag);
        delete *i;
        fevents.erase (i);
      }
    }
  }
}

void GtkDispatcher::run(bool infinite)
{
  do
  {
    gtk_main_iteration();
  } while (infinite);
}

void GtkDispatcher::move(Dispatcher *)
{
  assert(0);
}

bool GtkDispatcher::idle() const
{
  return fevents.size() + tevents.size() == 0;
}

void GtkDispatcher::exit()
{
  gtk_main_quit();
}

}
