#!perl -w
#
# CcwMapEntry - encapsulate a line from modules.ccwmap.
#   Copyright (C) 2005  Erik van Konijnenburg
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
#
# Knows how to match, can return module name.
#

use strict;
use warnings;
use Base;
package CcwMapEntry;
use base 'Obj';

sub fill {
	my $self = shift;
	$self->SUPER::fill();
	$self->takeArgs ('module', 'match_flags', 'cu_type', 'cu_model',
			'dev_type', 'dev_model');
}

sub module	{ return $_[0]->{module}; }
sub match_flags	{ return $_[0]->{match_flags}; }
sub cu_type	{ return $_[0]->{cu_type}; }
sub cu_model	{ return $_[0]->{cu_model}; }
sub dev_type	{ return $_[0]->{dev_type}; }
sub dev_model	{ return $_[0]->{dev_model}; }

my $CCW_DEVICE_ID_MATCH_CU_TYPE		= 0x01;
my $CCW_DEVICE_ID_MATCH_CU_MODEL	= 0x02;
my $CCW_DEVICE_ID_MATCH_DEVICE_TYPE	= 0x04;
my $CCW_DEVICE_ID_MATCH_DEVICE_MODEL	= 0x08;

sub matches {
	my ($self, $dev) = @_;
	my $match = $self->match_flags;

	if ($match & $CCW_DEVICE_ID_MATCH_CU_TYPE && $self->cu_type != $dev->cu_type) {
		return 0;
	}
	if ($match & $CCW_DEVICE_ID_MATCH_CU_MODEL && $self->cu_model != $dev->cu_model) {
		return 0;
	}
	if ($match & $CCW_DEVICE_ID_MATCH_DEVICE_TYPE && $self->dev_type != $dev->dev_type) {
		return 0;
	}
	if ($match & $CCW_DEVICE_ID_MATCH_DEVICE_MODEL && $self->dev_model != $dev->dev_model) {
		return 0;
	}

	return 1;
}

1;

