#! /usr/bin/perl -w


# Ham Radio Contest Country check module calls.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    calls.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    calls.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

#################################################
# API:
# add, check, delete calls in hash per band... 
# Input is call and band (int)
# Output is nr. of records per call
#
# addcall($call, $band);
# checkcall($call, $band)
# delcall($call, $band)
# 
# @cnts = countcalls() (160, 80, 40,20, 15,10)
#################################################

use Switch;

my @callslist = ();


1;



#################################################
sub addcalls {
#################################################
	my ($calls, $band) = @_;

	switch($band) {
		case 160	{$r = addcalls_160($calls)}
		case  80	{$r = addcalls_80($calls)}
		case  40	{$r = addcalls_40($calls)}
		case  20	{$r = addcalls_20($calls)}
		case  15	{$r = addcalls_15($calls)}
		case  10	{$r = addcalls_10($calls)}
	}
	return $r;
}

#################################################
sub checkcalls {
#################################################
	my ($calls, $band) = @_;

	switch($band) {
		case 160	{$r = checkcalls_160($calls)}
		case  80	{$r = checkcalls_80($calls)}
		case  40	{$r = checkcalls_40($calls)}
		case  20	{$r = checkcalls_20($calls)}
		case  15	{$r = checkcalls_15($calls)}
		case  10	{$r = checkcalls_10($calls)}
		case  99	{$r = checkcalls_all($calls)}
	}
	return $r;
}

#################################################
sub delcalls {
#################################################
	my ($calls, $band) = @_;

	switch($band) {
		case 160	{$r = delcalls_160($calls)}
		case  80	{$r = delcalls_80($calls)}
		case  40	{$r = delcalls_40($calls)}
		case  20	{$r = delcalls_20($calls)}
		case  15	{$r = delcalls_15($calls)}
		case  10	{$r = delcalls_10($calls)}
	}
	return $r;
}


{ # start block#########################################
my %calls_all;
my %calls_10;
#################################################
sub addcalls_10 {
#################################################
	my $calls = shift @_;
	
		$calls_10{$calls}++;
		return $calls_10{$calls};	
}
#################################################
sub checkcalls_10 {
#################################################
	my $calls = shift @_;
	if ($calls_10{$calls}) {
		return $calls_10{$calls};
	}
	return 0;
}

#################################################
sub delcalls_10 {
#################################################
	my $calls = shift @_;
	
	if ($calls_10{$calls}) {
		$calls_10{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_10{$calls};
	}
	return 0;
}

my %calls_15;
#################################################
sub addcalls_15 {
#################################################
	my $calls = shift @_;
	
		$calls_15{$calls}++;
		return $calls_15{$calls};
	
}
#################################################
sub checkcalls_15 {
#################################################
	my $calls = shift @_;
	if ($calls_15{$calls}) {
		return $calls_15{$calls};
	}
	return 0;
}

#################################################
sub delcalls_15 {
#################################################
	my $calls = shift @_;
	
	if ($calls_15{$calls}) {
		$calls_15{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_15{$calls};
	}
	return 0;
}

my %calls_20;
#################################################
sub addcalls_20 {
#################################################
	my $calls = shift @_;
	
		$calls_20{$calls}++;
		return $calls_20{$calls};	
}
#################################################
sub checkcalls_20 {
#################################################
	my $calls = shift @_;
	if ($calls_20{$calls}) {
		return $calls_20{$calls};
	}
	return 0;
}

#################################################
sub delcalls_20 {
#################################################
	my $calls = shift @_;
	
	if ($calls_20{$calls}) {
		$calls_20{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_20{$calls};
	}
	return 0;
}

my %calls_40;
#################################################
sub addcalls_40 {
#################################################
	my $calls = shift @_;
	
		$calls_40{$calls}++;
		return $calls_40{$calls};
	
}
#################################################
sub checkcalls_40 {
#################################################
	my $calls = shift @_;
	if ($calls_40{$calls}) {
		return $calls_40{$calls};
	}
	return 0;
}

#################################################
sub delcalls_40 {
#################################################
	my $calls = shift @_;
	
	if ($calls_40{$calls}) {
		$calls_40{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_40{$calls};
	}
	return 0;
}

my %calls_80;
#################################################
sub addcalls_80 {
#################################################
	my $calls = shift @_;
	
		$calls_80{$calls}++;
		return $calls_80{$calls};	
}
#################################################
sub checkcalls_80 {
#################################################
	my $calls = shift @_;
	if ($calls_80{$calls}) {
		return $calls_80{$calls};
	}
	return 0;
}

#################################################
sub delcalls_80 {
#################################################
	my $calls = shift @_;
	
	if ($calls_80{$calls}) {
		$calls_80{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_80{$calls};
	}
	return 0;
}

my %calls_160;
#################################################
sub addcalls_160 {
#################################################
	my $calls = shift @_;
	
		$calls_160{$calls}++;
		return $calls_160{$calls};
	
}
#################################################
sub checkcalls_160 {
#################################################
	my $calls = shift @_;
	if ($calls_160{$calls}) {
		return $calls_160{$calls};
	}
	return 0;
}

#################################################
sub delcalls_160 {
#################################################
	my $calls = shift @_;
	
	if ($calls_160{$calls}) {
		$calls_160{$calls}--; 
		$calls_all{$calls}--; 
		return $calls_160{$calls};
	}
	return 0;
}

#################################################
sub checkcalls_all {
#################################################
	my $calls = shift @_;
	if ($calls_all{$calls}) {
		return $calls_all{$calls};
	}
	return 0;
}

#################################################
sub countcalls {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %calls_160) {
		$count += $calls_160{$key};
	}
	push @out, $count;
	foreach my $key (keys %calls_80) {
		$count += $calls_80{$key};
	}
	push @out, $count;
	foreach my $key (keys %calls_40) {
		$count += $calls_40{$key};
	}
	push @out, $count;
	foreach my $key (keys %calls_20) {
		$count += $calls_20{$key};
	}
	push @out, $count;
	foreach my $key (keys %calls_15) {
		$count += $calls_15{$key};
	}
	push @out, $count;
	foreach my $key (keys %calls_10) {
		$count += $calls_10{$key};
	}
	push @out, $count;
	
	return @out;
}

########################################
sub init_calls {
########################################
%calls_all = ();
%calls_160 = ();
%calls_80 = ();
%calls_40 = ();
%calls_20 = ();
%calls_15 = ();
%calls_10 = ();

}

} # end block ############################################
	

#################################################
sub testcalls {
#################################################

	while (1) {
		print "\nEnter call:";
		my $call = <STDIN>;
		chomp $call;
		if ($call eq "q") {
			exit;
		} else {
			if (calls_valid ($calls)) {
				print "$calls is o.k.!\n";
			} else {
				print "Not found!\n";
			}
		}
	}
}
1;

