/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONFIGFILE_H
#define CONFIGFILE_H

class QWidget;

#include <qstring.h>

#include "wrapper/emucfg.h"

#include "AudioConfig.h"
#include "HVSC_Config.h"
#include "MixerConfig.h"
#include "tools/IniFile.h"
#include "SidIdConfig.h"
#ifdef XSID_HAVE_TSID2
#include "TSID2Config.h"
#endif

class ConfigFile : public IniFile
{
 public:
    ConfigFile(const char*);

    bool load( const char* fname = 0 );
    bool save();

    const QString& getFileName() const;

    void restoreGeom(QWidget*);
    void saveGeom(const QWidget*);
    
    const AudioConfig& getAudioConfig() const;
    const emuConfig& getEmuConfig() const;
    const HVSC_Config& getHVSC_Config() const;
    const MixerConfig& getMixerConfig() const;
    const SidIdConfig& getSidIdConfig() const;
#ifdef XSID_HAVE_TSID2
    const TSID2Config& getTSID2Config() const;
#endif

    void setAudioConfig(const AudioConfig& inAudioConfig);
    void setEmuConfig(const emuConfig& inEmuConfig);
    void setHVSC_Config(const HVSC_Config& inHVSC_Config);
    void setMixerConfig(const MixerConfig& inMixerConfig);
    void setSidIdConfig(const SidIdConfig& inSidIdConfig);
#ifdef XSID_HAVE_TSID2
    void setTSID2Config(const TSID2Config& inTSID2Config);
#endif


 protected:

    AudioConfig myAudioConfig;  // the audio driver settings
    emuConfig myEmuConfig;      // the emulator engine settings
    HVSC_Config myHVSC_Config;  // the HVSC/STIL settings
    MixerConfig myMixerConfig;
    SidIdConfig mySidIdConfig;  // the SidId settings
    QString fileName;
#ifdef XSID_HAVE_TSID2
    TSID2Config myTSID2Config;  // the TSID2 setting
#endif
};

#endif  /* CONFIGFILE_H */
