/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef WAVEVIEWDIALOG_H
#define WAVEVIEWDIALOG_H

class QPainter;
class QPaintEvent;

#include "WaveViewDialogData.h"
#include "AudioConfig.h"

class WaveViewDialog : public WaveViewDialogData
{
    Q_OBJECT

 public:

    WaveViewDialog(QWidget* parent = 0, const char* name = 0);
    ~WaveViewDialog();

    void show();
    bool isShown();
    void paintWaveformFunc(const void*);
    void setConfig(const AudioConfig&);

 protected slots:
    
    void done(int);

 protected:
    
    void paintEvent(QPaintEvent*);
    void resizeEvent(QResizeEvent*);
    
    bool shown;
    const QPixmap* myWavePicOrig;
    const void* lastBuffer;
    AudioConfig config;

};

#endif  /* WAVEVIEWDIALOG_H */
