/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef STILDIALOG_H
#define STILDIALOG_H

class QLabel;
class QScrollView;

#include <qdialog.h>
#include <qstring.h>

#include "HVSC_Config.h"

class StilDialog : public QDialog
{
    Q_OBJECT

 public:

    /* Because of a problem with KDE 1.1.2 and kwm, StilDialog
     * is not implemented as a child dialog. 
     */
    
    StilDialog(QWidget* mainWin, QWidget* parent = 0, const char* name = 0);

    const HVSC_Config& getConfig() const;
    void setLabels(const char*, const char*, const char*);

 public slots:

    void setConfig(const HVSC_Config&);

 protected:

    virtual void resizeEvent(QResizeEvent*);

    QScrollView* scrollView;
        
    QLabel* globalLabel;
    QString globalString;

    QLabel* stilLabel;
    QString stilString;

    QLabel* bugLabel;
    QString bugString;

    HVSC_Config config;
    
 private:
    QWidget* main;
};

#endif  /* STILDIALOG_H */
