/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkcombo.c,v 1.3 2001/04/12 17:02:38 justins Exp $ */
/*
   
   xscorch - slinkcombo.c     Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Scorched combolist widgets
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <slinkcombo.h>
#include <gdk/gdkkeysyms.h>



enum _ScLinkComboSignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static gint _sc_link_combo_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_combo_set(GtkEntry *entry, ScLinkCombo *combo) {

   const char **entries;
   const char *curtext; 
   gint i;

   entries = gtk_object_get_user_data(GTK_OBJECT(entry));
   if(entries == NULL) return;
   
   curtext = gtk_entry_get_text(GTK_ENTRY(entry));
   for(i = 0; entries[i] != NULL; ++i) {
      if(!strcmp(entries[i], curtext)) {
         if(combo->value != NULL) *combo->value = i;
         gtk_signal_emit(GTK_OBJECT(combo), _sc_link_combo_signals[MODIFIED_SIGNAL]);
         return;
      }
   }   

}
 
 
 
static void _sc_link_combo_class_init(ScLinkComboClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   _sc_link_combo_signals[MODIFIED_SIGNAL] =
      gtk_signal_new("modified", 
                     GTK_RUN_LAST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET(ScLinkComboClass, modified),
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);

   gtk_object_class_add_signals(object_class, _sc_link_combo_signals, LAST_SIGNAL);
   klass->modified = NULL;

}



static void _sc_link_combo_init_obj(ScLinkCombo *combo) {
   
   combo->value = NULL;
   
   gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry), "changed", GTK_SIGNAL_FUNC(_sc_link_combo_set), combo);

}



GtkType sc_link_combo_get_type(void) {

   static GtkType sc_link_combo_type = 0;
   
   if(sc_link_combo_type == 0) {
      static const GtkTypeInfo sc_link_combo_info = {
         (char *)"ScLinkCombo",
         sizeof(ScLinkCombo),
         sizeof(ScLinkComboClass),
         (GtkClassInitFunc)_sc_link_combo_class_init,
         (GtkObjectInitFunc)_sc_link_combo_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_link_combo_type = gtk_type_unique(gtk_combo_get_type(), &sc_link_combo_info);
   }
    
   return(sc_link_combo_type);

}  



GtkWidget *sc_link_combo_new(int *value, const char **entries) {

   ScLinkCombo *combo;
   GList *items = NULL;
   gint i;
   
   combo = gtk_type_new(sc_link_combo_get_type());
   g_return_val_if_fail(combo != NULL, NULL);
            
   for(i = 0; entries[i] != NULL; ++i) {
      items = g_list_append(items, (char *)entries[i]);
   }
   
   gtk_combo_set_popdown_strings(GTK_COMBO(combo), items);
   gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, FALSE);
   gtk_widget_set_usize(GTK_WIDGET(combo), 130, 0);
   gtk_object_set_user_data(GTK_OBJECT(GTK_COMBO(combo)->entry), entries);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), entries[*value]);
   combo->value = value;

   return(GTK_WIDGET(combo));

}



