/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-ecat64.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : Read and Write ECAT 6.4 files                            *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : MdcCheckECAT()          - Check for ECAT format          * 
 *                MdcReadECAT()           - Read ECAT 6.4 file             *
 *                MdcWriteECAT()          - Write ECAT 6.4 file            *
 *                                                                         *
 * Notes        : DEBIAN - code removed due to unclear licensing           * 
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* - debian dummy file v0.2 -
 */

/*
   Copyright (C) 1997-2002 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#ifndef _WIN32
#include <strings.h>
#endif
#endif

#include "medcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
int MdcCheckECAT6(FILEINFO *fi)
{
  return MDC_FRMT_NONE;
}

char *MdcReadECAT6(FILEINFO *fi)
{
  return("ECAT Reading unsupported (unclear licensing)");
}

char *MdcWriteECAT6(FILEINFO *fi)
{
  return("ECAT Writing unsupported (unclear licensing)");
}

