/* 
 * Copyright (C) 2000 Rich Wareham <richwareham@users.sourceforge.net>
 * 
 * This file is part of xine, a unix video player.
 * 
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: extra_ifo_types.h,v 1.2 2001/12/16 16:03:53 jcdutton Exp $
 *
 */

/* These are defined here because they are not in ifo_types.h, they maybe
 * one day */

typedef struct {
#ifdef WORDS_BIGENDIAN
  unsigned int available : 1;
  unsigned int zero1 : 4;
  unsigned int stream_number : 3;
  uint8_t zero2;
#else
  uint8_t zero2;
  unsigned int stream_number : 3;
  unsigned int zero1 : 4;  
  unsigned int available : 1;
#endif
} ATTRIBUTE_PACKED audio_status_t;

typedef struct {
#ifdef WORDS_BIGENDIAN
  unsigned int available : 1;
  unsigned int zero1 : 2;
  unsigned int stream_number_4_3 : 5;
  unsigned int zero2 : 3;
  unsigned int stream_number_wide : 5;
  unsigned int zero3 : 3;
  unsigned int stream_number_letterbox : 5;
  unsigned int zero4 : 3;
  unsigned int stream_number_pan_scan : 5;
#else
  unsigned int stream_number_pan_scan : 5;
  unsigned int zero4 : 3;
  unsigned int stream_number_letterbox : 5;
  unsigned int zero3 : 3;
  unsigned int stream_number_wide : 5;
  unsigned int zero2 : 3;
  unsigned int stream_number_4_3 : 5;
  unsigned int zero1 : 2;  
  unsigned int available : 1;
#endif
} ATTRIBUTE_PACKED spu_status_t;

