/*
	main.c
	13.3.99 tn
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk_imlib.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "xpms/xcdricon.xpm"

GtkWidget *toplevel;
GtkWidget *splitspace;
GtkWidget *sidespace;
GtkWidget *workspace;
setup_data_t setupdata;
current_set_t curset;
extern gchar sharedir[MAXLINE];
extern gchar rootconfig[MAXLINE];
extern gchar xcdroast_version_loaded[MAXLINE];

gint lastxsize, lastysize;
gint debug;
gint submenu;
gint bigfonts;
gint oldfontcode;
gint ignorescanbus;

/* exit-button handler */

void menu_exit(GtkWidget *widget, gpointer data) {
gint ret;

	ret = show_dialog(ICO_QUEST,text(12),T_YES,T_NO,NULL,0);
	
	if (ret == 0) {
		dolog(1,"Exiting...\n");
		gtk_main_quit();
	}
}


/* set the width of the sidebar - relative to width of toplevel */

void set_sidebar_width() {
gint x, y;
gint val;

	/* check if we are already realized */
	if (GTK_WIDGET(toplevel)->window == NULL) {
		val = 150;
	} else {
		/* set relative to new size */
		gdk_window_get_size(GTK_WIDGET(toplevel)->window,&x,&y);

		/* workaround for a little gtk bug - in some chases 
 		   the current window size is reported wrongly as 200x200 */
		if (x == 200 && y == 200) {
			if (bigfonts == 0) 
				x = XCDR_TOPLEVEL_X0;
			else 
				x = XCDR_TOPLEVEL_X1;
		}
		val = (x*150)/790;
	}

	gtk_widget_set_usize(sidespace,val,0);
}


/* called everytime some window resizes - we check if the toplevel
   changed and set the sidebar to the value we want. This way
   we can dynamically resize and the layout does not change */

void resize_handler(GtkWidget *widget, gpointer data) {
gint x, y;

	/* check if we are already realized */
	if (GTK_WIDGET(toplevel)->window == NULL) 
		return;

	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&x,&y);

	/* size of toplevel changed? */
	if (x != lastxsize || y != lastysize) {
		/* remember new size */
		lastxsize = x;
		lastysize = y;

		/* set sidebar width to new value */
		set_sidebar_width();
	}
}


/* setup-button handler */

void menu_setup(GtkWidget *widget, gpointer data) {

	dolog(2,"Entering setup\n");
	create_setup();
}


/* duplicate-button handler */

void menu_duplicate(GtkWidget *widget, gpointer data) {

	dolog(2,"Entering duplicate cd\n");
	create_duplicate();
}


/* create-button handler */

void menu_create(GtkWidget *widget, gpointer data) {

	dolog(2,"Entering create cd\n");
	create_create();
}


/* set the pixmap icon */

void set_wm_icon() {
GtkStyle *style;
GdkBitmap *bitmap;
GdkPixmap *pixmap;
GdkColormap *colormap;
GdkColor wait_color={0,0,0,0};

	style=gtk_widget_get_style(GTK_WIDGET(toplevel));
	pixmap=gdk_pixmap_create_from_xpm_d(GTK_WIDGET(toplevel)->window,
		&bitmap, &style->bg[GTK_STATE_NORMAL], xcdricon_xpm);
	colormap = gtk_widget_get_colormap(GTK_WIDGET(toplevel));
	gdk_color_alloc (colormap, &wait_color);
	gdk_window_set_icon(GTK_WIDGET(toplevel)->window, (GdkWindow *)NULL,  pixmap, bitmap);
}


/* draw the main-menu */

void create_main(gint confignotloaded) {
GtkWidget *side_t;
GtkWidget *side_t_btn1;
GtkWidget *side_t_btn2;
GtkWidget *side_t_btn3;
GtkWidget *side_t_btn4;
GtkWidget *work_t;
GtkWidget *work_t_l1;
GtkWidget *work_t_l2;
GdkPixmap *p;
GdkBitmap *m;
GdkImlibImage *im;
GtkWidget *xcdroast_logo, *burnproof_logo;
GtkWidget *logoalign;
gint w,h;
gchar tmp[MAXLINE];


	submenu = 0;
        clear_sidespace();
        clear_workspace();

	side_t = gtk_table_new(10,10, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(side_t),10);
	gtk_box_pack_start(GTK_BOX(sidespace), side_t,TRUE,TRUE,0);

	side_t_btn1 = gtk_button_new_with_label (text(4));
	side_t_btn2 = gtk_button_new_with_label (text(5));
	side_t_btn3 = gtk_button_new_with_label (text(6));
	side_t_btn4 = gtk_button_new_with_label (text(7));

	gtk_signal_connect (GTK_OBJECT (side_t_btn1), "clicked",
		GTK_SIGNAL_FUNC(menu_setup),NULL);
	gtk_signal_connect (GTK_OBJECT (side_t_btn2), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate),NULL);
	gtk_signal_connect (GTK_OBJECT (side_t_btn3), "clicked",
		GTK_SIGNAL_FUNC(menu_create),NULL);
	gtk_signal_connect (GTK_OBJECT (side_t_btn4), "clicked",
		GTK_SIGNAL_FUNC(menu_exit),NULL);

	gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn1, 0,10,4,5);
	gtk_widget_show(side_t_btn1);
 	define_tooltip(side_t_btn1,help(0));

	gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn2, 0,10,5,6);
	gtk_widget_show(side_t_btn2);
 	define_tooltip(side_t_btn2,help(1));

	gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn3, 0,10,6,7);
	gtk_widget_show(side_t_btn3);
 	define_tooltip(side_t_btn3,help(2));

	gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn4, 0,10,8,9);
	gtk_widget_show(side_t_btn4);
 	define_tooltip(side_t_btn4,help(3));

	gtk_widget_show(side_t);
	gtk_widget_show(sidespace);


	/* draw the workspace */

	work_t = gtk_table_new(10,10, TRUE);
	gtk_box_pack_start(GTK_BOX(workspace), work_t,TRUE,FALSE,0);

        /* load a gif-image and put into a pixmap */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
        im=gdk_imlib_load_image(tmp);
	if (im) {
        	w=im->rgb_width;
        	h=im->rgb_height;
        	gdk_imlib_render(im,w,h);
        	p=gdk_imlib_move_image(im);
        	m=gdk_imlib_move_mask(im);
        	xcdroast_logo = gtk_pixmap_new(p,m);
	} else {
		xcdroast_logo = gtk_label_new("[LOGO]");
	}
	gtk_table_attach_defaults(GTK_TABLE(work_t), xcdroast_logo, 0,10,0,4);
	gtk_misc_set_alignment(GTK_MISC(xcdroast_logo),1.0f, 1.0f);
	gtk_widget_show(xcdroast_logo);

        /* load a gif-image and put into a pixmap */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, BURNPROOFLOGO);
        im=gdk_imlib_load_image(tmp);
	if (im) {
        	w=im->rgb_width;
        	h=im->rgb_height;
        	gdk_imlib_render(im,w,h);
        	p=gdk_imlib_move_image(im);
        	m=gdk_imlib_move_mask(im);
        	burnproof_logo = gtk_pixmap_new(p,m);
	} else {
		burnproof_logo = gtk_label_new("[BURNPROOF]");
	}
	logoalign = gtk_alignment_new(1.0,1.0,0,0);
	gtk_container_add(GTK_CONTAINER(logoalign), burnproof_logo);
	gtk_table_attach_defaults(GTK_TABLE(work_t), logoalign, 0,10,9,10);
	gtk_widget_show(burnproof_logo);
	gtk_widget_show(logoalign);

	g_snprintf(tmp,MAXLINE,text(3),XCDROAST_VERSION);
	work_t_l1=gtk_label_new(tmp);
	gtk_label_set_justify(GTK_LABEL(work_t_l1),GTK_JUSTIFY_CENTER);
	gtk_table_attach_defaults(GTK_TABLE(work_t), work_t_l1, 0,10,4,5);
	set_font_and_color(work_t_l1,BIGFONT,"red");

	work_t_l2=gtk_label_new(text(1));
	gtk_label_set_justify(GTK_LABEL(work_t_l2),GTK_JUSTIFY_CENTER);
	gtk_table_attach_defaults(GTK_TABLE(work_t), work_t_l2, 0,10,5,6);

	gtk_widget_show(work_t_l1);
	gtk_widget_show(work_t_l2);

	gtk_widget_show(work_t);	
	gtk_widget_show(workspace);

	if (confignotloaded) {
		gtk_widget_set_sensitive(side_t_btn2, FALSE);
		gtk_widget_set_sensitive(side_t_btn3, FALSE);
	}
}


/* main */

gint main(gint argc, gchar *argv[]) {
GtkWidget *w;
gint confignotloaded;
gchar tmp[MAXLINE];
GtkStyle *style;

	gtk_set_locale();
	gtk_init(&argc,&argv);
	gdk_imlib_init();
	gtk_widget_push_colormap(gdk_imlib_get_colormap());
	gtk_widget_push_visual(gdk_imlib_get_visual());

	/* private init for xcdroast */
	confignotloaded = init(argc, argv);

	w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* save this pointer for future reference */
	toplevel = w;

	lastxsize = 0;
	lastysize = 0;

	/* check which font size we are running */
	style = gtk_widget_get_style(toplevel);
	if (gdk_char_height(style->font,'|') > 12) {
		/* our font is higher as 12 pixels */
		bigfonts = 1;
	} else {
		bigfonts = 0;
	}

	gtk_widget_realize(toplevel);
	set_wm_icon();
	gtk_window_set_title(GTK_WINDOW(w),text(2));
	if (bigfonts == 0) {
		/* size for 75dpi fonts */
		gtk_widget_set_usize(GTK_WIDGET(w),
			XCDR_TOPLEVEL_X0,XCDR_TOPLEVEL_Y0);
	} else {
		/* size for 100dpi fonts */
		gtk_widget_set_usize(GTK_WIDGET(w),
			XCDR_TOPLEVEL_X1,XCDR_TOPLEVEL_Y1);
	}
	gtk_container_border_width(GTK_CONTAINER(w),10);

	gtk_signal_connect (GTK_OBJECT(w), "destroy",
		GTK_SIGNAL_FUNC (gtk_exit), NULL);

	gtk_signal_connect (GTK_OBJECT(w), "delete_event",
		GTK_SIGNAL_FUNC(menu_exit), NULL);

	gtk_signal_connect (GTK_OBJECT(w), "size_request",
		GTK_SIGNAL_FUNC(resize_handler), NULL);


	splitspace = gtk_hpaned_new();
	gtk_container_add(GTK_CONTAINER(w),splitspace);
	gtk_paned_handle_size(GTK_PANED(splitspace),0);
	gtk_paned_gutter_size(GTK_PANED(splitspace),20);

	/* left side */
	sidespace = gtk_vbox_new(FALSE,0);
	gtk_paned_add1(GTK_PANED(splitspace), sidespace);
	set_sidebar_width();

	/* right side */
	workspace = gtk_vbox_new(FALSE,0);
	gtk_paned_add2(GTK_PANED(splitspace), workspace);

        /* check if screen-size is big enough */
	if (check_screensize(bigfonts)) { 
		if (bigfonts == 0) {
			g_snprintf(tmp,MAXLINE,text(290), 800, 600);
		} else {
			g_snprintf(tmp,MAXLINE,text(290), 1024, 768);
		}
		show_dialog(ICO_ERROR,tmp,T_OK,NULL,NULL,0);
		gtk_exit(1);
	}

	if (confignotloaded) {
		if (isroot()) {
			show_dialog(ICO_INFO, text(438), T_OK, NULL, NULL, 0);
		} else {
			show_dialog(ICO_INFO, text(279), T_OK, NULL, NULL, 0);
		}
	} else {
		/* check if the configfile is for current version of xcdroast */
		if (strcmp(XCDROAST_VERSION, xcdroast_version_loaded) != 0) {

			g_snprintf(tmp,MAXLINE,text(280), xcdroast_version_loaded);
			show_dialog(ICO_INFO, tmp, T_OK, NULL, NULL, 0);
			strcpy(xcdroast_version_loaded,"");
			confignotloaded = 1;
			if (isroot()) {
				/* if config is from old version, we can
				   assume that it still got the wrong perms */
				/* fix them */
				chmod(rootconfig, 0644);
			}
		}

		/* now check if our config is matching the current hardware */
		if (verify_loaded_config() == 1) {
			/* scsi-bus changed */
			show_dialog(ICO_WARN, text(284), T_OK, NULL, NULL, 0);
			strcpy(xcdroast_version_loaded,"");
			confignotloaded = 1;
		}
		if (verify_loaded_config2() == 1) {
			/* image-dirs changed */
			show_dialog(ICO_WARN, text(285), T_OK, NULL, NULL, 0);
			strcpy(xcdroast_version_loaded,"");
			confignotloaded = 1;
		}

	}

	create_main(confignotloaded);

	gtk_widget_show(splitspace);
	gtk_widget_show(w);

	/* lets see if we have special writer-options available */
	scanoptions(setupdata.writer_devnr);

	/* let the screen update now */
	while (gtk_events_pending())
		gtk_main_iteration();

	/* show disclaimer (old disclaimer nr 288) */
/*
	if (show_dialog(ICO_WARN, text(415), T_YES, T_NO, NULL, 1) == 1) {
		gtk_exit(1);
	}
*/
	dolog(1,"Starting...\n");

	gtk_main();
	
	return 0;
}
