/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardViewer.cpp
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#include "xcardViewer.h"
#include <qfile.h>

#include <stdio.h>
#include <stdlib.h>

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#ifdef MSC_TARGET_WIN32
#define snprintf _snprintf
#endif

#define Inherited xcardViewerData

xcardViewer::xcardViewer
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{

}

xcardViewer::~xcardViewer()
{
}

QString xcardViewer::getDefaultViewer() {

  char viewerPath[200];
  char *viewPointer;
  char configPath[200];

#ifdef MSC_TARGET_UNIX
  snprintf(configPath, sizeof(configPath), "%s/.xcardII", getenv("HOME"));
#else
  snprintf(configPath, sizeof(configPath), "%s\\.xcardII", getenv("USERPROFILE"));
#endif

  do {
    
	QFile inFile(configPath);

    if ( inFile.exists() == FALSE ) {
      printf("Error opening viewer file\n");
      break;
    }

	inFile.open(IO_ReadOnly);

	inFile.readLine(viewerPath, sizeof(viewerPath));
	viewPointer = &viewerPath[7];
    
	inFile.close();

    printf("View path %s\n", viewPointer);
    return QString(viewPointer);

  } while (0);

  hide();

  return NULL;
}

void xcardViewer::XCViewerOKClicked()
{
  FILE *fp;
  char configPath[200];

#ifdef MSC_TARGET_UNIX
  snprintf(configPath, sizeof(configPath), "%s/.xcardII", getenv("HOME"));
#else
  snprintf(configPath, sizeof(configPath), "%s\\.xcardII", getenv("USERPROFILE"));
#endif

  do {
    
    fp = fopen(configPath, "w");
    
    if ( fp == NULL ) {
      printf("Error opening viewer file\n");
      break;
    }
    
    fprintf(fp, "VIEWER=%s", g_viewerText1->text().latin1());
    
    fclose(fp);

    hide();

  } while (0);

}

void xcardViewer::XCViewerCancelClicked()
{
  hide();
}
