/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.gif.GIFNeuralColorMap;
import org.freehep.graphicsio.gif.ImageEncoder;

public class GIFEncoder
extends ImageEncoder {
    private boolean interlace = false;
    private String comment = null;
    int width;
    int height;
    int[][] rgbPixels;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GIFEncoder(Image image, OutputStream outputStream) throws IOException {
        this(image, outputStream, false);
    }

    public GIFEncoder(Image image, DataOutput dataOutput) throws IOException {
        this(image, dataOutput, false);
    }

    public GIFEncoder(Image image, OutputStream outputStream, boolean bl2) throws IOException {
        this(image, (DataOutput)new DataOutputStream(outputStream), bl2);
    }

    public GIFEncoder(Image image, DataOutput dataOutput, boolean bl2) throws IOException {
        super(image, dataOutput);
        this.interlace = bl2;
    }

    public GIFEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        this(imageProducer, outputStream, false);
    }

    public GIFEncoder(ImageProducer imageProducer, DataOutput dataOutput) throws IOException {
        this(imageProducer, dataOutput, false);
    }

    public GIFEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl2) throws IOException {
        this(imageProducer, (DataOutput)new DataOutputStream(outputStream), bl2);
    }

    public GIFEncoder(ImageProducer imageProducer, DataOutput dataOutput, boolean bl2) throws IOException {
        super(imageProducer, dataOutput);
        this.interlace = bl2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    protected void encodeStart(int n2, int n3) throws IOException {
        this.width = n2;
        this.height = n3;
        this.rgbPixels = new int[n3][n2];
    }

    protected void encodePixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) throws IOException {
        for (int i2 = 0; i2 < n5; ++i2) {
            System.arraycopy(nArray, i2 * n7 + n6, this.rgbPixels[n3 + i2], n2, n4);
        }
    }

    protected void encodeDone() throws IOException {
        int n2;
        int n3;
        GIFNeuralColorMap gIFNeuralColorMap = new GIFNeuralColorMap();
        int[] nArray = gIFNeuralColorMap.create(this.rgbPixels, 255);
        int n4 = -1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if ((nArray[n3] & 0xFF000000) != 0) continue;
            n4 = n3;
            break;
        }
        n3 = (n2 = nArray.length) <= 2 ? 1 : (n2 <= 4 ? 2 : (n2 <= 16 ? 4 : 8));
        this.GIFEncode(this.width, this.height, this.interlace, (byte)0, n4, n3, nArray);
    }

    byte GetPixel(int n2, int n3) throws IOException {
        return (byte)this.rgbPixels[n3][n2];
    }

    void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
    }

    void GIFEncode(int n2, int n3, boolean bl2, byte by, int n4, int n5, int[] nArray) throws IOException {
        this.Width = n2;
        this.Height = n3;
        this.Interlace = bl2;
        int n6 = 0;
        int n7 = 0;
        this.CountDown = n2 * n3;
        this.Pass = 0;
        int n8 = n5 <= 1 ? 2 : n5;
        this.curx = 0;
        this.cury = 0;
        this.writeString("GIF89a");
        this.Putword(n2);
        this.Putword(n3);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n5 - 1));
        this.Putbyte(by2);
        this.Putbyte(by);
        this.Putbyte((byte)0);
        int n9 = 1 << n5;
        for (int i2 = 0; i2 < n9; ++i2) {
            if (i2 < nArray.length) {
                this.Putbyte((byte)(nArray[i2] >> 16 & 0xFF));
                this.Putbyte((byte)(nArray[i2] >> 8 & 0xFF));
                this.Putbyte((byte)(nArray[i2] & 0xFF));
                continue;
            }
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
        }
        if (n4 != -1) {
            this.Putbyte((byte)33);
            this.Putbyte((byte)-7);
            this.Putbyte((byte)4);
            this.Putbyte((byte)1);
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
            this.Putbyte((byte)n4);
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)44);
        this.Putword(n7);
        this.Putword(n6);
        this.Putword(n2);
        this.Putword(n3);
        if (bl2) {
            this.Putbyte((byte)64);
        } else {
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)n8);
        this.compress(n8 + 1);
        this.Putbyte((byte)0);
        if (this.comment != null && this.comment.length() > 0) {
            this.Putbyte((byte)33);
            this.Putbyte((byte)-2);
            this.Putbyte((byte)this.comment.length());
            this.writeString(this.comment);
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)59);
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putword(int n2) throws IOException {
        this.Putbyte((byte)(n2 & 0xFF));
        this.Putbyte((byte)(n2 >> 8 & 0xFF));
    }

    void Putbyte(byte by) throws IOException {
        this.out.write(by);
    }

    final int MAXCODE(int n2) {
        return (1 << n2) - 1;
    }

    void compress(int n2) throws IOException {
        int n3;
        int n4;
        this.g_init_bits = n2;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n2 - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n5 = this.GIFNextPixel();
        int n6 = 0;
        for (n4 = this.hsize; n4 < 65536; n4 *= 2) {
            ++n6;
        }
        n6 = 8 - n6;
        int n7 = this.hsize;
        this.cl_hash(n7);
        this.output(this.ClearCode);
        block1: while ((n3 = this.GIFNextPixel()) != -1) {
            int n8 = n3 << n6 ^ n5;
            n4 = (n3 << this.maxbits) + n5;
            if (this.htab[n8] == n4) {
                n5 = this.codetab[n8];
                continue;
            }
            if (this.htab[n8] >= 0) {
                int n9 = n7 - n8;
                if (n8 == 0) {
                    n9 = 1;
                }
                do {
                    if ((n8 -= n9) < 0) {
                        n8 += n7;
                    }
                    if (this.htab[n8] != n4) continue;
                    n5 = this.codetab[n8];
                    continue block1;
                } while (this.htab[n8] >= 0);
            }
            this.output(n5);
            n5 = n3;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n8] = n4;
                continue;
            }
            this.cl_block();
        }
        this.output(n5);
        this.output(this.EOFCode);
    }

    void output(int n2) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n2 << this.cur_bits) : n2;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF));
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n2 == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF));
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char();
        }
    }

    void cl_block() throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode);
    }

    void cl_hash(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.htab[i2] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char();
        }
    }

    void flush_char() throws IOException {
        if (this.a_count > 0) {
            this.out.write(this.a_count);
            this.out.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

