/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.StringTokenizer;

public class MiniInputApplet
extends Applet
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public String[] ForbiddenKeysChars = new String[]{"!", "~", "`", "@", "#", "$", "%", "&", "|", "\\", "=", "/", "{", "}"};
    public String[] AcceptedChars = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "(", ")"};
    public int[] ForbiddenKeys = new int[]{16, 17, 18, 20, 27, 120, 154, 155};
    public int position = 1;
    public int marked = -1;
    public int y0;
    public FontMetrics sfm;
    public FontMetrics fm;
    public Font f;
    public Font sf;
    public int fh;
    float R1;
    float G1;
    float B1;
    float alpha;
    public boolean once = false;
    boolean editing = false;
    public int fontsize = 18;
    public String applettext = "";
    public Color bgcolor1;
    public Color pencolor;
    public Color bgcolor2;
    public int max_chars = 200;
    public String[] CharArray = new String[this.max_chars];
    public int[] CharPosition = new int[this.max_chars];
    public int[] CharWidth = new int[this.max_chars];
    public int index = 0;

    public void init() {
        String string = "";
        string = this.getParameter("applettext");
        if (string != null && string.length() != 0) {
            this.applettext = this.filter1(string, "param2uni");
        }
        if ((string = this.getParameter("fontsize")) != null && string.length() != 0) {
            this.fontsize = Integer.parseInt(string);
        }
        this.pencolor = (string = this.getParameter("pencolor")) != null && string.length() != 0 ? this.readColor(string) : new Color(0, 0, 0);
        string = this.getParameter("bgcolor1");
        this.bgcolor1 = string != null && string.length() != 0 ? this.readColor(string) : new Color(255, 255, 255);
        string = this.getParameter("bgcolor2");
        this.bgcolor2 = string != null && string.length() != 0 ? this.readColor(string) : new Color(0, 255, 0);
        this.setBackground(this.bgcolor1);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public Color readColor(String string) {
        string = string.replace(':', ',');
        string = string.replace(';', ',');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.R1 = 1.0f;
        this.G1 = 1.0f;
        this.B1 = 1.0f;
        this.alpha = 0.5f;
        for (int i = 0; i < 4; ++i) {
            String string2 = stringTokenizer.nextToken();
            float f = Float.parseFloat(string2);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 255.0f) {
                f = 1.0f;
            }
            if (i == 0) {
                this.R1 = f / 255.0f;
                continue;
            }
            if (i == 1) {
                this.G1 = f / 255.0f;
                continue;
            }
            if (i == 2) {
                this.B1 = f / 255.0f;
                continue;
            }
            if (i != 3) continue;
            this.alpha = f;
        }
        Color color = new Color(this.R1, this.G1, this.B1, this.alpha);
        return color;
    }

    public boolean keyUp(Event event, int n) {
        return true;
    }

    public String ReadLatex() {
        String string = this.MakeLaTeX();
        string = this.filter1(string, "uni2latex");
        return string;
    }

    public String ReadHtml() {
        String string = this.MakeHtml();
        string = this.filter1(string, "uni2html");
        return string;
    }

    public String ReadAnswer() {
        String string = this.MakeText();
        string = this.filter1(string, "uni2ascii");
        return string;
    }

    public String replace(String string, String string2, String string3) {
        if (string != null && string2.length() != 0) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    public String filter1(String string, String string2) {
        block5: {
            int n;
            String[] stringArray;
            String[] stringArray2;
            block7: {
                String[] stringArray3;
                block6: {
                    String[] stringArray4;
                    block4: {
                        String[] stringArray5 = new String[]{"->", "=>", "-->", "==>", "\\rightarrow", "<->", "<=>", "<-->", "<==>", "\\leftrightarrow", "\\downarrow", "\\uparrow"};
                        stringArray2 = new String[]{"\u2192", "\u2192", "\u2192", "\u2192", "\u2192", "\u21c4", "\u21c4", "\u21c4", "\u21c4", "\u21c4", "\u2193", "\u2191"};
                        stringArray4 = new String[]{" -> ", " -> ", " -> ", " -> ", " -> ", " <-> ", " <-> ", " <-> ", " <-> ", " <-> ", "(s) ", "(g) "};
                        stringArray3 = new String[]{" \\rightarrow ", " \\rightarrow ", " \\rightarrow ", " \\rightarrow ", " \\rightarrow ", " \\leftrightarrow ", " \\leftrightarrow ", " \\leftrightarrow ", " \\leftrightarrow ", " \\leftrightarrow ", " \\downarrow ", " \\uparrow "};
                        stringArray = new String[]{"&nbsp;&minus;&gt;&nbsp;", "&nbsp;&minus;&gt;&nbsp;", "&nbsp;&minus;&gt;&nbsp;", "&nbsp;&minus;&gt;&nbsp;", "&nbsp;&minus;&gt;&nbsp;", "&nbsp;&minus;&gt;&nbsp;", "&nbsp;&gt;&minus;&gt;&nbsp;", "&nbsp;&gt;&minus;&gt;&nbsp;", "&nbsp;&gt;&minus;&gt;&nbsp;", "&nbsp;&gt;&minus;&gt;&nbsp;", "<sub>(s)</sub> ", "<sub>(g)</sub>"};
                        n = stringArray5.length;
                        if (!string2.equals("param2uni")) break block4;
                        for (int i = 0; i < n; ++i) {
                            String string3 = stringArray5[i];
                            String string4 = stringArray2[i];
                            string = this.replace(string, string3, string4);
                        }
                        break block5;
                    }
                    if (!string2.equals("uni2ascii")) break block6;
                    for (int i = 0; i < n; ++i) {
                        String string5 = stringArray2[i];
                        String string6 = stringArray4[i];
                        string = this.replace(string, string5, string6);
                    }
                    break block5;
                }
                if (!string2.equals("uni2latex")) break block7;
                for (int i = 0; i < n; ++i) {
                    String string7 = stringArray2[i];
                    String string8 = stringArray3[i];
                    string = this.replace(string, string7, string8);
                }
                break block5;
            }
            if (!string2.equals("uni2html")) break block5;
            for (int i = 0; i < n; ++i) {
                String string9 = stringArray2[i];
                String string10 = stringArray[i];
                string = this.replace(string, string9, string10);
            }
        }
        return string;
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        this.f = new Font("TimesRoman", 1, this.fontsize);
        this.sf = new Font("TimesRoman", 1, this.fontsize - 6);
        this.fm = graphics.getFontMetrics(this.f);
        this.sfm = graphics.getFontMetrics(this.sf);
        this.fh = this.fm.getHeight();
        if (!this.once) {
            this.AppletText2Array(this.applettext);
            this.once = true;
        }
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        this.y0 = (n4 + this.fh) / 2;
        graphics.clearRect(0, 0, n3, n4);
        int n5 = 0;
        int n6 = this.getSize().width;
        if (this.marked != -1) {
            this.position = this.CharPosition[this.marked];
        }
        if (this.position == 2) {
            n2 = this.y0 - this.fh;
            n = this.fh / 2;
        } else if (this.position == 0) {
            n2 = this.y0;
            n = this.fh / 2;
        } else {
            n2 = this.y0 - this.fh / 2;
            n = this.fh / 2;
        }
        if (this.editing) {
            graphics.setColor(this.bgcolor2);
            graphics.fillRect(n5, n2, n6, n);
        }
        graphics.setColor(this.pencolor);
        int n7 = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.CharArray[i] == null) continue;
            if (i == this.marked) {
                graphics.setColor(Color.red);
                graphics.setFont(this.f);
                graphics.drawString("_", n7, n2 + this.fh);
            } else if (this.CharArray[i].equals("?")) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(this.pencolor);
            }
            if (this.CharPosition[i] == 1) {
                graphics.setFont(this.f);
                graphics.drawString(this.CharArray[i], n7, this.y0);
            } else if (this.CharPosition[i] == 0) {
                graphics.setFont(this.sf);
                graphics.drawString(this.CharArray[i], n7, this.y0 + this.fh / 2);
            } else if (this.CharPosition[i] == 2) {
                graphics.setFont(this.sf);
                graphics.drawString(this.CharArray[i], n7, this.y0 - this.fh / 2);
            }
            n7 += this.CharWidth[i];
            if (i != this.index - 1 || this.marked != -1) continue;
            graphics.setColor(Color.red);
            graphics.drawString("_", n7, n2 + this.fh / 2);
        }
    }

    public void update() {
        if (this.index > this.max_chars - 4) {
            this.index = this.max_chars - 4;
        }
        this.repaint();
    }

    public void clear() {
        this.position = 1;
        this.marked = -1;
        this.once = false;
        this.CharArray = new String[this.max_chars];
        this.CharPosition = new int[this.max_chars];
        this.CharWidth = new int[this.max_chars];
        this.update();
        this.index = 0;
    }

    public void SwitchFont(int n) {
        this.fontsize += n;
        this.update();
    }

    public void AppletText2Array(String string) {
        this.once = true;
        if (string.length() != 0) {
            int n;
            string = this.replace(string, " ", "");
            string = this.replace(string, "{", "");
            string = this.replace(string, "\\rightarrow", "\u21c4");
            string = this.replace(string, "\\leftrightarrow", "\u2192");
            string = this.replace(string, "\\downarrow", "\u2193");
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == '^') {
                    ++n;
                    while (string.charAt(n) != '}' && n < string.length()) {
                        this.CharArray[n] = Character.toString(string.charAt(n));
                        this.CharPosition[n] = 2;
                        this.CharWidth[n] = this.sfm.charWidth(string.charAt(n));
                        ++n;
                    }
                    continue;
                }
                if (string.charAt(n) == '_') {
                    ++n;
                    while (string.charAt(n) != '}' && n < string.length()) {
                        this.CharArray[n] = Character.toString(string.charAt(n));
                        this.CharPosition[n] = 0;
                        this.CharWidth[n] = this.sfm.charWidth(string.charAt(n));
                        ++n;
                    }
                    continue;
                }
                this.CharArray[n] = Character.toString(string.charAt(n));
                this.CharPosition[n] = 1;
                this.CharWidth[n] = this.fm.charWidth(string.charAt(n));
            }
            this.marked = -1;
            this.position = 1;
            this.index = n;
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.marked = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 1;
        if (n2 < this.y0 + this.fh && n2 > this.y0 + this.fh / 4) {
            n3 = 0;
        } else if (n2 > this.y0 - 2 * this.fh && n2 < this.y0 - this.fh / 4) {
            n3 = 2;
        }
        int n4 = 0;
        for (int i = 0; i < this.index; ++i) {
            if (n > n4 && n < n4 + this.CharWidth[i]) {
                this.marked = i;
                this.position = n3 != 1 ? n3 : this.CharPosition[i];
                if (mouseEvent.getButton() == 3) {
                    this.DeleteMarkedChar(this.marked);
                }
                this.repaint();
            }
            n4 += this.CharWidth[i];
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.position = this.NewPosition(-1 * mouseWheelEvent.getWheelRotation(), this.position);
        if (this.marked != -1) {
            this.CharPosition[this.marked] = this.position;
        }
        this.update();
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.editing = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.editing = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.index < this.max_chars - 4) {
            int n = keyEvent.getKeyCode();
            boolean bl = false;
            for (int i = 0; i < this.ForbiddenKeys.length; ++i) {
                if (n != this.ForbiddenKeys[i] || bl) continue;
                bl = true;
            }
            if (!bl) {
                String string = Character.toString(keyEvent.getKeyChar());
                if (this.marked == -1) {
                    this.ProcessKey(string, n);
                } else {
                    this.ProcessMarkedKey(string, n);
                }
                this.repaint();
            }
        } else {
            this.index = 0;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void AppendKey(String string, int n) {
        this.CharPosition[this.index] = n;
        this.CharArray[this.index] = string;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n == 0 || n == 2) {
                n2 += this.sfm.charWidth(string.charAt(i));
                continue;
            }
            n2 += this.fm.charWidth(string.charAt(i));
        }
        this.CharWidth[this.index] = n2;
        ++this.index;
    }

    public void InsertKey(String string, int n, boolean bl) {
        if (this.marked != -1) {
            ++this.index;
            for (int i = this.index; i > this.marked; --i) {
                this.CharArray[i] = this.CharArray[i - 1];
                this.CharPosition[i] = this.CharPosition[i - 1];
                this.CharWidth[i] = this.CharWidth[i - 1];
            }
            this.CharArray[this.marked] = string;
            this.CharPosition[this.marked] = this.position;
            this.CharWidth[this.marked] = this.position == 0 || this.position == 2 ? this.sfm.charWidth(string.charAt(0)) : this.fm.charWidth(string.charAt(0));
            ++this.marked;
        }
        if (bl) {
            this.update();
        }
    }

    public void ProcessMarkedKey(String string, int n) {
        if (n == 116) {
            this.CycleColor(0);
        } else if (n == 117) {
            this.CycleColor(1);
        } else if (n == 118) {
            this.CycleColor(2);
        } else if (n == 119) {
            this.clear();
        } else if (n == 114) {
            string = "\u2192";
            this.InsertKey(string, this.position, false);
        } else if (n == 115) {
            string = "\u21c4";
            this.InsertKey(string, this.position, false);
        } else if (n == 37) {
            this.LeftRightMarked(-1, false);
        } else if (n == 39) {
            if (this.marked == this.index - 1) {
                this.marked = -1;
            } else {
                this.LeftRightMarked(1, false);
            }
        } else if (n == 38 || n == 33) {
            this.UpDownMarked(1, false);
        } else if (n == 40 || n == 34) {
            this.UpDownMarked(-1, false);
        } else if (n == 10 || n == 27) {
            this.marked = -1;
        }
        if ((n == 8 || n == 127) && this.index > 0) {
            this.DeleteMarkedChar(this.marked);
            this.position = 1;
            --this.marked;
        } else if ((n == 8 || n == 127) && this.index == 0) {
            this.position = 1;
            this.marked = -1;
            this.CharArray[0] = null;
            this.CharPosition[0] = 1;
            this.CharWidth[0] = 0;
        } else {
            boolean bl = false;
            for (int i = 0; i < this.AcceptedChars.length; ++i) {
                if (!this.AcceptedChars[i].equals(string) && (n <= 64 || n >= 91) && n != 45 && n != 61) continue;
                bl = true;
            }
            if (bl) {
                this.InsertKey(string, this.position, false);
            }
        }
    }

    public void UpDownMarked(int n, boolean bl) {
        int n2 = this.NewPosition(n, this.position);
        if (n2 != this.position) {
            this.CharPosition[this.marked] = this.position = n2;
        }
        if (bl) {
            this.update();
        }
    }

    public void LeftRightMarked(int n, boolean bl) {
        for (int i = 0; i < this.index; ++i) {
            if (i != this.marked) continue;
            if (n == 1) {
                if (this.marked >= this.index - 1) continue;
                ++this.marked;
                break;
            }
            if (this.marked <= 1) continue;
            --this.marked;
            break;
        }
        if (bl) {
            this.update();
        }
    }

    public void CycleColor(int n) {
        if (this.R1 == this.G1 && this.G1 == this.B1) {
            this.R1 = 0.0f;
            this.G1 = 0.0f;
            this.B1 = 0.0f;
        }
        this.R1 += 0.1f;
        if ((double)this.R1 > 1.0) {
            this.R1 = 1.0f;
            this.G1 += 0.1f;
            if ((double)this.G1 > 1.0) {
                this.G1 = 1.0f;
                this.B1 += 0.1f;
                if ((double)this.B1 > 1.0) {
                    this.B1 = 1.0f;
                }
            }
        }
        if (n == 0) {
            this.pencolor = new Color(this.R1, this.G1, this.B1, 1.0f);
        } else if (n == 1) {
            this.bgcolor1 = new Color(this.R1, this.G1, this.B1, 1.0f);
            this.setBackground(this.bgcolor1);
        } else {
            this.bgcolor2 = new Color(this.R1, this.G1, this.B1, 1.0f);
        }
    }

    public void ProcessKey(String string, int n) {
        boolean bl = true;
        for (int i = 0; i < this.ForbiddenKeysChars.length; ++i) {
            if (!string.equals(this.ForbiddenKeysChars[i]) || !bl) continue;
            bl = false;
        }
        if (bl) {
            if (string.equals(">") && this.index > 2) {
                if (this.CharArray[this.index - 1].equals("-")) {
                    this.DeleteMarkedChar(this.index - 1);
                    string = "\u2192";
                    this.AppendKey(string, this.position);
                }
            } else if (n == 112) {
                this.SwitchFont(6);
            } else if (n == 113) {
                this.SwitchFont(-6);
            } else if (n == 114) {
                string = "\u2192";
                this.AppendKey(string, this.position);
            } else if (n == 115) {
                string = "\u21c4";
                this.AppendKey(string, this.position);
            } else if (n == 116) {
                this.CycleColor(0);
            } else if (n == 117) {
                this.CycleColor(1);
            } else if (n == 118) {
                this.CycleColor(2);
            } else if (n == 119) {
                this.clear();
            } else if (n == 33) {
                this.position = this.NewPosition(1, this.position);
            } else if (n == 34) {
                this.position = this.NewPosition(-1, this.position);
            } else if (n == 36) {
                this.marked = 0;
            } else if (n == 37) {
                this.marked = this.index - 1;
            } else if (n == 39) {
                this.marked = this.index - 1;
            } else if (n == 35) {
                this.marked = this.index;
            } else if (n == 10 || n == 27) {
                this.marked = -1;
                this.position = 1;
                ++this.index;
            } else if ((n == 127 || n == 8) && this.index > 0) {
                --this.index;
                this.CharArray[this.index] = null;
                this.CharPosition[this.index] = 1;
                this.CharWidth[this.index] = 0;
                this.position = this.CharPosition[this.index];
            } else if ((n == 127 || n == 8) && this.index == 0) {
                this.position = 1;
                this.marked = -1;
                this.CharArray[0] = null;
                this.CharPosition[0] = 1;
                this.CharWidth[0] = 0;
            } else if (n == 38 || n == 94) {
                this.position = this.NewPosition(1, this.position);
            } else if (n == 40 || n == 95) {
                this.position = this.NewPosition(-1, this.position);
            } else {
                this.CharArray[this.index] = string;
                this.CharPosition[this.index] = this.position;
                this.CharWidth[this.index] = this.position == 0 || this.position == 2 ? this.sfm.charWidth(string.charAt(0)) : this.fm.charWidth(string.charAt(0));
                ++this.index;
            }
        }
    }

    public int NewPosition(int n, int n2) {
        int n3 = n2 + n;
        if (n3 > 2) {
            n3 = 2;
        } else if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public void DeleteMarkedChar(int n) {
        int n2 = 0;
        for (int i = this.index - 1; i >= 0; --i) {
            if (i != n) continue;
            this.CharArray = this.DeleteStringItem(this.CharArray, i);
            this.CharPosition = this.DeleteIntItem(this.CharPosition, i);
            this.CharWidth = this.DeleteIntItem(this.CharWidth, i);
            this.CharArray[this.index - n2] = null;
            this.CharPosition[this.index - n2] = 1;
            this.CharWidth[this.index - n2] = 0;
            ++n2;
        }
        this.index -= n2;
    }

    public int[] DeleteIntItem(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (i < n) continue;
            n2 = i + 1;
            nArray[i] = nArray[n2];
        }
        return nArray;
    }

    public String[] DeleteStringItem(String[] stringArray, int n) {
        int n2 = 0;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (i < n) continue;
            n2 = i + 1;
            stringArray[i] = stringArray[n2];
        }
        return stringArray;
    }

    public void ShowHelp() {
        System.out.println("laat helptext zien");
    }

    public String MakeText() {
        int n;
        String string = "";
        for (n = 0; n < this.max_chars; ++n) {
            if (this.CharArray[n] == null) continue;
            if (this.CharPosition[n] == 1) {
                string = string + this.CharArray[n];
                continue;
            }
            if (this.CharPosition[n] == 2) {
                string = string + "^";
                while (this.CharPosition[n] == 2 && this.CharArray[n] != null) {
                    string = string + this.CharArray[n];
                    ++n;
                }
                string = string + " ";
                --n;
                continue;
            }
            if (this.CharPosition[n] != 0) continue;
            while (this.CharPosition[n] == 0 && this.CharArray[n] != null) {
                string = string + this.CharArray[n];
                ++n;
            }
            string = string + " ";
            --n;
        }
        for (n = 1; n < 10; ++n) {
            string = this.replace(string, "0" + n, "O" + n);
        }
        return string;
    }

    public String MakeLaTeX() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.max_chars; ++i) {
            if (this.CharArray[i] == null) continue;
            if (this.CharPosition[i] == 1) {
                stringBuffer.append(this.CharArray[i]);
                continue;
            }
            if (this.CharPosition[i] == 2) {
                stringBuffer.append("^{");
                while (this.CharPosition[i] == 2 && this.CharArray[i] != null) {
                    stringBuffer.append(this.CharArray[i]);
                    ++i;
                }
                --i;
                stringBuffer.append("}");
                continue;
            }
            if (this.CharPosition[i] != 0) continue;
            stringBuffer.append("_{");
            while (this.CharPosition[i] == 0 && this.CharArray[i] != null) {
                stringBuffer.append(this.CharArray[i]);
                ++i;
            }
            --i;
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public String MakeHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.max_chars; ++i) {
            if (this.CharArray[i] == null) continue;
            if (this.CharPosition[i] == 1) {
                stringBuffer.append(this.CharArray[i]);
                continue;
            }
            if (this.CharPosition[i] == 2) {
                stringBuffer.append("<sup><font size=\"-1\">");
                while (this.CharPosition[i] == 2 && this.CharArray[i] != null) {
                    stringBuffer.append(this.CharArray[i]);
                    ++i;
                }
                --i;
                stringBuffer.append("</font></sup>");
                continue;
            }
            if (this.CharPosition[i] != 0) continue;
            stringBuffer.append("<sub><font size=\"-1\">");
            while (this.CharPosition[i] == 0 && this.CharArray[i] != null) {
                stringBuffer.append(this.CharArray[i]);
                ++i;
            }
            --i;
            stringBuffer.append("</font></sub>");
        }
        return stringBuffer.toString();
    }
}

