/*
 * NodeAnchor.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"
#include "NodeAnchor.h"
#include "FieldValue.h"
#include "MFNode.h"
#include "MFString.h"
#include "SFString.h"
#include "SFVec3f.h"
#include "SFFloat.h"
#include "Field.h"	    // for FF_URL

ProtoAnchor::ProtoAnchor(Scene *scene)
  : Proto(scene, "Anchor")
{
    addEventIn(MFNODE, "addChildren");
    addEventIn(MFNODE, "removeChildren");
    children.set(
         addExposedField(MFNODE, "children", new MFNode(), CHILD_NODE));
    description.set(
         addExposedField(SFSTRING, "description", new SFString("")));
    parameter.set(
         addExposedField(MFSTRING, "parameter", new MFString()));
    url.set(
        addExposedField(MFSTRING, "url", new MFString(), FF_URL, NULL));
    bboxCenter.set(    
        addField(SFVEC3F, "bboxCenter", new SFVec3f(0.0f, 0.0f, 0.0f)));
    bboxSize.set(
        addField(SFVEC3F, "bboxSize", new SFVec3f(-1.0f, -1.0f, -1.0f), 
                 new SFFloat(-1.0f)));
}

Node *
ProtoAnchor::create(Scene *scene)
{ 
    return new NodeAnchor(scene, this); 
}

NodeAnchor::NodeAnchor(Scene *scene, Proto *proto)
  : Node(scene, proto)
{
}

void
NodeAnchor::preDraw()
{
    NodeList    *childList = children()->getValues();

    for (int i = 0; i < childList->size(); i++)
	childList->get(i)->preDraw();
}

void
NodeAnchor::draw()
{
    int		i;
    NodeList   *childList = children()->getValues();

    for (i = 0; i < childList->size(); i++)
	childList->get(i)->bind();

    glPushName(children_Index());	// field offset
    glPushName(0);
    for (i = 0; i < childList->size(); i++) {
	glLoadName(i);
	childList->get(i)->draw();
    }
    glPopName();
    glPopName();

    for (i = 0; i < childList->size(); i++)
	childList->get(i)->unbind();
}

void
NodeAnchor::flip(int index)
{
    bboxCenter()->flip(index);

    NodeList    *childList = children()->getValues();

    for (int i = 0; i < childList->size(); i++)
	childList->get(i)->flip(index);
}

int         
NodeAnchor::countPolygons(void)
{
    int ret = 0;
    NodeList    *childList = children()->getValues();

    for (int i = 0; i < childList->size(); i++)
        ret += childList->get(i)->countPolygons();

    return ret;
}

int         
NodeAnchor::countPrimitives(void)
{
    int ret = 0;
    NodeList    *childList = children()->getValues();

    for (int i = 0; i < childList->size(); i++)
        ret += childList->get(i)->countPrimitives();

    return ret;
}


