
// tcalc.h
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King

#ifndef THRESHOLDCALCULATOR_H
#define THRESHOLDCALCULATOR_H

#include <qvariant.h>
#include <qdialog.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3GridLayout>
#include <QCloseEvent>
#include <Q3HBoxLayout>
#include <QLabel>
#include <math.h>
#include "statthreshold.h"

class Q3VBoxLayout;
class Q3HBoxLayout;
class Q3GridLayout;
class QLabel;
class QPushButton;
class QLineEdit;

class thresholdCalculator : public QDialog
{
    Q_OBJECT

public:
    thresholdCalculator( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~thresholdCalculator();

    QLabel* lblVoxelNumber;
    QLabel* lblVoxelSizes;
    QLabel* lblFWHM;
    QLabel* lblEffDf;
    QLabel* lbldenomdf;
    QLabel* lblalpha;
    QLabel* lblCriticalTValue;
    QLabel* lblCriticalT_2;
    QLabel* lblCriticalT_3;
    QLabel* lblCriticalT;
    QLabel* lblCriticalT_4;
    QLabel* lblX;
    QLineEdit* txtX;
    QLineEdit* txtZ;
    QLabel* lblZ;
    QLineEdit* txtY;
    QLabel* lblY;
    QLineEdit* txtFWHM;
    QLineEdit* txtEffdf;
    QLineEdit* txtDenomDf;
    QLineEdit* txtAlpha;
    QPushButton* pbUpdate;
    QLineEdit* txtVoxelNumber;
    long gnvar;
    long gnconj;
    double gClusterThreshold;
    double gPValExtent;
    double gdfw1;
    double gdfw2;
protected:

protected slots:
    virtual void languageChange();
    void pressed();

private:
    void closeEvent( QCloseEvent *ce );
};

#endif // THRESHOLDCALCULATOR_H
