/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.net.URL;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.svg.SVGDriver;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SVGImage
extends AbstractFopImage {
    SVGDocument doc;

    public SVGImage(URL uRL) throws FopImageException {
        super(uRL);
    }

    public SVGImage(URL uRL, ImageReader imageReader) throws FopImageException {
        super(uRL, imageReader);
    }

    public static XMLReader createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageHandler.errorln("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            MessageHandler.errorln("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageHandler.errorln("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
        }
        return null;
    }

    public SVGDocument getSVGDocument() throws FopImageException {
        if (this.doc == null) {
            this.loadImage();
        }
        return this.doc;
    }

    protected void loadImage() throws FopImageException {
        try {
            SVGDriver sVGDriver = new SVGDriver();
            sVGDriver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            sVGDriver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            XMLReader xMLReader = SVGImage.createParser();
            sVGDriver.buildSVGTree(xMLReader, new InputSource(this.m_href.toString()));
            this.doc = sVGDriver.getSVGDocument();
        }
        catch (Exception exception) {
            MessageHandler.errorln("ERROR LOADING EXTERNAL SVG: " + exception.getMessage());
        }
    }
}

