/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.messaging.MessageHandler;

public class Leader
extends FObjMixed {
    public Leader(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:leader";
    }

    public int addLeader(BlockArea blockArea, FontState fontState, float f, float f2, float f3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        LineArea lineArea = blockArea.getCurrentLineArea();
        if (lineArea == null) {
            return -1;
        }
        lineArea.changeFont(fontState);
        lineArea.changeColor(f, f2, f3);
        if (n3 <= lineArea.getRemainingWidth()) {
            lineArea.addLeader(n, n2, n3, n4, n6, n5, n7, n8);
        } else {
            lineArea = blockArea.createNextLineArea();
            if (lineArea == null) {
                return -1;
            }
            lineArea.changeFont(fontState);
            lineArea.changeColor(f, f2, f3);
            if (n2 <= lineArea.getContentWidth()) {
                lineArea.addLeader(n, n2, n3, n4, n6, n5, n7, n8);
            } else {
                MessageHandler.errorln("Leader doesn't fit into line, it will be clipped to fit.");
                lineArea.addLeader(n, lineArea.getRemainingWidth(), n3, n4, n6, n5, n7, n8);
            }
        }
        return 1;
    }

    public Status layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            MessageHandler.errorln("WARNING: in this version of Fop fo:leader must be a direct child of fo:block ");
            return new Status(1);
        }
        BlockArea blockArea = (BlockArea)area;
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        int n2 = this.properties.get("font-variant").getEnum();
        FontState fontState = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        int n3 = this.properties.get("leader-pattern").getEnum();
        int n4 = this.properties.get("leader-length.optimum").getLength().mvalue();
        int n5 = this.properties.get("leader-length.minimum").getLength().mvalue();
        int n6 = this.properties.get("leader-length.maximum").getLength().mvalue();
        int n7 = this.properties.get("rule-thickness").getLength().mvalue();
        int n8 = this.properties.get("rule-style").getEnum();
        int n9 = this.properties.get("leader-pattern-width").getLength().mvalue();
        int n10 = this.properties.get("leader-alignment").getEnum();
        String string4 = this.properties.get("id").getString();
        blockArea.getIDReferences().initializeID(string4, blockArea);
        int n11 = this.addLeader(blockArea, fontState, f, f2, f3, n3, n5, n4, n6, n7, n8, n9, n10);
        if (n11 == 1) {
            return new Status(1);
        }
        return new Status(3);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Leader(fObj, propertyList);
        }
    }
}

