/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import java.util.StringTokenizer;
import org.apache.fop.dom.svg.SVGLengthImpl;
import org.apache.fop.dom.svg.SVGListImpl;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public class SVGLengthListImpl
extends SVGListImpl
implements SVGLengthList {
    protected float fontsize = 12.0f;

    public SVGLengthListImpl() {
    }

    public SVGLengthListImpl(String string) {
        this.convert(string);
    }

    public SVGLengthListImpl(String string, int n) {
        this.fontsize = n;
        this.convert(string);
    }

    public SVGLength appendItem(SVGLength sVGLength) throws SVGException {
        this.list.addElement(sVGLength);
        return null;
    }

    protected void convert(String string) {
        int n = string.length();
        if (n != 0) {
            int n2 = string.trim().indexOf(" ");
            if (n2 != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
                while (stringTokenizer.hasMoreTokens()) {
                    float f;
                    String string2 = stringTokenizer.nextToken();
                    float f2 = f = this.getFloatValue(string2, string2.length());
                    SVGLengthImpl sVGLengthImpl = new SVGLengthImpl();
                    sVGLengthImpl.setValue(f2);
                    this.appendItem(sVGLengthImpl);
                }
            } else {
                float f = this.getFloatValue(string, n);
                SVGLengthImpl sVGLengthImpl = new SVGLengthImpl();
                sVGLengthImpl.setValue(f);
                this.appendItem(sVGLengthImpl);
            }
        }
    }

    public SVGLength createItem() {
        return new SVGLengthImpl();
    }

    protected float getFloatValue(String string, int n) {
        float f;
        boolean bl = true;
        try {
            if (string.endsWith("in")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 72.0f;
            } else if (string.endsWith("cm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 28.35f;
            } else if (string.endsWith("mm")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 2.84f;
            } else if (string.endsWith("pt")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
            } else if (string.endsWith("pc")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= 12.0f;
            } else if (string.endsWith("em")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= this.fontsize;
            } else if (string.endsWith("px")) {
                f = Float.valueOf(string.substring(0, n - 2)).floatValue();
                f *= (float)bl;
            } else {
                f = string.endsWith("%") ? Float.valueOf(string.substring(0, n - 1)).floatValue() / 100.0f : Float.valueOf(string).floatValue();
            }
        }
        catch (Exception exception) {
            f = 0.0f;
            MessageHandler.errorln("ERROR: unknown length units in " + string);
        }
        return f;
    }

    public SVGLength getItem(int n) throws DOMException {
        Object e = this.list.elementAt(n);
        return (SVGLength)e;
    }

    public SVGLength initialize(SVGLength sVGLength) throws SVGException {
        return null;
    }

    public SVGLength insertItemBefore(SVGLength sVGLength, int n) throws SVGException {
        return null;
    }

    public SVGLength removeItem(int n) throws DOMException {
        Object e = this.list.elementAt(n);
        this.list.removeElementAt(n);
        return (SVGLength)e;
    }

    public SVGLength replaceItem(SVGLength sVGLength, int n) throws DOMException, SVGException {
        return null;
    }

    public void setValueAsString(String string) {
        this.convert(string);
    }
}

