/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/filedlg.h"
#include <string.h>
DEFINE_SIGNAL_MAP(VDKFileSel,VDKForm)
  ON_SIGNAL(ok_button,clicked_signal,Ok),
  ON_SIGNAL(cancel_button,clicked_signal,Cancel)
END_SIGNAL_MAP
/*
 */
VDKFileSel::VDKFileSel(VDKForm* owner,
		       char* selection,
		       gchar* title):
  VDKForm(owner,title),selection(selection)
{
  // can't destroy to avoid to call destroy handler
  // that try to delete form..
  gtk_widget_unrealize(window);
  widget = sigwid = window = gtk_file_selection_new(title);
  // connect default signals
  SignalsConnect();
  // makes dummies
  ok_button = new VDKObject(this,
			    GTK_FILE_SELECTION(window)->ok_button);
  cancel_button = new VDKObject(this,
			    GTK_FILE_SELECTION(window)->cancel_button);
  items.add(ok_button);
  items.add(cancel_button);
  cancel_button->Parent(this);
  ok_button->Parent(this);
  ok_s_clicked.obj = ok_button;
  ok_s_clicked.signal = clicked_signal;
  gtk_signal_connect(GTK_OBJECT(ok_button->Widget()),"clicked",
		   GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		   (gpointer) &(ok_s_clicked));
  cancel_s_clicked.obj = cancel_button;
  cancel_s_clicked.signal = clicked_signal;
  gtk_signal_connect(GTK_OBJECT(cancel_button->Widget()),"clicked",
		   GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		   (gpointer) &(cancel_s_clicked));
  if(*selection)
    {
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(window),selection);
    *selection = '\0';
    }
}
/*
 */
VDKFileSel::~VDKFileSel()
{
}
/*
 */
bool VDKFileSel::Ok(VDKObject*)
{
strcpy(selection,gtk_file_selection_get_filename(GTK_FILE_SELECTION(window)));
Close();
return true;
}
/*
 */
bool VDKFileSel::Cancel(VDKObject*)
{
*selection = '\0';
Close();
return true;
}





