/*!******************************************************************/
/*  File: ig39.c                                                    */
/*  ============                                                    */
/*                                                                  */
/*  This file includes:                                             */
/*                                                                  */
/*  v3fmov();     Move/Rename file                                  */
/*  v3fcpy();     Copy files                                        */
/*  v3fapp();     Add two files                                     */
/*  v3fdel();     Delete file                                       */
/*  v3facc();     Test file accessability                           */
/*  v3ftst();     Test file existance                               */
/*  v3mkdr();     Create directory                                  */
/*  v3cmpw();     Compare strings with wildcard                     */
/*                                                                  */
/*  This file is part of the VARKON IG Library.                     */
/*  URL:  http://www.varkon.com                                     */
/*                                                                  */
/*  This library is free software; you can redistribute it and/or   */
/*  modify it under the terms of the GNU Library General Public     */
/*  License as published by the Free Software Foundation; either    */
/*  version 2 of the License, or (at your option) any later         */
/*  version.                                                        */
/*                                                                  */
/*  This library is distributed in the hope that it will be         */
/*  useful, but WITHOUT ANY WARRANTY; without even the implied      */
/*  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR         */
/*  PURPOSE.  See the GNU Library General Public License for more   */
/*  details.                                                        */
/*                                                                  */
/*  You should have received a copy of the GNU Library General      */
/*  Public License along with this library; if not, write to the    */
/*  Free Software Foundation, Inc., 675 Mass Ave, Cambridge,        */
/*  MA 02139, USA.                                                  */
/*                                                                  */
/*  (C)Microform AB 1984-2001, Johan Kjellander, johan@microform.se */
/*                                                                  */
/********************************************************************/

#include "../../DB/include/DB.h"
#include "../include/IG.h"

#ifdef UNIX
#include <sys/stat.h>
#include <unistd.h>
#endif

#ifdef WIN32
#include <direct.h>
#include <io.h>
#endif

/*!******************************************************/

        short v3fmov(
        char *from,
        char *to)

/*      ndrar filen "from:s" namn till "to".
 *
 *      In: from => Pekare till gammal vgbeskrivning.
 *          to   => Pekare till ny vgbeskrivning.
 *
 *      Ut: Inget.
 *
 *      FV:      0 => Ok.
 *          IG0482 => Kan ej byta namn p filen %s
 *          IG0512 => Kan ej skapa filen %s
 *          IG0632 => MOVE_FILE, %s r ppen.
 *
 *      (C)microform ab 1996-01-25 J. Kjellander
 *
 ******************************************************!*/

  {
/*
***Kolla att ingen av filerna r ppnade frn MBS.
*/
   if ( v3isop(from) ) return(erpush("IG0632",from));
   if ( v3isop(to) )   return(erpush("IG0632",to));
/*
***I WIN32 fr inte en fil med samma namn finnas sedan tidigare.
*/
#ifdef WIN32
    if ( v3facc(to,'X') ) v3fdel(to);
#endif
/*
***Byt namn.
*/
    if ( rename(from,to) == 0 ) return(0);
    else
      {
      erpush("IG0482",from);
      return(erpush("IG0512",to));
      }
/*
***Slut.
*/
    return(0);
  }

/********************************************************/
/*!******************************************************/

        short v3fcpy(
        char *from,
        char *to)

/*      Kopierar filen "from" till filen "to".
 *
 *      In: from => Pekare till vgbeskrivning fr gamla filen.
 *          to   => Pekare till vgbeskrivning fr nya filen.
 *
 *      Ut: Inget.
 *
 *      FV:      0 => Ok.
 *          IG0073 => Kan ej ppna filen %s
 *          IG0063 => Fel vid skrivning till %s
 *          IG0622 => COPY_FILE, %s r ppen.
 *
 *      (C)microform ab 30/7/85 J. Kjellander
 *
 *      9/1/96  WIN32, J. Kjellander
 *
 ******************************************************!*/

  {
     FILE  *frompk;
     FILE  *topk;
     char   buf[BUFSIZ];
     size_t n;

/*
***Kolla att ingen av filerna r ppnade frn MBS.
*/
   if ( v3isop(from) ) return(erpush("IG0622",from));
   if ( v3isop(to) )   return(erpush("IG0622",to));
/*
***Prova att ppna den gamla filen.
*/
#ifdef WIN32
     if ( (frompk=fopen(from,"rb")) == 0 ) return(erpush("IG0073",from));
#else
     if ( (frompk=fopen(from,"r")) == 0 ) return(erpush("IG0073",from));
#endif
/*
***ppna den nya filen.
*/
#ifdef WIN32
     if ( (topk=fopen(to,"wb")) == 0 ) return(erpush("IG0073",to));
#else
     if ( (topk=fopen(to,"w")) == 0 ) return(erpush("IG0073",to));
#endif
/*
***Kopiera.
*/
loop:
     n = fread(buf,1,BUFSIZ,frompk);

     if ( n != 0 )
       {
       if ( fwrite(buf,1,n,topk) == n ) goto loop;
       else return(erpush("IG0063",from));
       }
/*
***Stng filerna.
*/
     fclose(frompk);
     fclose(topk);

     return(0);
  }

/********************************************************/
/*!******************************************************/

        short v3fapp(
        char *from,
        char *to)

/*      Lgger till filen "from" sist i filen "to".
 *
 *      In: from => Pekare till fil att addera till to.
 *          to   => Pekare till fil som det skall lggas till i.
 *
 *      Ut: Inget.
 *
 *      FV:      0 => Ok.
 *          IG0073 => Kan ej ppna filen %s
 *          IG0063 => Fel vid skrivning till %s
 *          IG0602 => APPEND_FILE, %s r ppen.
 *
 *      (C)microform ab 1996-01-25 J. Kjellander
 *
 ******************************************************!*/

  {
     FILE  *frompk;
     FILE  *topk;
     char   buf[BUFSIZ];
     size_t n;
/*
***Kolla att ingen av filerna r ppnade frn MBS.
*/
   if ( v3isop(from) ) return(erpush("IG0602",from));
   if ( v3isop(to) )   return(erpush("IG0602",to));
/*
***Prova att ppna den fil det skall lsas ur.
*/
#ifdef WIN32
     if ( (frompk=fopen(from,"rb")) == 0 ) return(erpush("IG0073",from));
#else
     if ( (frompk=fopen(from,"r")) == 0 ) return(erpush("IG0073",from));
#endif
/*
***ppna den fil som det skall skrivas (sist) i.
*/
#ifdef WIN32
     if ( (topk=fopen(to,"ab")) == 0 ) return(erpush("IG0073",to));
#else
     if ( (topk=fopen(to,"a")) == 0 ) return(erpush("IG0073",to));
#endif
/*
***Ls och skriv.
*/
loop:
     n = fread(buf,1,BUFSIZ,frompk);

     if ( n != 0 )
       {
       if ( fwrite(buf,1,n,topk) == n ) goto loop;
       else return(erpush("IG0063",from));
       }
/*
***Stng filerna.
*/
     fclose(frompk);
     fclose(topk);

     return(0);
  }

/********************************************************/
/*!******************************************************/

        short v3fdel(char *fil)

/*      Tar bort en fil.
 *
 *      In: fil => Pekare till vgbeskrivning fr filen.
 *
 *      Ut: Inget.
 *
 *      Felkod: IG0492 = Kan ej ta bort filen %s
 *              IG0612 => DELETE_FILE, %s r ppen.
 *
 *      (C)microform ab 29/11/88 J. Kjellander
 *
 ******************************************************!*/

  {
/*
***Kolla att inte filen r ppnad frn MBS.
*/
   if ( v3isop(fil) ) return(erpush("IG0612",fil));
/*
***Ta bort den.
*/
#ifdef UNIX
     if ( unlink(fil) == 0 ) return(0);
     else                    return(erpush("IG0492",fil));
#endif

#ifdef WIN32
     if ( unlink(fil) == 0 ) return(0);
     else                    return(erpush("IG0492",fil));
#endif

  }

/********************************************************/
/*!******************************************************/

        bool v3facc(
        char *fil,
        char  mode)

/*      Kollar om fil kan accessas p visst stt.
 *
 *      In: fil  = Pekare till vgbeskrivning fr filen.
 *          mode = "R", "W" eller "X".
 *
 *      Ut: Inget.
 *
 *      FV: TRUE  = Filen kan accessas p det stt som nskats.
 *          FALSE = Det gr inte.
 *
 *      (C)microform ab 1996-01-26 J. Kjellander
 *
 ******************************************************!*/

  {
   int status,amode;
/*
***Vilken accessmode nskas ?
*/
   switch ( mode )
     {
#ifdef UNIX
     case 'r': case 'R': amode = R_OK; break;
     case 'w': case 'W': amode = W_OK; break;
     case 'x': case 'X': amode = F_OK; break;
#endif
#ifdef WIN32
     case 'r': case 'R': amode = 4; break;
     case 'w': case 'W': amode = 2; break;
     case 'x': case 'X': amode = 0; break;
#endif
     default: return(FALSE);
     }
/*
***Anropa access().
*/
   status = access(fil,amode);
/*
***Hur gick det ?
*/
   if ( status == 0 ) return(TRUE);
   else               return(FALSE);
  }

/********************************************************/
/*!******************************************************/

        bool v3ftst(char *fil)

/*      Kollar om fil gr att ppna fr lsning. OBS,
 *      i Win95 fr denna rutin inte anvndas p en
 *      filkatalog-fil!!!!!
 *
 *      In: fil => Pekare till vgbeskrivning fr filen.
 *
 *      Ut: Inget.
 *
 *      FV: TRUE  = Filen finns.
 *          FALSE = Filen finns ej eller gr ej att ppna.
 *
 *      (C)microform ab 27/11/88 J. Kjellander
 *
 ******************************************************!*/

  {
     FILE  *f;

/*
***Prova att ppna den gamla filen.
*/
     if ( (f=fopen(fil,"r")) == 0 ) return(FALSE);
     else
       {
       fclose(f);
       return(TRUE);
       }
  }

/********************************************************/
/*!******************************************************/

        short v3mkdr(char *dirnam)

/*      Skapar directory.
 *
 *      In: fil => Pekare till vgbeskrivning fr filkatalog.
 *
 *      Ut: Inget.
 *
 *      FV:   0 = Filkatalog skapad.
 *          < 0 = Kan ej skapa filkatalog.
 *
 *      Felkoder: IG0402 = Kan ej skapa filkatalog %s, fel frn OS !
 *
 *      (C)microform ab 22/9/95 J. Kjellander
 *
 *      1998-02-06 IXUSR etc. J.Kjellander
 *
 ******************************************************!*/

  {
#ifdef UNIX
    if ( mkdir(dirnam,S_IXUSR | S_IRUSR | S_IWUSR | S_IROTH |
                                 S_IXOTH | S_IRGRP | S_IXGRP) < 0 )
      {
      return(erpush("IG0402",dirnam));
      }
    else
      {
      return(0);
      }
#endif

#ifdef WIN32
    if ( mkdir(dirnam) < 0 ) return(erpush("IG0402",dirnam));
    else                     return(0);
#endif
  }

/********************************************************/
/*!******************************************************/

        bool  v3cmpw(
        char *wc_str,
        char *tststr)

/*      Jmfr 2 strngar varav en med wildcard "*".
 *      Godtyckligt antal stjrnor fr frekomma i 
 *      skstrngen (wc_str) varsomhelst men inte intill
 *      varandra. Om s returneras FALSE.
 *
 *      Om ngon av strngarna = "" returneras FALSE.
 *
 *      OBS ! Kopia av denna rutin finns i DBtraverse.c
 *      v3cmpw() anvnds fn. inte !
 *
 *      In: wc_str => Strng med 0, 1 eller flera stjrnor.
 *          tststr => Strng utan stjrnor.
 *
 *      Ut:  TRUE  = Strngarna matchar.
 *           FALSE = Matchar ej.
 *
 *      (C)microform ab 1996-02-12 J. Kjellander
 *
 *      1998-04-02 Bug, J.Kjellander
 *
 ******************************************************!*/

  {
   register char *p1,*p2;

/*
***Initiering.
*/
   p1 = wc_str;
   p2 = tststr;
/*
***Innan vi brjar jmfra mste vi kolla om ngon eller
***bda = "" eftersom resten av rutinen frutstter att
***s inte r fallet.
*/
   if ( *p1 == '\0'  ||  *p2 == '\0' ) return(FALSE);
/*
***Ingen av strngarna r "". Stt igng och jmfr!
*/
loop1:
/*
***r det en stjrna.
*/
   if ( *p1 == '*' )
     {
   ++p1;
/*
***Ja, skstrngen slutar med en stjrna.
*/
     if ( *p1 == '\0' ) return(TRUE);
/*
***2 stjrnor efter varandra r inte tilltet.
*/
     else if ( *p1 == '*' ) return(FALSE);
/*
***Stjrnan ej i slutet. Leta upp nsta tecken i p2 som matchar
***tecknet efter stjrnan.
*/
     else
       {
loop2:
/*
***Ett tecken i p2 matchar tecknet efter stjrnan i p1.
***Strippa eventuella ytterligare lika tecken i p2 som inte
***matchar nsta tecken i p1. Tex. p1=*poi och p2=me_ppoi
***1998-04-02 JK.
*/
       if ( *p1 == *p2 )
         {
         while ( *p1 == *(p2+1)  &&  *(p2+1) != *(p1+1) ) ++p2;
         goto loop1;
         }
       else
         {
       ++p2;
         if ( *p2 == '\0' ) return(FALSE);
         goto loop2;
         }
       }
     }
/*
***Ingen stjrna, jmfr 2 riktiga tecken.
*/
   else
     {
/*
***Lika.
*/
     if ( *p1 == *p2 )
       {
     ++p1;
     ++p2;
       if ( *p1 == '\0' )
         {
/*
***p1 och p2 bda slut.
*/
         if ( *p2 == '\0' ) return(TRUE);
/*
***p1 slut men inte p2.
*/
         else return(FALSE);
         }
       else
         {
/*
***p1 inte slut men p2.
*/
         if ( *p2 == '\0' )
           {
           if ( *p1 == '*'  &&  *(p1+1) == '\0' ) return(TRUE);
           else                                   return(FALSE);
           }
/*
***Varken p1 eller p2 slut.
*/
         else goto loop1;
         }
       }
/*
***Ej lika.
*/
     else return(FALSE);
     }
  }

/********************************************************/
