/* valaccodeexpressionstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeexpressionstatement.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeExpressionStatementPrivate {
	ValaCCodeExpression* _expression;
};

#define VALA_CCODE_EXPRESSION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_EXPRESSION_STATEMENT, ValaCCodeExpressionStatementPrivate))
enum  {
	VALA_CCODE_EXPRESSION_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_EXPRESSION_STATEMENT_EXPRESSION
};
static void vala_ccode_expression_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_expression_statement_write_expression (ValaCCodeExpressionStatement* self, ValaCCodeWriter* writer, ValaCCodeExpression* expr);
static gpointer vala_ccode_expression_statement_parent_class = NULL;
static void vala_ccode_expression_statement_dispose (GObject * obj);



ValaCCodeExpressionStatement* vala_ccode_expression_statement_new (ValaCCodeExpression* expr) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeExpressionStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "expression";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, expr);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_EXPRESSION_STATEMENT, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_expression_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeExpressionStatement * self;
	self = VALA_CCODE_EXPRESSION_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (VALA_IS_CCODE_COMMA_EXPRESSION (self->priv->_expression)) {
		ValaCCodeCommaExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		ValaCCodeCommaExpression* ccomma;
		/* expand comma expression into multiple statements
		 to improve code readability*/
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccomma = (_tmp1 = (_tmp0 = self->priv->_expression, (VALA_IS_CCODE_COMMA_EXPRESSION (_tmp0) ? ((ValaCCodeCommaExpression*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		{
			GeeList* expr_collection;
			int expr_it;
			expr_collection = vala_ccode_comma_expression_get_inner (ccomma);
			for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
				ValaCCodeExpression* expr;
				expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
				{
					vala_ccode_expression_statement_write_expression (self, writer, expr);
					(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (g_object_unref (expr_collection), NULL)));
		}
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (self->priv->_expression)) {
			ValaCCodeParenthesizedExpression* _tmp3;
			ValaCCodeExpression* _tmp2;
			ValaCCodeParenthesizedExpression* cpar;
			_tmp3 = NULL;
			_tmp2 = NULL;
			cpar = (_tmp3 = (_tmp2 = self->priv->_expression, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp2) ? ((ValaCCodeParenthesizedExpression*) (_tmp2)) : NULL)), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
			vala_ccode_expression_statement_write_expression (self, writer, vala_ccode_parenthesized_expression_get_inner (cpar));
			(cpar == NULL ? NULL : (cpar = (g_object_unref (cpar), NULL)));
		} else {
			vala_ccode_expression_statement_write_expression (self, writer, self->priv->_expression);
		}
	}
}


static void vala_ccode_expression_statement_write_expression (ValaCCodeExpressionStatement* self, ValaCCodeWriter* writer, ValaCCodeExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	g_return_if_fail (expr == NULL || VALA_IS_CCODE_EXPRESSION (expr));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	if (expr != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


ValaCCodeExpression* vala_ccode_expression_statement_get_expression (ValaCCodeExpressionStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_expression_statement_set_expression (ValaCCodeExpressionStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), _tmp2);
}


static void vala_ccode_expression_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeExpressionStatement * self;
	self = VALA_CCODE_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_EXPRESSION_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_ccode_expression_statement_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_expression_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeExpressionStatement * self;
	self = VALA_CCODE_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_EXPRESSION_STATEMENT_EXPRESSION:
		vala_ccode_expression_statement_set_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_expression_statement_class_init (ValaCCodeExpressionStatementClass * klass) {
	vala_ccode_expression_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeExpressionStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_expression_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_expression_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_expression_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_expression_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_EXPRESSION_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "expression", "expression", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_expression_statement_instance_init (ValaCCodeExpressionStatement * self) {
	self->priv = VALA_CCODE_EXPRESSION_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_expression_statement_dispose (GObject * obj) {
	ValaCCodeExpressionStatement * self;
	self = VALA_CCODE_EXPRESSION_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_expression_statement_parent_class)->dispose (obj);
}


GType vala_ccode_expression_statement_get_type (void) {
	static GType vala_ccode_expression_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_expression_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeExpressionStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_expression_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeExpressionStatement), 0, (GInstanceInitFunc) vala_ccode_expression_statement_instance_init };
		vala_ccode_expression_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeExpressionStatement", &g_define_type_info, 0);
	}
	return vala_ccode_expression_statement_type_id;
}




