/* valaccodecommaexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodecommaexpression.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeCommaExpressionPrivate {
	GeeList* inner;
};

#define VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpressionPrivate))
enum  {
	VALA_CCODE_COMMA_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_comma_expression_parent_class = NULL;
static void vala_ccode_comma_expression_dispose (GObject * obj);



/**
 * Appends the specified expression to the expression list.
 *
 * @param expr a C code expression
 */
void vala_ccode_comma_expression_append_expression (ValaCCodeCommaExpression* self, ValaCCodeExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_COMMA_EXPRESSION (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->inner), expr);
}


GeeList* vala_ccode_comma_expression_get_inner (ValaCCodeCommaExpression* self) {
	g_return_val_if_fail (VALA_IS_CCODE_COMMA_EXPRESSION (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, self->priv->inner));
}


static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeCommaExpression * self;
	gboolean first;
	self = VALA_CCODE_COMMA_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	first = TRUE;
	vala_ccode_writer_write_string (writer, "(");
	{
		GeeList* expr_collection;
		int expr_it;
		expr_collection = self->priv->inner;
		for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
			ValaCCodeExpression* expr;
			expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
}


/**
 * Represents a comma separated expression list in the C code.
 */
ValaCCodeCommaExpression* vala_ccode_comma_expression_new (void) {
	ValaCCodeCommaExpression * self;
	self = g_object_newv (VALA_TYPE_CCODE_COMMA_EXPRESSION, 0, NULL);
	return self;
}


static void vala_ccode_comma_expression_class_init (ValaCCodeCommaExpressionClass * klass) {
	vala_ccode_comma_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCommaExpressionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_comma_expression_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_comma_expression_real_write;
}


static void vala_ccode_comma_expression_instance_init (ValaCCodeCommaExpression * self) {
	self->priv = VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE (self);
	self->priv->inner = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
}


static void vala_ccode_comma_expression_dispose (GObject * obj) {
	ValaCCodeCommaExpression * self;
	self = VALA_CCODE_COMMA_EXPRESSION (obj);
	(self->priv->inner == NULL ? NULL : (self->priv->inner = (g_object_unref (self->priv->inner), NULL)));
	G_OBJECT_CLASS (vala_ccode_comma_expression_parent_class)->dispose (obj);
}


GType vala_ccode_comma_expression_get_type (void) {
	static GType vala_ccode_comma_expression_type_id = 0;
	if (G_UNLIKELY (vala_ccode_comma_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCommaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_comma_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCommaExpression), 0, (GInstanceInitFunc) vala_ccode_comma_expression_instance_init };
		vala_ccode_comma_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeCommaExpression", &g_define_type_info, 0);
	}
	return vala_ccode_comma_expression_type_id;
}




