/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include "common.h"

static void outputlastinfo(INFO *info, const char *opts)
{
    int i = 0;

    while (*opts) {
	if (i)
	    fprintf(stdout, "%c", delimchar);

	switch (*opts++) {
	    case 't':
		fprintf(stdout, "%s", info->lastinfo->tty);
		break;
	    case 'h':
		fprintf(stdout, "%s", info->lastinfo->host);
		break;
	    case 'i':
		fprintf(stdout, "%s", info->lastinfo->time);
		break;
	    case 'a':
		outputlastinfo(info, "thi");
		break;
	    default:
		break;
	}

	i++;
    }

    return;
}

static void outputgecos(INFO *info, const char *opts)
{
    int i = 0;

    while (*opts) {
	if (i)
	    fprintf(stdout, "%c", delimchar);

	switch (*opts++) {
	    case 'n':
		fprintf(stdout, "%s", info->gecos->name);
		break;
	    case 'o':
		fprintf(stdout, "%s", info->gecos->office);
		break;
	    case 'w':
		fprintf(stdout, "%s", info->gecos->officephone);
		break;
	    case 'h':
		fprintf(stdout, "%s", info->gecos->homephone);
		break;
	    case 'a':
		outputgecos(info, "nowh");
		break;
	    default:
		break;
	}

	i++;
    }

    return;
}

void outputinfo(INFO *info, const char *arg)
{
    int i, next, first = 0;
    GROUP *gnode;
    struct stat mystat;

    if (verbose && usefile)
        fprintf(stdout, "%s%c", arg, delimchar);

    for (i = 0; i < MAXOPTIONS; i++) {
	char *tmp;

	if (optspec[i] == 0)
	    break;

	switch (optspec[i]) {
	    case 'D':
	    case 'v':
	    case 'f':
	    case 'j':
	    case 'A':
	    case 'P':
	    case 'L':
	    case 'M':
	    case 0:
		continue;
	}

	next = 0;

	if (first)
	    fprintf(stdout, "%c", delimchar);

	switch (optspec[i]) {
	    case 'C':
		fprintf(stdout, "%s", info->login->ppid);
		break;
	    case 'q':
		fprintf(stdout, "%s", info->login->idle);
		break;
	    case 'o':
		fprintf(stdout, "%s", info->mail->forward);
		break;
	    case 'z':
		fprintf(stdout, "%s", info->mail->foldersize);
		break;
	    case 'r':
		fprintf(stdout, "%s", info->mail->lastread);
		break;
	    case 'w':
		fprintf(stdout, "%s", info->mail->newstamp);
		break;
	    case 'a':
		fprintf(stdout, "%s", info->mail->aliases);
		break;
	    case 's':
		fprintf(stdout, "%s", info->passwd->pw_shell);
		break;
	    case 'l':
		fprintf(stdout, "%s", info->passwd->pw_name);
		break;
#ifdef HAVE_GETSPNAM
	    case 'c':
		if (!amroot) {
		    fprintf(stdout, "%s", UNKNOWN);
		    break;
		}

		if (info->spwd->sp_max == 0 || info->spwd->sp_max == 99999) {
		    fprintf(stdout, "%s", NONE);
		    break;
		}

		tmp = stamp(info->spwd->sp_max * 86400, tf);
		
		fprintf(stdout, "%s", tmp);
		break;
	    case 'k':
		if (!amroot) {
		    fprintf(stdout, "%s", UNKNOWN);
		    break;
		}

		if (info->spwd->sp_expire == 0 || 
			info->spwd->sp_expire == 99999) {
		    fprintf(stdout, "%s", NONE);
		    break;
		}

		tmp = stamp(info->spwd->sp_expire * 86400, tf);

		fprintf(stdout, "%s", tmp);
		break;
#else
	    case 'c':
		if (info->passwd->pw_change == 0) {
		    fprintf(stdout, "%s", NONE);
		    break;
		}

		tmp = stamp(info->passwd->pw_change, tf);

		fprintf(stdout, "%s", tmp);
		break;
	    case 'k':
		if (info->passwd->pw_expire == 0) {
		    fprintf(stdout, "%s", NONE);
		    break;
		}

		tmp = stamp(info->passwd->pw_expire, tf);

		fprintf(stdout, "%s", tmp);
		break;
#endif
	    case 'd':
		fprintf(stdout, "%s", info->passwd->pw_dir);
		break;
	    case 'u':
		fprintf(stdout, "%i", info->passwd->pw_uid);
		break;
	    case 'g':
		gnode = info->group;

		while (gnode->next) {
		    if (next)
			fprintf(stdout, "%c", ',');

		    fprintf(stdout, "%i", gnode->id);

		    if (verbose)
			fprintf(stdout, "(%s)", gnode->name);
		    
		    gnode = gnode->next;
		    next++;
		}
		break;
	    case 'p':
#ifdef HAVE_GETSPNAM
		if (amroot)
		    fprintf(stdout, "%s", info->spwd->sp_pwdp);
		else
		    fprintf(stdout, "%s", info->passwd->pw_passwd);
#else
		fprintf(stdout, "%s", info->passwd->pw_passwd);
#endif
		break;
	    case 'm':
                if (lstat(info->passwd->pw_dir, &mystat) == -1) {
		    fprintf(stdout, "%s", UNKNOWN);
		    break;
	        }
                else
	            info->homedirmode = mystat.st_mode;

	        fprintf(stdout, "%.4o", info->homedirmode & ALLPERMS);
		break;
	    case 'i':
		outputgecos(info, gecosopts);
		break;
	    case 'n':
		outputlastinfo(info, lastopts);
		break;
	    case 'e':
		if (info->login->online)
		    fprintf(stdout, "%s", 
			    ((info->login->mesgstat) ? ON : OFF));
		else
		    fprintf(stdout, "%s", UNKNOWN);
		break;
	    case 'y':
		fprintf(stdout, "%s", info->login->tty);
		break;
	    case 't':
		fprintf(stdout, "%s", info->login->stamp);
		break;
	    case 'b':
		fprintf(stdout, "%s", info->login->duration);
		break;
	    case 'x':
		fprintf(stdout, "%s", info->login->host);
		break;
	    default:
		break;
	}

	first++;
    }

    fprintf(stdout, "%c", '\n');
    return;
}
