//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2002
// 
// EHM5.cc -- 
// 
// Author           : Roy Krischer
// Created On       : Sun Nov 24 12:34:43 2002
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Apr 21 16:55:21 2003
// Update Count     : 7
// 

#include <uC++.h>
#include <uIOStream.h>


uThrowEvent fred {
  public:
    int k;
    fred ( int k ) : k(k) {}
};
uInitEvent( fred );

class mary {
  public:
    void foo() {
		uThrow fred( 42 );
    }
};

class john {
  public:
    void bar() {
		uThrow fred( 84 );
    }
};

class bob : public mary, public john { };

void foo() {
    uThrow fred( 666 );
}

void uMain::main() {
    mary m;
    john j;
    bob b;
    
//********* m ***********

    try {
		m.foo();
    } catch ( m.fred f ) {
		uCerr << "thrower: m " << f.k << endl;
    } catch ( j.fred f ) {
		uCerr << "thrower: j " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been m" );
    } catch ( fred f ) {
		uCerr << "unbound " << f.k << endl;
		uAbort( "Error: binding did not match, execution should have never reached here" );
    }

//********* j ***********

    try {
		j.bar();
    } catch ( m.fred f ) {
		uCerr << "thrower: m " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been j" );
    } catch ( j.fred f ) {
		uCerr << "thrower: j " << f.k << endl;
    } catch ( fred f ) {
		uCerr << "unbound " << f.k << endl;
		uAbort( "Error: binding did not match, execution should have never reached here" );
    }
    
//********* unbound ***********    

    try {
		foo();
    } catch ( m.fred f ) {
		uCerr << "thrower: m " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been unbound" );
    } catch ( j.fred f ) {
		uCerr << "thrower: j " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been unbound" );
    } catch ( fred f ) {
		uCerr << "unbound " << f.k << endl;
    }

// ******** multiple ***********

	try {
		b.bar();
    } catch ( j.fred f ) {
		uCerr << "thrower: j  " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been b" );
    } catch ( m.fred f ) {
		uCerr << "thrower: m  " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been b" );
    } catch ( b.fred f ) {
		uCerr << "thrower b " << f.k << endl;
    }

#if (__U_CPLUSPLUS__ == 4) && (__U_CPLUSPLUS_MINOR__ == 9)
// ******** multiple, don't let bind to mb!! ***********

	mary &mb = b;
	try {
		b.bar();
    } catch ( mb.fred f ) {
		uCerr << "thrower: mb  " << f.k << endl;
		uAbort( "Error: wrong binding matched, mb should have an address too high to match" );
    } catch ( m.fred f ) {
		uCerr << "thrower: m  " << f.k << endl;
		uAbort( "Error: wrong binding matched, should have been b" );
    } catch ( b.fred f ) {
		uCerr << "thrower b " << f.k << endl;
    }
#endif
}

// Local Variables: //
// tab-width: 4 //
// End: //
