C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECSI3
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFS,NREFE,NREFAC,COORDS)
C      -----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS                       *
C                  STRUCTURE DE DONNEE ISSUE DE SIMAIL                 *
C                                                                      *
C             Modifications par Y. Fournier pour prendre en compte     *
C             les aspects binaires Linux                               *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NODES    ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SOLIDE      !
C !  NREFS    ! TE ! R  ! REFERENCES DES NOEUDS DU MAILLAGE SOLIDE     !
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES                         !
C !  COORDS   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /GENECT/  !    ! D  !                                              !
C ! /PORTAG/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NREFAC(NELEMS,NBFACE)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
C
      INTEGER I,J
      INTEGER L,LE,NT0,NT2,NT3,NT4,NT5,M(32)
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10
      INTEGER NDSR,NP,NCGE,NMAE,NDSDE,NPO,NNO,INING,NE,NN
      INTEGER NFAC(3), NARE(3), NSOM
      INTEGER NNMAE(0:20)
      INTEGER IMIL(6)
C
      INTEGER NFSISY(4)
C
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C
C***********************************************************************
C
      DATA NFSISY /1,3,2,4/
C
C
C     1- INITIALISATION DES TABLEAUX D'INDICATEURS
C     ============================================
C
      DO 2 I=1,NPOINS
        NREFS(I) = 0
    2 CONTINUE
C
      INING = 1
C
      IF (NDIELE.EQ.2) THEN
          NFAC(1) = 0
          NFAC(2) = 0
          NFAC(3) = 0
      ELSE
          NFAC(1) = 4
          NFAC(2) = 0
          NFAC(3) = 0
      ENDIF
C
      IF (NDIELE.EQ.2) THEN
          NARE(1) = 3
          NARE(2) = 3
          NARE(3) = 0
      ELSE
          NARE(1) = 6
          NARE(2) = 6
          NARE(3) = 0
      ENDIF
C
      IF (NDIELE.EQ.2) THEN
          NSOM = 3
      ELSE
          NSOM = 4
      ENDIF
C
      DO 5 I=0,20
         NNMAE(I) = 1
    5 CONTINUE
      NNMAE(0) = 0
C
      IF (NDIELE.EQ.2) THEN
         IMIL(1) = 4
         IMIL(2) = 5
         IMIL(3) = 6
      ELSE
         IMIL(1) = 5
         IMIL(2) = 6
         IMIL(3) = 7
         IMIL(4) = 8
         IMIL(5) = 9
         IMIL(6) = 10
      ENDIF
C
C   
C
C     2- LECTURE DU MAILLAGE
C     ======================
C
#ifdef HAVE_C_IO
      CALL REWDBF (NFSGCT, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      REWIND NFSGCT
#endif
C
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL REWDBF (NFSGCT, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      READ(NFSGCT) LE
      REWIND (NFSGCT)
#endif
C
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, L, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGCT) L, (M(I), I=1,LE) 
#endif
      NT0 = M(2)
      NT2 = M(4)
      NT3 = M(5)
      NT4 = M(6)
      NT5 = M(7)
C
C
C     Lecture du tableau 0
C     --------------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, NT0, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGCT) LE, (M(I), I=1,NT0)
#endif
C
C     Lecture du tableau 2
C     --------------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, NT2, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGCT) LE,(M(I),I=1,NT2)
#endif
C
      NDSR = M(2)
      NP = M(22)
      NN = M(15)
C
      IF (NDIELE.EQ.2) THEN
        NE = M(8)
      ELSE
        NE = M(10)
      ENDIF
C
#ifdef HAVE_C_IO
      IF (NT3.NE.0) THEN
         NBRLUS = 0
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         IF (NBRLUS .LT. NBRTOT) THEN
            CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDIF
      ENDIF
#else
      IF (NT3.NE.0) READ(NFSGCT) LE
#endif
C
C     lecture du tableau 4
C     --------------------
C
#ifdef CRAY
      READ(NFSGCT) LE,( (COORDS(I,J),J=1,NDIM) , I=1,NP)
#else
      CALL LCOODP(COORDS,COORDS,NP,NDIM,NPOINS,NFSGCT)
#endif
C
C     lecture du tableau 5
C     --------------------
C    
#ifdef HAVE_C_IO
C
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
C
       DO I = 1, NE
C
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NCGE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NMAE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
C
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NREFE(I),
     &                IERROR)
         IF (IERROR .NE. 0) GOTO 998
C
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NNO, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         DO J = 1, NDMATS
            CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NODES(I,J),
     &                   IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDDO
         CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, NPO, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         CALL READBF (NFSGCT, 4, NPO, 1, NBRLUS, NBRTOT, M, IERROR)
         IF (IERROR .NE. 0) GOTO 998
C
         IF (NMAE.NE.0) THEN
            CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, INING,
     &                   IERROR)
            IF (IERROR .NE. 0) GOTO 998
            IF (INING.EQ.1) THEN
               IF ((.NOT. LCFACE)) THEN
                  CALL READBF (NFSGCT, 4, NFAC(INING), 1,
     &                         NBRLUS, NBRTOT, M, IERROR)
                  IF (IERROR .NE. 0) GOTO 998
               ELSE
                  DO J = 1, NFAC(INING)
                     CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT,
     &                            NREFAC(I,NFSISY(J)), IERROR)
                     IF (IERROR .NE. 0) GOTO 998
                  ENDDO
               ENDIF
            ENDIF
            IF (INING.LE.2) THEN
               IF (LCFACE .AND. NDIELE.EQ.2) THEN
                  DO J = 1, NARE(INING)
                     CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT,
     &                    NREFAC(I,J), IERROR)
                     IF (IERROR .NE. 0) GOTO 998
                  ENDDO
               ELSE
                  DO J = 1, NARE(INING)
                     CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT,
     &                    NREFS(NODES(I,IMIL(J))), IERROR)
                     IF (IERROR .NE. 0) GOTO 998
                  ENDDO
               ENDIF
            ENDIF
C
            DO J = 1, NSOM
               CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT,
     &              NREFS(NODES(I,J)), IERROR)
               IF (IERROR .NE. 0) GOTO 998
            ENDDO
         ENDIF
C
      ENDDO
C
C
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
C
      IF (NDIELE.EQ.2 .AND. NCTHFS.EQ.3 .AND. LCFACE) THEN
         DO  J=1,3
            DO  I=1,NELEMS
               NREFS(NODES(I,IMIL(J))) = NREFAC(I,J)
            ENDDO
         ENDDO
      ENDIF
C
#else
      INING=1
      IF (.NOT. LCFACE) THEN
C
         READ(NFSGCT) LE, 
     &      ( NCGE,NMAE,NREFE(I),
     &        NNO, (NODES(I,J), J=1,NDMATS),
     &        NPO, (M(J),       J=1,NPO   ) ,
     &       (INING,      J=1,NNMAE(NMAE) ),
     &       (M(J),       J=1,NFAC(INING)*NNMAE(NMAE) ), 
     &       (NREFS(NODES(I,IMIL(J))), J=1,NARE(INING)*NNMAE(NMAE) ),
     &       (NREFS(NODES(I,J))      , J=1,NSOM*NNMAE(NMAE) )
     &        , I=1,NE )
C
      ELSE
C
c       IF (NDIELE.EQ.2 .AND. NCTHFS.EQ.2) THEN
c        READ(NFSGCT) LE, 
c     & (  NCGE,NMAE,
c     &    NREFAC(I,1),
c     &    NNO, (NODES(I,J), J=1,NDMATS),
c     &    NPO, (M(J),       J=1,NPO   ) ,
c     &         (INING,      J=1,NNMAE(NMAE) ),
c     &         (M(J),       J=1,NFAC(INING)*NNMAE(NMAE) ), 
c     &         (NREFS(NODES(I,IMIL(J))), J=1,NARE(INING)*NNMAE(NMAE) ),
c     &         (NREFS(NODES(I,J))      , J=1,NSOM*NNMAE(NMAE) )
c     &    , I=1,NE )   
C         
c       ELSEIF (NDIELE.EQ.2 .AND. NCTHFS.NE.2) THEN
c           READ(NFSGCT) LE, 
c     &   (  NCGE,NMAE,NREFE(I),
c     &      NNO, (NODES(I,J), J=1,NDMATS),
c     &      NPO, (M(J),       J=1,NPO   ) ,
c     &           (INING,      J=1,NNMAE(NMAE) ),
c     &           (M(J),       J=1,NFAC(INING)*NNMAE(NMAE) ), 
c     &           (NREFAC(I,J),J=1,NARE(INING)*NNMAE(NMAE) ),
c     &           (NREFS(NODES(I,J))      , J=1,NSOM*NNMAE(NMAE) )
c     &      , I=1,NE )  
cC

c       ELSE
           READ(NFSGCT) LE, 
     &   ( NCGE,NMAE,NREFE(I),
     &     NNO, (NODES(I,J), J=1,NDMATS),
     &     NPO, (M(J),       J=1,NPO   ) ,
     &          (INING,      J=1,NNMAE(NMAE) ),
     &          (NREFAC(I,NFSISY(J)),J=1,NFAC(INING)*NNMAE(NMAE) ), 
     &          (NREFS(NODES(I,IMIL(J))), J=1,NARE(INING)*NNMAE(NMAE) ),
     &          (NREFS(NODES(I,J))      , J=1,NSOM*NNMAE(NMAE) )
     &     , I=1,NE )   
c        ENDIF
C
        IF (NDIELE.EQ.2 .AND. NCTHFS.EQ.3 .AND. LCFACE) THEN
          DO 20 J=1,3
            DO 21 I=1,NELEMS
              NREFS(NODES(I,IMIL(J))) = NREFAC(I,J)
   21       CONTINUE
   20     CONTINUE
        ENDIF
C
      ENDIF
C
#endif
C  
C     3- GENERATION DES COORDONNEES DES NOEUDS MILIEUX
C     ================================================
C
      IF (NDIELE.EQ.2) THEN
         DO 31 I=1,NE
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)
            DO 30 J=1,NDIM
              COORDS(N4,J) = (COORDS(N1,J) + COORDS(N2,J)) * 0.5D0
              COORDS(N5,J) = (COORDS(N2,J) + COORDS(N3,J)) * 0.5D0
              COORDS(N6,J) = (COORDS(N3,J) + COORDS(N1,J)) * 0.5D0
   30       CONTINUE
   31    CONTINUE
C
      ELSEIF (NDIELE.EQ.3) THEN
         DO 36 I=1,NE
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)            
            N7 = NODES(I,7)            
            N8 = NODES(I,8)            
            N9 = NODES(I,9)
            N10= NODES(I,10)
            DO 35 J=1,NDIM
              COORDS(N5,J) = (COORDS(N1,J) + COORDS(N2,J)) * 0.5D0
              COORDS(N6,J) = (COORDS(N2,J) + COORDS(N3,J)) * 0.5D0
              COORDS(N7,J) = (COORDS(N3,J) + COORDS(N1,J)) * 0.5D0
              COORDS(N8,J) = (COORDS(N1,J) + COORDS(N4,J)) * 0.5D0
              COORDS(N9,J) = (COORDS(N2,J) + COORDS(N4,J)) * 0.5D0
              COORDS(N10,J)= (COORDS(N3,J) + COORDS(N4,J)) * 0.5D0
   35       CONTINUE
   36     CONTINUE
C
      ENDIF            
C
C     4- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,4000)
        WRITE(NFECRA,4010) NDIM, NP, NN, NE, NDSR 
      ENDIF
C
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.GE.2) THEN
C
      WRITE(NFECRA,5000) 
      WRITE(NFECRA,5010)
ccc      DO 100 I=1,NN
      DO 100 I=1,10
        WRITE(NFECRA,5011) I,(COORDS(I,J),J=1,NDIM)

  100 CONTINUE
C
      WRITE(NFECRA,5020)
ccc      DO 110 I=1,NE
      DO 110 I=1,10
        WRITE(NFECRA,5012) I,(NODES(I,J),J=1,NDMATS)
 110  CONTINUE
C
      WRITE(NFECRA,5030)
ccc      DO 120 I=1,NN
      DO 120 I=1,10
         WRITE(NFECRA,5013) I,NREFS(I)
 120  CONTINUE   
C
      IF (NDPROP.GT.1) THEN
        WRITE(NFECRA,5031)
        DO 121 I=1,10
           WRITE(NFECRA,5013) I,NREFE(I)
 121    CONTINUE   
      ENDIF
 
      ENDIF  
C
      RETURN
C
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
#endif /* HAVE_C_IO */
C
C--------
C FORMATS
C--------
C
 4000 FORMAT(//,' *** LECSI3 : MAILLAGE ELEMENTS FINIS DU SOLIDE :')
 4010 FORMAT(8X,'- Dimension du maillage            : ',I10,/
     &       8X,'- Nombre de noeuds sommets         : ',I10,/
     &       8X,'- Nombre total de noeuds           : ',I10,/
     &       8X,'- Nombre d''elements                : ',I10,/
     &       8X,'- Maximum des numeros de reference : ',I10,/)
C
 5000 FORMAT(/,' *** LECSI3 : Verification du maillage solide',/)
 5010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 5020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 5030 FORMAT(/,14X,'References des 10 premiers noeuds :',/)
 5031 FORMAT(/,14X,'References des 10 premiers elements :',/)
 5011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5)
 5012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I10)
 5013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
#ifdef HAVE_C_IO
 9998 FORMAT(' %% ERREUR LECSI3 : erreur de lecture du maillage ',
     *       ' solide',/,'    de type : ',A)
#endif
C
      END
