/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>
# include "f2c_syrthes.h"

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | lecmai                                                               |
  |        Lecture des maillages                                         |
  |======================================================================| */

proc(void lmails,void LMAILS)(int *type,int *lcface,
		    int *ndim,int *ndiele,int *npoins,int *nelems,
		    int *neless,int *neleus,int *nelepr,int *nelerc,
		    int *nelera,int *nbface,int *nbcous,int *nbflus,
		    int *nbdirs,int *nbechs,int *nbflvs,int *nbress,
		    int *nbrays,int *nbrais,int *nbprio,int *nbmobs,
		    int *nrajou,int *nbfflu,int *nbfech,int *nbfrai,
		    int *nfbida)
{
  int i,nt5;
  int nbfac,nbaret,nbsom,nn;
  int *iref,*inoeud,*iface,*ielt,*it5,*itab,*itab1,*itab2,*itrmed;

  if (*ndiele==2) {nbfac=0;nbaret=3;nbsom=3;nn=6;}
  else            {nbfac=4;nbaret=6;nbsom=4;nn=10;}

      
  if (*type==1)        proc(lecsi1,LECSI1)(npoins,nelems,&nt5);
  else if  (*type==2)  proc(lecid1,LECID1)(npoins,nelems,nfbida,ndiele);
  else if  (*type==3)  proc(lecsy1,LECSY1)(npoins,nelems);
#ifdef MED
  else if  (*type==4)  proc(lecme1,LECME1)(npoins,nelems,&nn);
#endif

  iref=(int*)malloc(*npoins*sizeof(int));
  inoeud=(int*)malloc(*nelems*nn*sizeof(int));
  iface=(int*)malloc(*nelems* *nbface*sizeof(int));
  ielt=(int*)malloc(*nelems*sizeof(int));
  if (!iref||!inoeud||!iface||!ielt) 
    {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  for(i=0;i<*npoins;i++) *(iref+i)=0;
  for(i=0;i<*nelems*nn;i++) *(inoeud+i)=0;
  for(i=0;i<*nelems* *nbface;i++) *(iface+i)=0;
  for(i=0;i<*nelems;i++) *(ielt+i)=0;

  if (*type==1)
    {
      it5=(int*)malloc(nt5*sizeof(int));
      if (!it5) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
      proc(lecsi2,LECSI2)(ndim,ndiele,npoins,nelems,nbface,&nn,
			  iref,inoeud,iface,ielt,&nt5,it5);
      free(it5);
    }
  else if  (*type==2)
      proc(lecid2,LECID2)(ndim,ndiele,npoins,nelems,nfbida,nbface,&nn,
			  iref,inoeud,iface,ielt);
  else if  (*type==3)
      proc(lecsy2,LECSY2)(ndim,ndiele,npoins,nelems,nbface,&nn,
			  iref,inoeud,iface,ielt);
#ifdef MED
  else if  (*type==4)
    {
      itrmed=(int*)malloc(*nelems*nn*sizeof(int));
      proc(lecme2,LECME2)(ndim,npoins,nelems,nbface,&nn,
			  iref,inoeud,iface,ielt,itrmed);
      free(itrmed);
    }
#endif

  if (!*lcface)
    {
      itab=(int*)malloc(*npoins*sizeof(int));
      if (!itab) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
      proc(cmptno,CMPTNO)(iref,npoins,nbcous,nbflus,nbdirs,nbechs,
			  nbress,nbrays,nbrais,nbprio,nbmobs);
      proc(cmptel,CMPTEL)(inoeud,iref,itab,
			  npoins,ndiele,&nn,nbface,
			  nelems,neless,neleus,nelepr,nelerc,nelera,
			  nbflus,nrajou);
      nbfflu = 0;nbfech = 0; nbfrai = 0;
      free(itab);
    }
  else
    {
      itab1=(int*)malloc(*npoins*sizeof(int));
      itab2=(int*)malloc(*npoins*sizeof(int));
      if (!itab1||!itab2) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
      proc(cmptfa,CMPTFA)(ndiele,iface,inoeud,&nn,nelems,nbface,
			  neless,neleus,
			  nbfflu,nbfech,nelerc,nelepr,nelera,nbfrai,
			  iref,npoins,nbcous,nbdirs,nbress,nbprio,nbmobs,
			  nbflus,nbechs,nbrays,nbrais,itab1,itab2);
      free(itab1);free(itab2);
    }
  
  proc(cmptfv,CMPTFV)(iref,ielt,npoins,nelems,nbflvs);

  free(iref); free(inoeud); free(iface); free(ielt);
}  


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | lecmai                                                               |
  |        Lecture des maillages                                         |
  |======================================================================| */

proc(void lmailr,void LMAILR)(int *type,
		    int *ndim,int *npoinr,int *nelray,int *nnsray,
		    int *nnfray,int *nneray,int *nfcfra,int *nfcsra,
		    int *nftira,int *nffira,int *nfpera,
		    int *nfmst,int *nfmste)
{
  int i;
  int *iref,*inoeud,*itab1,*itab2;

      
  if (*type==1)        proc(lrasi1,LRASI1)(ndim,npoinr,nelray);
  else if  (*type==2)  proc(lraid1,LRAID1)(ndim,npoinr,nelray);
  else if  (*type==3)  proc(lrasy1,LRASY1)(ndim,npoinr,nelray);
#ifdef MED
  else if  (*type==4)  proc(lrame1,LRAME1)(ndim,npoinr,nelray);
#endif

  iref=(int*)malloc(*nelray*sizeof(int));
  inoeud=(int*)malloc(*nelray* *ndim*sizeof(int));
  if (!iref||!inoeud) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  for(i=0;i<*nelray;i++) *(iref+i)=0;
  for(i=0;i<*nelray* *ndim;i++) *(inoeud+i)=0;

  if (*type==1)
      proc(lrasi2,LRASI2)(ndim,npoinr,nelray,iref,inoeud);
  else if  (*type==2)
      proc(lraid2,LRAID2)(ndim,npoinr,nelray,iref,inoeud);
  else if  (*type==3)
      proc(lrasy2,LRASY2)(ndim,npoinr,nelray,iref,inoeud);
#ifdef MED
  else if  (*type==4)
      proc(lrame2,LRAME2)(ndim,npoinr,nelray,iref,inoeud);
#endif

  itab1=(int*)malloc(*npoinr*sizeof(int));
  itab2=(int*)malloc(*npoinr*sizeof(int));
  if (!itab1||!itab2) {printf("\n ERREUR D'ALLOCATION MEMOIRE\n");exit(0);}
  proc(lnray1,LNRAY1) (ndim,nelray,inoeud,iref,npoinr,
		       itab1,itab2,nnsray,nnfray,nneray);
  free(itab1); free(itab2);

  proc(lfray1,LFRAY1) (nelray,iref,
		       nfcfra,nfcsra,nftira,nffira,nfpera,
		       nfmst,nfmste);

  free(iref); free(inoeud);
}
