/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include "aplist.h"

APList::APList()
{
	qDebug("Creating aplist...");
	setAutoDelete(TRUE);	// Delete pointers when removing or clearing
}

APList::~ APList()
{
	qDebug("Deleting aplist...");
}

// APEntry * APList::findByMAC(char * mac) 
// {
// 	char temp[18];
// 	
// 	for (uint i=0; i < count(); i++)
// 		if (strcmp( at(i)->getMAC(temp), mac )==0)
// 			return at(i);
// 	return 0;
// }

bool APList::isInList(APEntry *ap)
{
	return (find(ap) != -1);

// 	char temp[18];
// 	return (findByMAC(ap->getMAC(temp)) > 0);
}

bool APList::isInList(char * mac)
{
	APEntry temp;
	temp.setMAC(mac);
	return (find(&temp) != -1);
// 	return (findByMAC(mac) > 0);
}

void APList::Display()
{
	char temp [255];
	cout << "AP's encontrados: " << endl;
	for (uint i=0; i<count(); i++)
	{
		cout << "\t** ESSID: " << at(i)->getEssid(temp) << endl;
		cout << "\t     MAC: " << at(i)->getMAC(temp) << endl;
		cout << "\t  VENDOR: " << at(i)->getVendor(temp) << endl;
		cout << "\t CHANNEL: " << at(i)->getChannel() << endl;
		cout << "\t    MODE: " << at(i)->getModeString() << endl;
		cout << "\t  SIGNAL: " << at(i)->getSignal() << endl;
		cout << "\t SIGNALM: " << at(i)->getSignalMax() << endl;
		cout << "\t   NOISE: " << at(i)->getNoise() << endl;
		cout << "\t    SNRM: " << at(i)->getSNRMax() << endl;
	}
}

void APList::addOrUpdateIfExists(APEntry * ap)
{
	// Find by mac's using compareItems()
	// Should be the only one, although it finds the first:
	int currentIndex = find(ap); 
	APEntry * current = at(currentIndex);

	// current = 0 if not found
	if ( current != 0 )
	{ // If it's already in the list
		if (ap->getSignal() > current->getSignal())
		{ // Update if signal increases
			replace(currentIndex, ap);
		}
	}
	else
	{ // Add
		append(ap);
	}
}

// This virtual function makes the find() funcion to compare by MAC address
int APList::compareItems( QPtrCollection::Item item1, QPtrCollection::Item item2 )
{
// 	qDebug("APList::compareItems()");
	char temp1[18];
	char temp2[18];
	APEntry* ap1 = static_cast<APEntry *>(item1);
	APEntry* ap2 = static_cast<APEntry *>(item2);

	return strcmp( ap1->getMAC(temp1), ap2->getMAC(temp2) );
}
