/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Foobar is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Foobar is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _WINDOW1_HH
#include "window1_glade.hh"
#define _WINDOW1_HH


#include <string>
#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <gtkmm/main.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/stock.h>
#include <gtkmm/treemodel.h>
#include "macros.inc"


class TModelListView : public Gtk::TreeModel::ColumnRecord
{
public:
	/*
	TModelListView() { 
		for (int i = 0; i < 3; i++) add(swac[i]); 
		add(idx); 
		add(filename); 
		add(path); 
	};
	Gtk::TreeModelColumn<Glib::ustring> idx;
	Gtk::TreeModelColumn<Glib::ustring> filename;
	Gtk::TreeModelColumn<Glib::ustring> path;
	Gtk::TreeModelColumn<Glib::ustring> swac[3];
	*/
	SOUNDS_LIST_VARS;

};


class TModelListBox : public Gtk::TreeModel::ColumnRecord
{
public:
	TModelListBox() { 
		add(caption); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
};



class TModelListExt : public Gtk::TreeModel::ColumnRecord
{
public:
	TModelListExt() { 
		add(caption); 
		add(value); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
};


class TModelListSoundInfo : public Gtk::TreeModel::ColumnRecord
{
public:
	TModelListSoundInfo() { 
		add(caption); 
		add(value); 
		add(weight); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
	Gtk::TreeModelColumn<int> weight;
};


class TWindow1 : public window1_glade
{  
private:      
	void on_refresh_clicked(); 
	void on_about1_activate();
	void on_quitter1_activate();
	void on_treeview2_cursor_changed();
	void on_play_clicked();
	void on_combobox1_changed();
	void on_search_clicked();
	void on_combobox2_changed();
	void on_about();
	void on_treeview1_cursor_changed();

	void show_sound_info(std::string idx);
	void show_lang();
	void show_sounds(std::string filter);
	void show_index();
	void show_index_else(std::string filter, std::string field);
	void show_index_alphaidx(std::string filter);
	void select_index(std::string field, std::string cond, std::string str);
	void select_index_alphaidx(std::string filter, std::string str);

	Glib::RefPtr<Gdk::Pixbuf> icon;
	std::string user_filter;
	std::string user_index_field;

public:
	TWindow1 ();
	void init();

	TModelListView ListView;	
	TModelListBox ListBox;	
	TModelListExt ListExt;	
	TModelListSoundInfo ListSoundInfo;	

	Glib::RefPtr<Gtk::ListStore> store_sounds;
	Glib::RefPtr<Gtk::ListStore> store_index;
	Glib::RefPtr<Gtk::ListStore> store_lang;
	Glib::RefPtr<Gtk::ListStore> store_fields;
	Glib::RefPtr<Gtk::TreeStore> store_info;

	SOUND_INFO_VARS;
};




#endif
