#include "ux_server_socket.h"

int ux_server_socket(const char *pipe, const int LISTENQ) {
  int ld; 
  struct sockaddr_un ux_sockaddr;
  
  ux_sockaddr.sun_family = AF_UNIX;
  strcpy(ux_sockaddr.sun_path , pipe);
  
  if ((ld = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
    perror("bind on unix domain socket");
    exit(6);
  }
  
  unlink(pipe);
  
  if ( bind (ld, (struct sockaddr *) &ux_sockaddr, sizeof(ux_sockaddr)) < 0) {
    perror("bind on unix domain socket");
    exit(7);
  }
  
  if ( listen(ld, LISTENQ) < 0) {
    perror("listen on unix domain socket");
    exit(8);
  }
  return(ld);
}
