/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleModifier.h"
#include "utility.h"

SubtitleColumnRecorder SubtitleModifier::column;

/*
 *
 */
SubtitleModifier::SubtitleModifier(const Gtk::TreeIter &it)
{
	iter = it;
}

/*
 *
 */
SubtitleModifier::~SubtitleModifier()
{
}

/*
 *
 */
SubtitleModifier::operator bool() const
{
	if(iter)
		return true;
	return false;
}

/*
 *
 */
Gtk::TreeIter SubtitleModifier::get_iter() const
{
	return iter;
}


/*
 *
 */
void SubtitleModifier::set_num(unsigned int num)
{
	(*iter)[column.num] = num;
}

/*
 *
 */
unsigned int SubtitleModifier::get_num() const
{
	return (*iter)[column.num];
}


/*
 *
 */
void SubtitleModifier::set_layer(const Glib::ustring &layer)
{
	(*iter)[column.layer] = layer;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_layer() const
{
	return (*iter)[column.layer];
}


/*
 *
 */
void SubtitleModifier::set_start(const Glib::ustring &start)
{
	SubtitleTime s(start);

	(*iter)[column.start] = s.str();

	(*iter)[column.duration] = (get_end() - s).str();
}

void SubtitleModifier::set_start(const SubtitleTime &start)
{
	(*iter)[column.start] = start.str();

	(*iter)[column.duration] = (get_end() - start).str();
}

/*
 *
 */
SubtitleTime SubtitleModifier::get_start() const
{
	return SubtitleTime((*iter)[column.start]);
}


/*
 *
 */
void SubtitleModifier::set_end(const Glib::ustring &end)
{
	SubtitleTime e(end);

	(*iter)[column.end] = e.str();

	(*iter)[column.duration] = (e - get_start()).str();
}

void SubtitleModifier::set_end(const SubtitleTime &end)
{
	(*iter)[column.end] = end.str();

	(*iter)[column.duration] = (end - get_start()).str();
}

/*
 *
 */
SubtitleTime SubtitleModifier::get_end() const
{
	return SubtitleTime((*iter)[column.end]);
}


/*
 *
 */
void SubtitleModifier::set_duration(const Glib::ustring &time)
{
	SubtitleTime d(time);

	(*iter)[column.duration] = d.str();

	(*iter)[column.end] = (get_start() + d).str();
}

void SubtitleModifier::set_duration(const SubtitleTime &time)
{
	(*iter)[column.duration] = time.str();

	(*iter)[column.end] = (get_start() + time).str();
}

/*
 *
 */
SubtitleTime SubtitleModifier::get_duration() const
{
	return SubtitleTime((*iter)[column.duration]);
}


/*
 *
 */
void SubtitleModifier::set_style(const Glib::ustring &style)
{
	(*iter)[column.style] = style;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_style() const
{
	return (*iter)[column.style];
}


/*
 *
 */
void SubtitleModifier::set_name(const Glib::ustring &name)
{
	(*iter)[column.name] = name;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_name() const
{
	return (*iter)[column.name];
}


/*
 *
 */
void SubtitleModifier::set_margin_l(const Glib::ustring &value)
{
	(*iter)[column.marginL] = value;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_margin_l() const
{
	return (*iter)[column.marginL];
}


/*
 *
 */
void SubtitleModifier::set_margin_r(const Glib::ustring &value)
{
	(*iter)[column.marginR] = value;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_margin_r() const
{
	return (*iter)[column.marginR];
}


/*
 *
 */
void SubtitleModifier::set_margin_v(const Glib::ustring &value)
{
	(*iter)[column.marginV] = value;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_margin_v() const
{
	return (*iter)[column.marginV];
}


/*
 *
 */
void SubtitleModifier::set_effect(const Glib::ustring &effect)
{
	(*iter)[column.effect] = effect;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_effect() const
{
	return (*iter)[column.effect];
}


/*
 *
 */
void SubtitleModifier::set_text(const Glib::ustring &text)
{
	(*iter)[column.text] = text;

	// characters per line
	if(text.size() == 0)
		(*iter)[column.characters_per_line] = "0";
	else
	{
		std::istringstream iss(text);
		std::string line;
		std::string cpl;

		unsigned int count=0;

		while( std::getline(iss, line) )
		{
			if(count == 0)
				cpl += to_string(line.size());
			else
				cpl += "\n" + to_string(line.size());

			++count;
		}
	
		(*iter)[column.characters_per_line] = cpl;
		
		/*
		std::string cpl;
		unsigned int line = 0;
		unsigned int c = 0;

		for(unsigned int i=0; i<text.size(); ++i)
		{
			if(text[i] == '\n')
			{
				if(line != 0)
					cpl += "\n" + to_string(c);
				else
					cpl += to_string(c);
				
				c = 0;

				++line;
			}
			else
				++c;
		}

		if(c != 0)
		{
			if(line != 0)
				cpl += "\n" + to_string(c);
			else
				cpl += to_string(c);
		}

		(*iter)[column.characters_per_line] = cpl;
		*/
	}
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_text() const
{
	return (*iter)[column.text];
}

/*
 *
 */
void SubtitleModifier::set_translation(const Glib::ustring &text)
{
	(*iter)[column.translation] = text;
}

/*
 *
 */
Glib::ustring SubtitleModifier::get_translation() const
{
	return (*iter)[column.translation];
}


/*
 *	ex: 6 or 3\n3
 */
Glib::ustring SubtitleModifier::get_characters_per_line()
{
	return (*iter)[column.characters_per_line];
}
