#ifndef _MenuBar_h
#define _MenuBar_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <gtkmm.h>

class MenuBar : public Gtk::VBox
{
public:
	MenuBar(Gtk::Window &window);

	/*
	 *	change l'etat d'affichage d'une colonne
	 */
	void set_toggle_column(const Glib::ustring &column, const bool &state); 

	/*
	 *
	 */
	void on_toggle_column(const Glib::ustring &column);
	
	/*
	 *
	 */
	void on_setup_view_simple();
	void on_setup_view_advanced();
	void on_setup_view_translation();
	void on_setup_view_timing();

	/*
	 *
	 */
	void init_columns_by_subtitleview();
	
protected:
	Glib::RefPtr<Gtk::UIManager> m_refUIManager;
	Glib::RefPtr<Gtk::ActionGroup> m_refActionGroup;
};

#endif//_MenuBar_h

