/*
 * gtk-editable.c	-- GTK+ editable and descendants
 * 
 * Copyright  2000 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 * 
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 19-Aug-2000 12:09 (eg)
 * Last file update: 10-Nov-2000 23:09 (eg)
 */

#include "stklos.h"
#include "gtk-glue.h"

DEFINE_PRIMITIVE("%gtk-editable-get-or-set", editable_get_set, subr12,
		 (SCM w, SCM val))
{
  GtkEditable * e;

  ENTER_PRIMITIVE(editable_get_set);
  if (!WIDGETP(w) || !GTK_IS_EDITABLE(WIDGET_ID(w))) STk_error_bad_widget(w);
  
  e = GTK_EDITABLE(WIDGET_ID(w));
  
  if (!val) {
    /* get entry value */
    return STk_Cstring2string(gtk_editable_get_chars(e, 0, -1));
  } else {
    /* set entry value */
    char *s = (char *)  STRING_CHARS(val);
    int pos = 0; 

    if (!STRINGP(val)) STk_error("bad string ~S", val);
    gtk_editable_delete_text(GTK_EDITABLE(WIDGET_ID(w)), 0, -1);
    gtk_editable_insert_text(GTK_EDITABLE(WIDGET_ID(w)), s, strlen(s), &pos);
    return STk_void;
  }
}

/*===========================================================================*\
 * 
 * 				  E N T R Y 
 *
\*===========================================================================*/
SIMPLE_WIDGET("%entry", entry, (gtk_entry_new()));


/*===========================================================================*\
 * 
 * 				  S P I N B O X 
 *
\*===========================================================================*/
DEFINE_PRIMITIVE("%spinbox", spinbox, subr1, (SCM obj))
{
  SCM adj, res;
  GtkObject *adjustment;
  GtkWidget *sb;
  
  /* Create a new ajustement */
  adjustment = gtk_adjustment_new(DEF_AJUSTMENT);
  adj 	     = STk_gtk_widget2scm((GtkWidget *)adjustment, obj);
  
  /* create the spinbox widget */
  sb  = gtk_spin_button_new((GtkAdjustment *) adjustment, 1.0, 2);
  res = STk_gtk_widget2scm(sb, obj);
  
  /* Keep a reference on the adjustement through the gauge */
  WIDGET_PLIST(res) = LIST2(STk_makekey(":adjustment"), adj);
  
  return res;
}

/*===========================================================================*\
 * 
 * 				  T E X T
 *
\*===========================================================================*/

DEFINE_PRIMITIVE("%text", text, subr1, (SCM obj))
{
  SCM res; 
  
  res = STk_gtk_widget2scm(gtk_text_new(NULL, NULL), obj);
  /* GTK text are non modifiable by default. Chage that */
  gtk_text_set_editable((GtkText *) WIDGET_ID(res), TRUE);
  return res;
}

DEFINE_PRIMITIVE("%text-vadj", text_vadj, subr1, (SCM obj))
{
  ENTER_PRIMITIVE(text_vadj);
  if (!WIDGETP(obj) || !GTK_IS_TEXT(WIDGET_ID(obj)))
    STk_error("bad text widget ~S", obj);
  return STk_gtk_widget2scm((GtkWidget *) (GTK_TEXT(WIDGET_ID(obj))->vadj), obj);
}

DEFINE_PRIMITIVE("%text-ctrl", text_ctrl, subr23, (SCM obj, SCM what, SCM val))
{
  ENTER_PRIMITIVE(text_ctrl);
  
  if (!WIDGETP(obj) || !GTK_IS_TEXT(WIDGET_ID(obj)))
    STk_error_bad_widget(obj);

  switch (what) {
    case MAKE_INT(0): 		/* get point */
      return MAKE_INT(gtk_text_get_point((GtkText*) WIDGET_ID(obj)));
    case MAKE_INT(1): {		/* set point */
      int point; 
      
      if (!val) 	 STk_error("missing point value");
      point = STk_integer_value(val);
      if (point == LONG_MIN) STk_error("bad value for point ~S", val);
      gtk_text_set_point((GtkText*) WIDGET_ID(obj), point);
      break;
    }
    case MAKE_INT(2): 	/* freeze */
      gtk_text_freeze((GtkText*) WIDGET_ID(obj));
      break;
    case MAKE_INT(3): 	/* unfreeze */
      gtk_text_thaw((GtkText*) WIDGET_ID(obj));
      break;
    case MAKE_INT(4): 	/* Cut */
      gtk_editable_cut_clipboard(GTK_EDITABLE(WIDGET_ID(obj)));
      break;
    case MAKE_INT(5): 	/* Copy */
      gtk_editable_copy_clipboard(GTK_EDITABLE(WIDGET_ID(obj)));
      break;
    case MAKE_INT(6): 	/* Paste */
      gtk_editable_paste_clipboard(GTK_EDITABLE(WIDGET_ID(obj)));
      break;
    default:
      STk_error("bad code ~S", what);
  }
  return STk_void;
}


DEFINE_PRIMITIVE("%text-insert", text_insert, subr2, (SCM obj, SCM str))
{
  ENTER_PRIMITIVE(text_insert);
  
  if (!WIDGETP(obj) || !GTK_IS_TEXT(WIDGET_ID(obj)))
    STk_error_bad_widget(obj);
  if (!STRINGP(str))
    STk_error("bad string ~S", str);

  gtk_text_insert((GtkText*) WIDGET_ID(obj),
		  NULL, /* font */
		  NULL, /* foreground */
		  NULL, /* background */
		  STRING_CHARS(str),
		  STRING_SIZE(str));
  return STk_void;
}

void STk_init_gtk_editable(void)
{
  ADD_PRIMITIVE(editable_get_set);
  ADD_PRIMITIVE(entry);
  ADD_PRIMITIVE(spinbox);
  ADD_PRIMITIVE(text);

  ADD_PRIMITIVE(text_vadj);
  ADD_PRIMITIVE(text_ctrl);
  ADD_PRIMITIVE(text_insert);
}
