/* NOM........  sha.h											*/
/* OBJET......  Secure Hash Algorithm and K-HMAC		*/
/* PROJET.....	 SFP V.1            						   */
/* REFERENCES.                        						*/
/* VERSION....  1.0                    					*/
/* HISTORIQUE.  													*/
/**/


#ifndef SHA_H
#define SHA_H


/*---------------------------------------------------------*/
/*			Fonctions prototypes                              */
/*---------------------------------------------------------*/

/* Hash Computing */
/**/
	void	ShaProc(		/* SHA Processing For Short Message (< 32Ko) */
				unsigned char*,			/* Message To Hash 		*/
				int,				/* Message Length  		*/
				unsigned char*);			/* Hash Of Message 		*/
	/* SHA For Long Message (ex. File) 	*/
	void	ShaInit();		/* 1. First Call									*/
	void	ShaNext(			/* 2. Partial SHA Processing					*/
				unsigned char*,			/* Message To Hash 		*/
				int);				/* Message Length  		*/
	void	ShaEnd(			/* Last SHA Processing 							*/
				unsigned char*,			/* Message To Hash 		*/
				int,				/* Message Length  		*/
				unsigned char*);			/* Hash Of Message 		*/
	/* SHA-1 Keyed Hash MAC Computing	*/
	void	Hmac(			/* SHA-1 Keyed Hash MAC								*/
				unsigned char*,			/* Key                  */
				int,				/* Key Length (<=64)    */
				unsigned char*,			/* Text                 */
				int,				/* Text Length (<=1000) */
				unsigned char*);			/* Result (20 bytes)    */
   /* Convert HMAC In Ascii Stream */
   void   ConvertInAsciiStream(
   			unsigned char*,			/* hmac in hexa */
            unsigned char,         /* hmac lg=20 */
            unsigned char*);      /* result in ascii */

#endif

