/* spek-spectrogram.c generated by valac 0.10.4, the Vala compiler
 * generated from spek-spectrogram.vala, do not modify */

/* spek-spectrogram.vala
 *
 * Copyright (C) 2010-2011  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <spek-platform.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>
#include <pango/pango.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define SPEK_TYPE_SPECTROGRAM (spek_spectrogram_get_type ())
#define SPEK_SPECTROGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_SPECTROGRAM, SpekSpectrogram))
#define SPEK_SPECTROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_SPECTROGRAM, SpekSpectrogramClass))
#define SPEK_IS_SPECTROGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_SPECTROGRAM))
#define SPEK_IS_SPECTROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_SPECTROGRAM))
#define SPEK_SPECTROGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_SPECTROGRAM, SpekSpectrogramClass))

typedef struct _SpekSpectrogram SpekSpectrogram;
typedef struct _SpekSpectrogramClass SpekSpectrogramClass;
typedef struct _SpekSpectrogramPrivate SpekSpectrogramPrivate;

#define SPEK_TYPE_PIPELINE (spek_pipeline_get_type ())
#define SPEK_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_PIPELINE, SpekPipeline))
#define SPEK_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_PIPELINE, SpekPipelineClass))
#define SPEK_IS_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_PIPELINE))
#define SPEK_IS_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_PIPELINE))
#define SPEK_PIPELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_PIPELINE, SpekPipelineClass))

typedef struct _SpekPipeline SpekPipeline;
typedef struct _SpekPipelineClass SpekPipelineClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _spek_pipeline_unref0(var) ((var == NULL) ? NULL : (var = (spek_pipeline_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

#define SPEK_RULER_TYPE_POSITION (spek_ruler_position_get_type ())

#define SPEK_TYPE_RULER (spek_ruler_get_type ())
#define SPEK_RULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_RULER, SpekRuler))
#define SPEK_RULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_RULER, SpekRulerClass))
#define SPEK_IS_RULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_RULER))
#define SPEK_IS_RULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_RULER))
#define SPEK_RULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_RULER, SpekRulerClass))

typedef struct _SpekRuler SpekRuler;
typedef struct _SpekRulerClass SpekRulerClass;
typedef struct _Block3Data Block3Data;
typedef struct _Block2Data Block2Data;

struct _SpekSpectrogram {
	GtkDrawingArea parent_instance;
	SpekSpectrogramPrivate * priv;
};

struct _SpekSpectrogramClass {
	GtkDrawingAreaClass parent_class;
};

struct _SpekSpectrogramPrivate {
	char* _file_name;
	SpekPipeline* pipeline;
	char* info;
	cairo_surface_t* image;
	cairo_surface_t* palette;
	double FONT_SCALE;
	gint prev_width;
	double log10_threshold;
};

typedef void (*SpekPipelineCallback) (gint sample, float* values, int values_length1, void* user_data);
typedef enum  {
	SPEK_RULER_POSITION_TOP,
	SPEK_RULER_POSITION_RIGHT,
	SPEK_RULER_POSITION_BOTTOM,
	SPEK_RULER_POSITION_LEFT
} SpekRulerPosition;

typedef double (*SpekRulerMeasure) (gint unit, void* user_data);
typedef double (*SpekRulerPlace) (double p, void* user_data);
typedef char* (*SpekRulerFormatTick) (gint unit, void* user_data);
struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gint duration_seconds;
	gint freq;
};

struct _Block2Data {
	int _ref_count_;
	SpekSpectrogram * self;
	double w;
	double h;
};


static gpointer spek_spectrogram_parent_class = NULL;

GType spek_spectrogram_get_type (void) G_GNUC_CONST;
gpointer spek_pipeline_ref (gpointer instance);
void spek_pipeline_unref (gpointer instance);
GParamSpec* spek_param_spec_pipeline (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void spek_value_set_pipeline (GValue* value, gpointer v_object);
void spek_value_take_pipeline (GValue* value, gpointer v_object);
gpointer spek_value_get_pipeline (const GValue* value);
GType spek_pipeline_get_type (void) G_GNUC_CONST;
#define SPEK_SPECTROGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPEK_TYPE_SPECTROGRAM, SpekSpectrogramPrivate))
enum  {
	SPEK_SPECTROGRAM_DUMMY_PROPERTY,
	SPEK_SPECTROGRAM_FILE_NAME
};
#define SPEK_SPECTROGRAM_THRESHOLD (-92)
#define SPEK_SPECTROGRAM_NFFT 2048
#define SPEK_SPECTROGRAM_BANDS ((SPEK_SPECTROGRAM_NFFT / 2) + 1)
#define SPEK_SPECTROGRAM_LPAD 60
#define SPEK_SPECTROGRAM_TPAD 60
#define SPEK_SPECTROGRAM_RPAD 80
#define SPEK_SPECTROGRAM_BPAD 40
#define SPEK_SPECTROGRAM_GAP 10
#define SPEK_SPECTROGRAM_RULER 10
SpekSpectrogram* spek_spectrogram_new (void);
SpekSpectrogram* spek_spectrogram_construct (GType object_type);
static guint32 spek_spectrogram_get_color (SpekSpectrogram* self, double level);
static void spek_spectrogram_put_pixel (SpekSpectrogram* self, cairo_surface_t* surface, gint x, gint y, guint32 color);
void spek_spectrogram_open (SpekSpectrogram* self, const char* file_name);
static void spek_spectrogram_set_file_name (SpekSpectrogram* self, const char* value);
static void spek_spectrogram_start (SpekSpectrogram* self);
void spek_spectrogram_save (SpekSpectrogram* self, const char* file_name);
static void spek_spectrogram_draw (SpekSpectrogram* self, cairo_t* cr);
void spek_pipeline_stop (SpekPipeline* self);
const char* spek_spectrogram_get_file_name (SpekSpectrogram* self);
static void spek_spectrogram_data_cb (SpekSpectrogram* self, gint sample, float* values, int values_length1);
static void _spek_spectrogram_data_cb_spek_pipeline_callback (gint sample, float* values, int values_length1, gpointer self);
SpekPipeline* spek_pipeline_new (const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target);
SpekPipeline* spek_pipeline_construct (GType object_type, const char* file_name, gint bands, gint samples, gint threshold, SpekPipelineCallback cb, void* cb_target);
void spek_pipeline_start (SpekPipeline* self);
const char* spek_pipeline_get_description (SpekPipeline* self);
static void spek_spectrogram_real_size_allocate (GtkWidget* base, GdkRectangle* allocation);
static gboolean _lambda3_ (SpekSpectrogram* self);
static gboolean __lambda3__gsource_func (gpointer self);
static gboolean spek_spectrogram_real_expose_event (GtkWidget* base, GdkEventExpose* event);
double spek_pipeline_get_duration (SpekPipeline* self);
GType spek_ruler_position_get_type (void) G_GNUC_CONST;
static double _lambda4_ (gint unit, Block3Data* _data3_);
static double __lambda4__spek_ruler_measure (gint unit, gpointer self);
static double _lambda5_ (double p, SpekSpectrogram* self);
static double __lambda5__spek_ruler_place (double p, gpointer self);
static char* _lambda6_ (gint unit, SpekSpectrogram* self);
static char* __lambda6__spek_ruler_format_tick (gint unit, gpointer self);
SpekRuler* spek_ruler_new (SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target);
SpekRuler* spek_ruler_construct (GType object_type, SpekRulerPosition pos, const char* sample_label, gint* factors, int factors_length1, gint units, double spacing, SpekRulerMeasure measure, void* measure_target, SpekRulerPlace place, void* place_target, SpekRulerFormatTick format_tick, void* format_tick_target);
GType spek_ruler_get_type (void) G_GNUC_CONST;
void spek_ruler_draw (SpekRuler* self, cairo_t* cr, PangoLayout* layout);
gint spek_pipeline_get_sample_rate (SpekPipeline* self);
static double _lambda7_ (gint unit, Block3Data* _data3_);
static double __lambda7__spek_ruler_measure (gint unit, gpointer self);
static double _lambda8_ (double p, SpekSpectrogram* self);
static double __lambda8__spek_ruler_place (double p, gpointer self);
static char* _lambda9_ (gint unit, SpekSpectrogram* self);
static char* __lambda9__spek_ruler_format_tick (gint unit, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static double _lambda10_ (gint unit, Block2Data* _data2_);
static double __lambda10__spek_ruler_measure (gint unit, gpointer self);
static double _lambda11_ (double p, Block2Data* _data2_);
static double __lambda11__spek_ruler_place (double p, gpointer self);
static char* _lambda12_ (gint unit, SpekSpectrogram* self);
static char* __lambda12__spek_ruler_format_tick (gint unit, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void spek_spectrogram_finalize (GObject* obj);
static void spek_spectrogram_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void spek_spectrogram_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



SpekSpectrogram* spek_spectrogram_construct (GType object_type) {
	SpekSpectrogram * self;
	cairo_surface_t* _tmp0_;
	self = g_object_newv (object_type, 0, NULL);
	self->priv->palette = (_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, SPEK_SPECTROGRAM_RULER, SPEK_SPECTROGRAM_BANDS), _cairo_surface_destroy0 (self->priv->palette), _tmp0_);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint32 color;
				if (!_tmp1_) {
					y++;
				}
				_tmp1_ = FALSE;
				if (!(y < SPEK_SPECTROGRAM_BANDS)) {
					break;
				}
				color = spek_spectrogram_get_color (self, y / ((double) SPEK_SPECTROGRAM_BANDS));
				{
					gint x;
					x = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							if (!_tmp2_) {
								x++;
							}
							_tmp2_ = FALSE;
							if (!(x < SPEK_SPECTROGRAM_RULER)) {
								break;
							}
							spek_spectrogram_put_pixel (self, self->priv->palette, x, y, color);
						}
					}
				}
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


SpekSpectrogram* spek_spectrogram_new (void) {
	return spek_spectrogram_construct (SPEK_TYPE_SPECTROGRAM);
}


void spek_spectrogram_open (SpekSpectrogram* self, const char* file_name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_name != NULL);
	spek_spectrogram_set_file_name (self, file_name);
	self->priv->info = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->info), _tmp0_);
	spek_spectrogram_start (self);
}


void spek_spectrogram_save (SpekSpectrogram* self, const char* file_name) {
	GtkAllocation allocation = {0};
	cairo_surface_t* surface;
	cairo_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_name != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &allocation);
	surface = cairo_image_surface_create (CAIRO_FORMAT_RGB24, allocation.width, allocation.height);
	spek_spectrogram_draw (self, _tmp0_ = cairo_create (surface));
	_cairo_destroy0 (_tmp0_);
	cairo_surface_write_to_png (surface, file_name);
	_cairo_surface_destroy0 (surface);
}


static void _spek_spectrogram_data_cb_spek_pipeline_callback (gint sample, float* values, int values_length1, gpointer self) {
	spek_spectrogram_data_cb (self, sample, values, values_length1);
}


static void spek_spectrogram_start (SpekSpectrogram* self) {
	GtkAllocation allocation = {0};
	gint samples;
	g_return_if_fail (self != NULL);
	if (self->priv->pipeline != NULL) {
		spek_pipeline_stop (self->priv->pipeline);
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &allocation);
	samples = (allocation.width - SPEK_SPECTROGRAM_LPAD) - SPEK_SPECTROGRAM_RPAD;
	if (samples > 0) {
		cairo_surface_t* _tmp0_;
		SpekPipeline* _tmp1_;
		char* _tmp2_;
		self->priv->image = (_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, samples, SPEK_SPECTROGRAM_BANDS), _cairo_surface_destroy0 (self->priv->image), _tmp0_);
		self->priv->pipeline = (_tmp1_ = spek_pipeline_new (self->priv->_file_name, SPEK_SPECTROGRAM_BANDS, samples, SPEK_SPECTROGRAM_THRESHOLD, _spek_spectrogram_data_cb_spek_pipeline_callback, self), _spek_pipeline_unref0 (self->priv->pipeline), _tmp1_);
		spek_pipeline_start (self->priv->pipeline);
		self->priv->info = (_tmp2_ = g_strdup (spek_pipeline_get_description (self->priv->pipeline)), _g_free0 (self->priv->info), _tmp2_);
	} else {
		cairo_surface_t* _tmp3_;
		SpekPipeline* _tmp4_;
		self->priv->image = (_tmp3_ = NULL, _cairo_surface_destroy0 (self->priv->image), _tmp3_);
		self->priv->pipeline = (_tmp4_ = NULL, _spek_pipeline_unref0 (self->priv->pipeline), _tmp4_);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void spek_spectrogram_real_size_allocate (GtkWidget* base, GdkRectangle* allocation) {
	SpekSpectrogram * self;
	gboolean width_changed;
	gboolean _tmp0_ = FALSE;
	self = (SpekSpectrogram*) base;
	GTK_WIDGET_CLASS (spek_spectrogram_parent_class)->size_allocate ((GtkWidget*) GTK_DRAWING_AREA (self), allocation);
	width_changed = self->priv->prev_width != (*allocation).width;
	self->priv->prev_width = (*allocation).width;
	if (self->priv->_file_name != NULL) {
		_tmp0_ = width_changed;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		spek_spectrogram_start (self);
	}
}


static gboolean _lambda3_ (SpekSpectrogram* self) {
	gboolean result = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


static void spek_spectrogram_data_cb (SpekSpectrogram* self, gint sample, float* values, int values_length1) {
	g_return_if_fail (self != NULL);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				double level;
				if (!_tmp0_) {
					y++;
				}
				_tmp0_ = FALSE;
				if (!(y < SPEK_SPECTROGRAM_BANDS)) {
					break;
				}
				level = MIN (1.0, log10 ((1.0 - SPEK_SPECTROGRAM_THRESHOLD) + values[y]) / self->priv->log10_threshold);
				spek_spectrogram_put_pixel (self, self->priv->image, sample, y, spek_spectrogram_get_color (self, level));
			}
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda3__gsource_func, g_object_ref (self), g_object_unref);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean spek_spectrogram_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SpekSpectrogram * self;
	gboolean result = FALSE;
	GdkWindow* window;
	cairo_t* cr;
	self = (SpekSpectrogram*) base;
	window = _g_object_ref0 (gtk_widget_get_window ((GtkWidget*) self));
	cr = gdk_cairo_create ((GdkDrawable*) window);
	cairo_rectangle (cr, (double) (*event).area.x, (double) (*event).area.y, (double) (*event).area.width, (double) (*event).area.height);
	cairo_clip (cr);
	spek_spectrogram_draw (self, cr);
	result = TRUE;
	_cairo_destroy0 (cr);
	_g_object_unref0 (window);
	return result;
}


static char* double_to_string (double self) {
	char* result = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static double _lambda4_ (gint unit, Block3Data* _data3_) {
	Block2Data* _data2_;
	SpekSpectrogram * self;
	double result = 0.0;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	result = (((_data2_->w - SPEK_SPECTROGRAM_LPAD) - SPEK_SPECTROGRAM_RPAD) * unit) / _data3_->duration_seconds;
	return result;
}


static double __lambda4__spek_ruler_measure (gint unit, gpointer self) {
	double result;
	result = _lambda4_ (unit, self);
	return result;
}


static double _lambda5_ (double p, SpekSpectrogram* self) {
	double result = 0.0;
	result = p;
	return result;
}


static double __lambda5__spek_ruler_place (double p, gpointer self) {
	double result;
	result = _lambda5_ (p, self);
	return result;
}


static char* _lambda6_ (gint unit, SpekSpectrogram* self) {
	char* result = NULL;
	result = g_strdup_printf ("%d:%02d", unit / 60, unit % 60);
	return result;
}


static char* __lambda6__spek_ruler_format_tick (gint unit, gpointer self) {
	char* result;
	result = _lambda6_ (unit, self);
	return result;
}


static double _lambda7_ (gint unit, Block3Data* _data3_) {
	Block2Data* _data2_;
	SpekSpectrogram * self;
	double result = 0.0;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	result = (((_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD) * unit) / _data3_->freq;
	return result;
}


static double __lambda7__spek_ruler_measure (gint unit, gpointer self) {
	double result;
	result = _lambda7_ (unit, self);
	return result;
}


static double _lambda8_ (double p, SpekSpectrogram* self) {
	double result = 0.0;
	result = p;
	return result;
}


static double __lambda8__spek_ruler_place (double p, gpointer self) {
	double result;
	result = _lambda8_ (p, self);
	return result;
}


static char* _lambda9_ (gint unit, SpekSpectrogram* self) {
	char* result = NULL;
	result = g_strdup_printf (_ ("%d kHz"), unit / 1000);
	return result;
}


static char* __lambda9__spek_ruler_format_tick (gint unit, gpointer self) {
	char* result;
	result = _lambda9_ (unit, self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		g_slice_free (Block3Data, _data3_);
	}
}


static double _lambda10_ (gint unit, Block2Data* _data2_) {
	SpekSpectrogram * self;
	double result = 0.0;
	self = _data2_->self;
	result = ((-((_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD)) * unit) / SPEK_SPECTROGRAM_THRESHOLD;
	return result;
}


static double __lambda10__spek_ruler_measure (gint unit, gpointer self) {
	double result;
	result = _lambda10_ (unit, self);
	return result;
}


static double _lambda11_ (double p, Block2Data* _data2_) {
	SpekSpectrogram * self;
	double result = 0.0;
	self = _data2_->self;
	result = ((_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD) - p;
	return result;
}


static double __lambda11__spek_ruler_place (double p, gpointer self) {
	double result;
	result = _lambda11_ (p, self);
	return result;
}


static char* _lambda12_ (gint unit, SpekSpectrogram* self) {
	char* result = NULL;
	result = g_strdup_printf (_ ("%d dB"), -unit);
	return result;
}


static char* __lambda12__spek_ruler_format_tick (gint unit, gpointer self) {
	char* result;
	result = _lambda12_ (unit, self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void spek_spectrogram_draw (SpekSpectrogram* self, cairo_t* cr) {
	Block2Data* _data2_;
	GtkAllocation allocation = {0};
	gint text_width = 0;
	gint text_height = 0;
	PangoLayout* layout;
	char* _tmp0_;
	char* _tmp1_;
	PangoFontDescription* _tmp2_;
	gint line_height;
	char* _tmp3_;
	char* _tmp4_;
	PangoFontDescription* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	PangoFontDescription* _tmp8_;
	char* _tmp24_;
	char* _tmp25_;
	PangoFontDescription* _tmp26_;
	gint* _tmp27_ = NULL;
	gint* _tmp28_;
	gint _tmp28__length1;
	SpekRuler* _tmp29_;
	SpekRuler* density_ruler;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	gtk_widget_get_allocation ((GtkWidget*) self, &allocation);
	_data2_->w = (double) allocation.width;
	_data2_->h = (double) allocation.height;
	cairo_set_source_rgb (cr, (double) 0, (double) 0, (double) 0);
	cairo_paint (cr);
	cairo_set_source_rgb (cr, (double) 1, (double) 1, (double) 1);
	layout = pango_cairo_create_layout (cr);
	pango_layout_set_font_description (layout, _tmp2_ = pango_font_description_from_string (_tmp1_ = g_strconcat ("Sans ", _tmp0_ = double_to_string (9 * self->priv->FONT_SCALE), NULL)));
	_pango_font_description_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	pango_layout_set_width (layout, SPEK_SPECTROGRAM_RPAD * PANGO_SCALE);
	pango_layout_set_text (layout, "dummy", -1);
	pango_layout_get_pixel_size (layout, &text_width, &text_height);
	line_height = text_height;
	pango_layout_set_font_description (layout, _tmp5_ = pango_font_description_from_string (_tmp4_ = g_strconcat ("Sans Bold ", _tmp3_ = double_to_string (10 * self->priv->FONT_SCALE), NULL)));
	_pango_font_description_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	pango_layout_set_text (layout, PACKAGE_NAME " ", -1);
	pango_layout_get_pixel_size (layout, &text_width, &text_height);
	cairo_move_to (cr, (_data2_->w - SPEK_SPECTROGRAM_RPAD) + SPEK_SPECTROGRAM_GAP, (double) ((SPEK_SPECTROGRAM_TPAD - (2 * SPEK_SPECTROGRAM_GAP)) - line_height));
	pango_cairo_show_layout_line (cr, pango_layout_get_line (layout, 0));
	pango_layout_set_font_description (layout, _tmp8_ = pango_font_description_from_string (_tmp7_ = g_strconcat ("Sans ", _tmp6_ = double_to_string (9 * self->priv->FONT_SCALE), NULL)));
	_pango_font_description_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	pango_layout_set_text (layout, PACKAGE_VERSION, -1);
	cairo_rel_move_to (cr, (double) text_width, (double) 0);
	pango_cairo_show_layout_line (cr, pango_layout_get_line (layout, 0));
	if (self->priv->image != NULL) {
		Block3Data* _data3_;
		char* _tmp9_;
		char* _tmp10_;
		PangoFontDescription* _tmp11_;
		gint* _tmp12_ = NULL;
		gint* _tmp13_;
		gint _tmp13__length1;
		SpekRuler* _tmp14_;
		SpekRuler* time_ruler;
		gint* _tmp15_ = NULL;
		gint* _tmp16_;
		gint _tmp16__length1;
		SpekRuler* _tmp17_;
		SpekRuler* rate_ruler;
		char* _tmp18_;
		char* _tmp19_;
		PangoFontDescription* _tmp20_;
		char* _tmp21_;
		char* _tmp22_;
		PangoFontDescription* _tmp23_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		cairo_translate (cr, (double) SPEK_SPECTROGRAM_LPAD, _data2_->h - SPEK_SPECTROGRAM_BPAD);
		cairo_scale (cr, (double) 1, (-((_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD)) / cairo_image_surface_get_height (self->priv->image));
		cairo_set_source_surface (cr, self->priv->image, (double) 0, (double) 0);
		cairo_paint (cr);
		cairo_identity_matrix (cr);
		cairo_set_source_rgb (cr, (double) 1, (double) 1, (double) 1);
		cairo_set_line_width (cr, (double) 1);
		cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
		pango_layout_set_font_description (layout, _tmp11_ = pango_font_description_from_string (_tmp10_ = g_strconcat ("Sans ", _tmp9_ = double_to_string (8 * self->priv->FONT_SCALE), NULL)));
		_pango_font_description_free0 (_tmp11_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp9_);
		pango_layout_set_width (layout, -1);
		_data3_->duration_seconds = (gint) spek_pipeline_get_duration (self->priv->pipeline);
		time_ruler = (_tmp14_ = spek_ruler_new (SPEK_RULER_POSITION_BOTTOM, "00:00", (_tmp13_ = (_tmp12_ = g_new0 (gint, 12), _tmp12_[0] = 1, _tmp12_[1] = 2, _tmp12_[2] = 5, _tmp12_[3] = 10, _tmp12_[4] = 20, _tmp12_[5] = 30, _tmp12_[6] = 1 * 60, _tmp12_[7] = 2 * 60, _tmp12_[8] = 5 * 60, _tmp12_[9] = 10 * 60, _tmp12_[10] = 20 * 60, _tmp12_[11] = 30 * 60, _tmp12_), _tmp13__length1 = 12, _tmp13_), 12, _data3_->duration_seconds, 1.5, __lambda4__spek_ruler_measure, _data3_, __lambda5__spek_ruler_place, self, __lambda6__spek_ruler_format_tick, self), _tmp13_ = (g_free (_tmp13_), NULL), _tmp14_);
		cairo_translate (cr, (double) SPEK_SPECTROGRAM_LPAD, _data2_->h - SPEK_SPECTROGRAM_BPAD);
		spek_ruler_draw (time_ruler, cr, layout);
		cairo_identity_matrix (cr);
		_data3_->freq = spek_pipeline_get_sample_rate (self->priv->pipeline) / 2;
		rate_ruler = (_tmp17_ = spek_ruler_new (SPEK_RULER_POSITION_LEFT, _ ("00 kHz"), (_tmp16_ = (_tmp15_ = g_new0 (gint, 5), _tmp15_[0] = 1000, _tmp15_[1] = 2000, _tmp15_[2] = 5000, _tmp15_[3] = 10000, _tmp15_[4] = 20000, _tmp15_), _tmp16__length1 = 5, _tmp16_), 5, _data3_->freq, 3.0, __lambda7__spek_ruler_measure, _data3_, __lambda8__spek_ruler_place, self, __lambda9__spek_ruler_format_tick, self), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
		cairo_translate (cr, (double) SPEK_SPECTROGRAM_LPAD, (double) SPEK_SPECTROGRAM_TPAD);
		spek_ruler_draw (rate_ruler, cr, layout);
		cairo_identity_matrix (cr);
		cairo_move_to (cr, (double) SPEK_SPECTROGRAM_LPAD, (double) (SPEK_SPECTROGRAM_TPAD - SPEK_SPECTROGRAM_GAP));
		pango_layout_set_font_description (layout, _tmp20_ = pango_font_description_from_string (_tmp19_ = g_strconcat ("Sans ", _tmp18_ = double_to_string (9 * self->priv->FONT_SCALE), NULL)));
		_pango_font_description_free0 (_tmp20_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp18_);
		pango_layout_set_width (layout, ((gint) ((_data2_->w - SPEK_SPECTROGRAM_LPAD) - SPEK_SPECTROGRAM_RPAD)) * PANGO_SCALE);
		pango_layout_set_ellipsize (layout, PANGO_ELLIPSIZE_END);
		pango_layout_set_text (layout, self->priv->info, -1);
		pango_cairo_show_layout_line (cr, pango_layout_get_line (layout, 0));
		pango_layout_get_pixel_size (layout, &text_width, &text_height);
		cairo_move_to (cr, (double) SPEK_SPECTROGRAM_LPAD, (double) ((SPEK_SPECTROGRAM_TPAD - (2 * SPEK_SPECTROGRAM_GAP)) - text_height));
		pango_layout_set_font_description (layout, _tmp23_ = pango_font_description_from_string (_tmp22_ = g_strconcat ("Sans Bold ", _tmp21_ = double_to_string (10 * self->priv->FONT_SCALE), NULL)));
		_pango_font_description_free0 (_tmp23_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp21_);
		pango_layout_set_width (layout, ((gint) ((_data2_->w - SPEK_SPECTROGRAM_LPAD) - SPEK_SPECTROGRAM_RPAD)) * PANGO_SCALE);
		pango_layout_set_ellipsize (layout, PANGO_ELLIPSIZE_START);
		pango_layout_set_text (layout, self->priv->_file_name, -1);
		pango_cairo_show_layout_line (cr, pango_layout_get_line (layout, 0));
		_g_object_unref0 (rate_ruler);
		_g_object_unref0 (time_ruler);
		block3_data_unref (_data3_);
	}
	cairo_set_source_rgb (cr, (double) 1, (double) 1, (double) 1);
	cairo_set_line_width (cr, (double) 1);
	cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
	cairo_rectangle (cr, (double) SPEK_SPECTROGRAM_LPAD, (double) SPEK_SPECTROGRAM_TPAD, (_data2_->w - SPEK_SPECTROGRAM_LPAD) - SPEK_SPECTROGRAM_RPAD, (_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD);
	cairo_stroke (cr);
	cairo_translate (cr, (_data2_->w - SPEK_SPECTROGRAM_RPAD) + SPEK_SPECTROGRAM_GAP, _data2_->h - SPEK_SPECTROGRAM_BPAD);
	cairo_scale (cr, (double) 1, (-(((_data2_->h - SPEK_SPECTROGRAM_TPAD) - SPEK_SPECTROGRAM_BPAD) + 1)) / cairo_image_surface_get_height (self->priv->palette));
	cairo_set_source_surface (cr, self->priv->palette, (double) 0, (double) 0);
	cairo_paint (cr);
	cairo_identity_matrix (cr);
	cairo_set_source_rgb (cr, (double) 1, (double) 1, (double) 1);
	cairo_set_line_width (cr, (double) 1);
	cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
	pango_layout_set_font_description (layout, _tmp26_ = pango_font_description_from_string (_tmp25_ = g_strconcat ("Sans ", _tmp24_ = double_to_string (8 * self->priv->FONT_SCALE), NULL)));
	_pango_font_description_free0 (_tmp26_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp24_);
	pango_layout_set_width (layout, -1);
	density_ruler = (_tmp29_ = spek_ruler_new (SPEK_RULER_POSITION_RIGHT, _ ("-00 dB"), (_tmp28_ = (_tmp27_ = g_new0 (gint, 6), _tmp27_[0] = 1, _tmp27_[1] = 2, _tmp27_[2] = 5, _tmp27_[3] = 10, _tmp27_[4] = 20, _tmp27_[5] = 50, _tmp27_), _tmp28__length1 = 6, _tmp28_), 6, -SPEK_SPECTROGRAM_THRESHOLD, 3.0, __lambda10__spek_ruler_measure, _data2_, __lambda11__spek_ruler_place, _data2_, __lambda12__spek_ruler_format_tick, self), _tmp28_ = (g_free (_tmp28_), NULL), _tmp29_);
	cairo_translate (cr, ((_data2_->w - SPEK_SPECTROGRAM_RPAD) + SPEK_SPECTROGRAM_GAP) + SPEK_SPECTROGRAM_RULER, (double) SPEK_SPECTROGRAM_TPAD);
	spek_ruler_draw (density_ruler, cr, layout);
	cairo_identity_matrix (cr);
	_g_object_unref0 (density_ruler);
	_g_object_unref0 (layout);
	block2_data_unref (_data2_);
}


static void spek_spectrogram_put_pixel (SpekSpectrogram* self, cairo_surface_t* surface, gint x, gint y, guint32 color) {
	gint i;
	gint data_length1;
	gint _data_size_;
	guchar* _tmp0_;
	guchar* data;
	guint32* p;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	i = (y * cairo_image_surface_get_stride (surface)) + (x * 4);
	data = (_tmp0_ = cairo_image_surface_get_data (surface), data_length1 = -1, _data_size_ = data_length1, _tmp0_);
	p = (guint32*) (&data[i]);
	*p = color;
}


static guint32 spek_spectrogram_get_color (SpekSpectrogram* self, double level) {
	guint32 result = 0U;
	double r;
	double g;
	double b;
	gboolean _tmp0_ = FALSE;
	double cf;
	gboolean _tmp5_ = FALSE;
	guint32 rr;
	guint32 gg;
	guint32 bb;
	g_return_val_if_fail (self != NULL, 0U);
	level = level * 0.6625;
	r = 0.0;
	g = 0.0;
	b = 0.0;
	if (level >= 0) {
		_tmp0_ = level < 0.15;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		r = (0.15 - level) / (0.15 + 0.075);
		g = 0.0;
		b = 1.0;
	} else {
		gboolean _tmp1_ = FALSE;
		if (level >= 0.15) {
			_tmp1_ = level < 0.275;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			r = 0.0;
			g = (level - 0.15) / (0.275 - 0.15);
			b = 1.0;
		} else {
			gboolean _tmp2_ = FALSE;
			if (level >= 0.275) {
				_tmp2_ = level < 0.325;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				r = 0.0;
				g = 1.0;
				b = (0.325 - level) / (0.325 - 0.275);
			} else {
				gboolean _tmp3_ = FALSE;
				if (level >= 0.325) {
					_tmp3_ = level < 0.5;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					r = (level - 0.325) / (0.5 - 0.325);
					g = 1.0;
					b = 0.0;
				} else {
					gboolean _tmp4_ = FALSE;
					if (level >= 0.5) {
						_tmp4_ = level < 0.6625;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						r = 1.0;
						g = (0.6625 - level) / (0.6625 - 0.5f);
						b = 0.0;
					}
				}
			}
		}
	}
	cf = 1.0;
	if (level >= 0.0) {
		_tmp5_ = level < 0.1;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		cf = level / 0.1;
	}
	cf = cf * 255.0;
	rr = (guint32) ((r * cf) + 0.5);
	gg = (guint32) ((g * cf) + 0.5);
	bb = (guint32) ((b * cf) + 0.5);
	result = ((rr << 16) + (gg << 8)) + bb;
	return result;
}


const char* spek_spectrogram_get_file_name (SpekSpectrogram* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file_name;
	return result;
}


static void spek_spectrogram_set_file_name (SpekSpectrogram* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_file_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_file_name), _tmp0_);
	g_object_notify ((GObject *) self, "file-name");
}


static void spek_spectrogram_class_init (SpekSpectrogramClass * klass) {
	spek_spectrogram_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpekSpectrogramPrivate));
	GTK_WIDGET_CLASS (klass)->size_allocate = spek_spectrogram_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->expose_event = spek_spectrogram_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = spek_spectrogram_get_property;
	G_OBJECT_CLASS (klass)->set_property = spek_spectrogram_set_property;
	G_OBJECT_CLASS (klass)->finalize = spek_spectrogram_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPEK_SPECTROGRAM_FILE_NAME, g_param_spec_string ("file-name", "file-name", "file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void spek_spectrogram_instance_init (SpekSpectrogram * self) {
	self->priv = SPEK_SPECTROGRAM_GET_PRIVATE (self);
	self->priv->FONT_SCALE = spek_platform_get_font_scale ();
	self->priv->prev_width = -1;
	self->priv->log10_threshold = log10 ((double) (-SPEK_SPECTROGRAM_THRESHOLD));
}


static void spek_spectrogram_finalize (GObject* obj) {
	SpekSpectrogram * self;
	self = SPEK_SPECTROGRAM (obj);
	_g_free0 (self->priv->_file_name);
	_spek_pipeline_unref0 (self->priv->pipeline);
	_g_free0 (self->priv->info);
	_cairo_surface_destroy0 (self->priv->image);
	_cairo_surface_destroy0 (self->priv->palette);
	G_OBJECT_CLASS (spek_spectrogram_parent_class)->finalize (obj);
}


GType spek_spectrogram_get_type (void) {
	static volatile gsize spek_spectrogram_type_id__volatile = 0;
	if (g_once_init_enter (&spek_spectrogram_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpekSpectrogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spek_spectrogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpekSpectrogram), 0, (GInstanceInitFunc) spek_spectrogram_instance_init, NULL };
		GType spek_spectrogram_type_id;
		spek_spectrogram_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "SpekSpectrogram", &g_define_type_info, 0);
		g_once_init_leave (&spek_spectrogram_type_id__volatile, spek_spectrogram_type_id);
	}
	return spek_spectrogram_type_id__volatile;
}


static void spek_spectrogram_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpekSpectrogram * self;
	self = SPEK_SPECTROGRAM (object);
	switch (property_id) {
		case SPEK_SPECTROGRAM_FILE_NAME:
		g_value_set_string (value, spek_spectrogram_get_file_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void spek_spectrogram_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpekSpectrogram * self;
	self = SPEK_SPECTROGRAM (object);
	switch (property_id) {
		case SPEK_SPECTROGRAM_FILE_NAME:
		spek_spectrogram_set_file_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




