/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../audio.h"
#include "graphic.h"

int
dialog_msg (char *what)
{
  GtkWidget *dialog;
  int ret;

  if (!what)
    return GTK_RESPONSE_OK;

  dialog =
    gtk_message_dialog_new (GTK_WINDOW (winmain),
			    GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT,
			    GTK_MESSAGE_INFO, GTK_BUTTONS_OK, what);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  ret = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);

  return ret;
}

int
dialog_ask (char *what)
{
  GtkWidget *dialog;
  int ret;

  if (!what)
    return GTK_RESPONSE_OK;

  dialog =
    gtk_message_dialog_new (GTK_WINDOW (winmain),
			    GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT,
			    GTK_MESSAGE_INFO, GTK_BUTTONS_OK_CANCEL, what);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  ret = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);

  return ret;
}

int
dialog_test_file (char *file)
{
  struct stat st;
  char buf[1024];

  if (lstat (file, &st))
    return 0;

  snprintf (buf, 1024, "%s esists! Overwrite?", file);

  if (dialog_ask (buf) == GTK_RESPONSE_OK)
    return 0;
  return 1;
}

/* EOF */
