/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "gdaemon.h"

/* volume, balance, mute and solo of the inputs */

double
gdaemon_volume_get (daemon_client * c)
{
  return (double) c->volume;
}

double
gdaemon_volume_l_get (daemon_client * c)
{
  if (c->balance > 0)
    {
      return (double) (c->volume * (100 - c->balance) / 100);
    }

  return (double) c->volume;
}

double
gdaemon_volume_r_get (daemon_client * c)
{
  if (c->balance < 0)
    {
      return (double) (c->volume * (100 + c->balance) / 100);
    }

  return (double) c->volume;
}

void
on_dvolume_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));

  if (!user_data)
    play->volume = (int) v->value;
  else
    {
      daemon_client *c = (daemon_client *) user_data;

      c->volume = (int) v->value;
    }
}

void
on_dbalance_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));

  if (!stop_50_cent)
    {
      if (v->value > 45 && v->value < 55)
	{
	  gtk_adjustment_set_value (GTK_ADJUSTMENT (v), 50);
	  return;
	}
    }

  if (!user_data)
    play->balance = ((int) v->value * 2) - 100;
  else
    {
      daemon_client *c = (daemon_client *) user_data;

      c->balance = ((int) v->value * 2) - 100;
    }
}

void
on_mute_toggled (GtkWidget * widget, gpointer user_data)
{
  if (!user_data)
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
	{
	  msg_gstatusbar (_("General mute activate."));
	  play->mute = 1;
	}

      else
	{
	  msg_gstatusbar (_("General mute deactivate."));
	  play->mute = 0;
	}
    }
  else
    {
      daemon_client *c = (daemon_client *) user_data;

      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
	{
	  msg_gstatusbar (_("One mute activate."));
	  c->mute = 1;
	}

      else
	{
	  msg_gstatusbar (_("One mute deactivate."));
	  c->mute = 0;
	}
    }
}

void
on_solo_toggled (GtkWidget * widget, gpointer user_data)
{
  int i;
  daemon_client *c;

  if (!user_data)
    return;

  c = (daemon_client *) user_data;

  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      msg_gstatusbar (_("Solo activate."));

      c->solo = 1;

      for (i = 0; i < DAEMON_MAX_CLIENTS; i++)
	if (play->daemon->client[i] != NULL && play->daemon->client[i] != c)
	  {
	    play->daemon->client[i]->mute += 1;
	    gtk_widget_set_sensitive (play->daemon->client[i]->widget, FALSE);
	  }

    }
  else
    {
      msg_gstatusbar (_("Solo deactivate."));

      c->solo = 0;

      for (i = 0; i < DAEMON_MAX_CLIENTS; i++)
	if (play->daemon->client[i] != NULL && play->daemon->client[i] != c)
	  {
	    play->daemon->client[i]->mute -= 1;
	    gtk_widget_set_sensitive (play->daemon->client[i]->widget, TRUE);
	  }
    }
}

#endif

/* EOF */
